/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.wizard;

import com.android.tools.idea.ui.wizard.deprecated.StudioWizardLayout;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StudioWizardDialogBuilder {
    private static final float SCREEN_PERCENT = 0.8f;
    private boolean myUseNewUx = false;
    @NotNull
    ModelWizard myWizard;
    @NotNull
    String myTitle;
    @Nullable
    Component myParent;
    @Nullable
    Project myProject;
    @Nullable
    URL myHelpUrl;
    @NotNull
    DialogWrapper.IdeModalityType myModalityType = DialogWrapper.IdeModalityType.IDE;
    @Nullable
    Dimension myMinimumSize;
    @Nullable
    Dimension myPreferredSize;
    @NotNull
    ModelWizardDialog.CancellationPolicy myCancellationPolicy = ModelWizardDialog.CancellationPolicy.ALWAYS_CAN_CANCEL;

    public StudioWizardDialogBuilder(@NotNull ModelWizard wizard, @NotNull String title) {
        this.myWizard = wizard;
        this.myTitle = title;
    }

    public StudioWizardDialogBuilder(@NotNull ModelWizardStep step, @NotNull String title) {
        this(new ModelWizard.Builder(step).build(), title);
    }

    public StudioWizardDialogBuilder(@NotNull ModelWizard wizard, @NotNull String title, @Nullable Component parent) {
        this(wizard, title);
        this.myParent = parent;
    }

    @NotNull
    public StudioWizardDialogBuilder setProject(@Nullable Project project) {
        if (project != null) {
            this.myProject = project;
        }
        return this;
    }

    @NotNull
    public StudioWizardDialogBuilder setModalityType(@Nullable DialogWrapper.IdeModalityType modalityType) {
        if (modalityType != null) {
            this.myModalityType = modalityType;
        }
        return this;
    }

    @NotNull
    public StudioWizardDialogBuilder setMinimumSize(@Nullable Dimension minimumSize) {
        if (minimumSize != null) {
            this.myMinimumSize = minimumSize;
        }
        return this;
    }

    @NotNull
    public StudioWizardDialogBuilder setPreferredSize(@Nullable Dimension preferredSize) {
        if (preferredSize != null) {
            this.myPreferredSize = preferredSize;
        }
        return this;
    }

    @NotNull
    public StudioWizardDialogBuilder setHelpUrl(@Nullable URL helpUrl) {
        if (helpUrl != null) {
            this.myHelpUrl = helpUrl;
        }
        return this;
    }

    @NotNull
    public StudioWizardDialogBuilder setCancellationPolicy(@Nullable ModelWizardDialog.CancellationPolicy cancellationPolicy) {
        if (cancellationPolicy != null) {
            this.myCancellationPolicy = cancellationPolicy;
        }
        return this;
    }

    @NotNull
    public StudioWizardDialogBuilder setUseNewUx(boolean useNewUx) {
        this.myUseNewUx = useNewUx;
        return this;
    }

    @NotNull
    public ModelWizardDialog build() {
        ModelWizardDialog.CustomLayout customLayout;
        ModelWizardDialog.CustomLayout customLayout2 = customLayout = this.myUseNewUx ? new com.android.tools.idea.ui.wizard.StudioWizardLayout() : new StudioWizardLayout();
        if (this.myMinimumSize == null) {
            this.myMinimumSize = customLayout.getDefaultMinSize();
        }
        if (this.myPreferredSize == null) {
            this.myPreferredSize = customLayout.getDefaultPreferredSize();
        }
        ModelWizardDialog dialog = this.myParent != null ? new ModelWizardDialog(this.myWizard, this.myTitle, this.myParent, customLayout, this.myHelpUrl, this.myCancellationPolicy) : new ModelWizardDialog(this.myWizard, this.myTitle, customLayout, this.myProject, this.myHelpUrl, this.myModalityType, this.myCancellationPolicy);
        dialog.getContentPanel().setMinimumSize(StudioWizardDialogBuilder.getClampedSize(this.myMinimumSize));
        dialog.getContentPanel().setPreferredSize(StudioWizardDialogBuilder.getClampedSize(this.myPreferredSize));
        return dialog;
    }

    @NotNull
    private static Dimension getClampedSize(Dimension size) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return new Dimension(Math.min(size.width, (int)((float)screenSize.width * 0.8f)), Math.min(size.height, (int)((float)screenSize.height * 0.8f)));
    }
}

