/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.wizard;

import com.android.tools.adtui.validation.Validator;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WizardUtils {
    private static final int PACKAGE_LENGTH_LIMIT = 100;

    @NotNull
    public static File getProjectLocationParent() {
        String parent = RecentProjectsManager.getInstance().getLastProjectCreationLocation();
        if (parent == null) {
            String child = ApplicationNamesInfo.getInstance().getFullProductName().replace(" ", "") + "Projects";
            return new File(SystemProperties.getUserHome(), child);
        }
        return new File(parent.replace('/', File.separatorChar));
    }

    @Nullable
    public static String validatePackageName(@Nullable String packageName) {
        if (packageName.length() >= 100) {
            return AndroidBundle.message("android.wizard.module.package.too.long", new Object[0]);
        }
        packageName = packageName == null ? "" : packageName;
        return AndroidUtils.validateAndroidPackageName(packageName);
    }

    @NotNull
    public static String toHtmlString(@NotNull String text) {
        if (!StringUtil.isEmpty((String)text) && !text.startsWith("<html>")) {
            text = text.trim().replaceAll("\n", "<br>");
            return String.format("<html>%1$s</html>", text);
        }
        return text;
    }

    @NotNull
    public static URL toUrl(@NotNull String urlAsString) {
        URL url;
        try {
            url = new URL(urlAsString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return url;
    }

    public static String getUniqueName(String initialValue, Validator<String> validator) {
        String uniqueName = initialValue;
        for (int i = 2; i <= 100 && validator.validate((Object)uniqueName) != Validator.Result.OK; ++i) {
            uniqueName = initialValue + Integer.toString(i);
        }
        return uniqueName;
    }
}

