/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.tools.idea.uibuilder.util.JavaDocViewer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentHelpAction
extends AnAction {
    private final Project myProject;
    private final Supplier<String> myTagNameSupplier;

    public ComponentHelpAction(@NotNull Project project, @NotNull Supplier<String> tagNameSupplier) {
        this.myProject = project;
        this.myTagNameSupplier = tagNameSupplier;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        String tagName = this.myTagNameSupplier.get();
        if (tagName == null) {
            return;
        }
        PsiClass psiClass = this.findClassOfTagName(tagName);
        if (psiClass == null) {
            return;
        }
        JavaDocViewer.getInstance().showExternalJavaDoc(psiClass, event.getDataContext());
    }

    @Nullable
    private PsiClass findClassOfTagName(@NotNull String tagName) {
        if (tagName.indexOf(46) != -1) {
            return this.findClassByClassName(tagName);
        }
        PsiClass psiClass = this.findClassByClassName("android.widget." + tagName);
        if (psiClass != null) {
            return psiClass;
        }
        psiClass = this.findClassByClassName("android.view." + tagName);
        if (psiClass != null) {
            return psiClass;
        }
        return this.findClassByClassName("android.webkit." + tagName);
    }

    @Nullable
    private PsiClass findClassByClassName(@NotNull String fullyQualifiedClassName) {
        JavaPsiFacade javaFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        return javaFacade.findClass(fullyQualifiedClassName, GlobalSearchScope.allScope((Project)this.myProject));
    }
}

