/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.rendering.AttributeSnapshot;
import com.android.tools.idea.uibuilder.actions.ConvertToConstraintLayoutForm;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scout.Scout;
import com.android.tools.idea.uibuilder.scout.ScoutDirectConvert;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.usageView.UsageInfo;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToConstraintLayoutAction
extends AnAction {
    public static final String TITLE = "Convert to ConstraintLayout";
    public static final boolean ENABLED = true;
    public static final String ATTR_LAYOUT_CONVERSION_ABSOLUTE_WIDTH = "layout_conversion_absoluteWidth";
    public static final String ATTR_LAYOUT_CONVERSION_ABSOLUTE_HEIGHT = "layout_conversion_absoluteHeight";
    public static final String ATTR_LAYOUT_CONVERSION_WRAP_WIDTH = "layout_conversion_wrapWidth";
    public static final String ATTR_LAYOUT_CONVERSION_WRAP_HEIGHT = "layout_conversion_wrapHeight";
    private static final HashSet<String> ourExcludedTags = new HashSet<String>(Arrays.asList("layout", "data", "variable", "import"));
    private final NlDesignSurface mySurface;

    public ConvertToConstraintLayoutAction(@NotNull NlDesignSurface surface) {
        super(TITLE, TITLE, null);
        this.mySurface = surface;
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        ScreenView screenView = this.mySurface.getCurrentSceneView();
        NlComponent target = ConvertToConstraintLayoutAction.findTarget(screenView);
        if (target != null) {
            String tagName = target.getTagName();
            if (NlComponentHelperKt.isOrHasSuperclass(target, "android.support.constraint.ConstraintLayout")) {
                presentation.setVisible(false);
                return;
            }
            if (ourExcludedTags.contains(tagName)) {
                presentation.setVisible(false);
                return;
            }
            presentation.setVisible(true);
            tagName = tagName.substring(tagName.lastIndexOf(46) + 1);
            presentation.setText("Convert " + tagName + " to ConstraintLayout");
            presentation.setEnabled(true);
        } else {
            presentation.setText(TITLE);
            presentation.setEnabled(false);
            presentation.setVisible(true);
        }
    }

    @Nullable
    private static NlComponent findTarget(@Nullable ScreenView screenView) {
        ImmutableList<NlComponent> selection;
        if (screenView != null && (selection = screenView.getSelectionModel().getSelection()).size() == 1) {
            NlComponent selected;
            for (selected = (NlComponent)selection.get(0); selected != null && !selected.isRoot() && selected.getChildren().isEmpty(); selected = selected.getParent()) {
            }
            return selected;
        }
        return null;
    }

    public void actionPerformed(AnActionEvent e) {
        ScreenView screenView = this.mySurface.getCurrentSceneView();
        if (screenView == null) {
            return;
        }
        NlComponent target = ConvertToConstraintLayoutAction.findTarget(screenView);
        if (target == null) {
            return;
        }
        Project project = this.mySurface.getProject();
        ConvertToConstraintLayoutForm dialog = new ConvertToConstraintLayoutForm(project);
        if (!dialog.showAndGet()) {
            return;
        }
        boolean flatten = dialog.getFlattenHierarchy();
        boolean includeIds = dialog.getFlattenReferenced();
        boolean includeCustomViews = dialog.getIncludeCustomViews();
        GradleDependencyManager manager = GradleDependencyManager.getInstance(project);
        GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)"com.android.support.constraint:constraint-layout:+");
        if (!manager.ensureLibraryIsIncluded(screenView.getModel().getModule(), Collections.singletonList(coordinate), null)) {
            return;
        }
        ConstraintLayoutConverter converter = new ConstraintLayoutConverter(screenView, target, flatten, includeIds, includeCustomViews);
        converter.execute();
    }

    private static void inferConstraints(@NotNull NlComponent target) {
        try {
            Scout.inferConstraintsFromConvert(target);
            ArrayList<NlComponent> list = new ArrayList<NlComponent>(target.getChildren());
            list.add(0, target);
            for (NlComponent component2 : list) {
                AttributesTransaction transaction = component2.startAttributeTransaction();
                transaction.commit();
            }
            ConvertToConstraintLayoutAction.removeAbsolutePositionAndSizes(target);
        }
        catch (Throwable t) {
            Logger.getInstance(ConvertToConstraintLayoutAction.class).warn(t);
        }
    }

    private static void removeAbsolutePositionAndSizes(NlComponent component2) {
        for (NlComponent child : component2.getChildren()) {
            child.setAttribute("http://schemas.android.com/tools", ATTR_LAYOUT_CONVERSION_ABSOLUTE_WIDTH, null);
            child.setAttribute("http://schemas.android.com/tools", ATTR_LAYOUT_CONVERSION_ABSOLUTE_HEIGHT, null);
            child.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", null);
            child.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", null);
            child.setAttribute("http://schemas.android.com/tools", ATTR_LAYOUT_CONVERSION_WRAP_WIDTH, null);
            child.setAttribute("http://schemas.android.com/tools", ATTR_LAYOUT_CONVERSION_WRAP_HEIGHT, null);
            ConvertToConstraintLayoutAction.removeAbsolutePositionAndSizes(child);
        }
    }

    private static class ConstraintLayoutConverter
    extends WriteCommandAction {
        private static final boolean DIRECT_INFERENCE = true;
        private final ScreenView myScreenView;
        private final boolean myFlatten;
        private final boolean myIncludeIds;
        private final boolean myIncludeCustomViews;
        private ViewEditorImpl myEditor;
        private List<NlComponent> myToBeFlattened;
        private NlComponent myRoot;
        private NlComponent myLayout;

        public ConstraintLayoutConverter(@NotNull ScreenView screenView, @NotNull NlComponent target, boolean flatten, boolean includeIds, boolean includeCustomViews) {
            super(screenView.getSurface().getProject(), ConvertToConstraintLayoutAction.TITLE, new PsiFile[]{screenView.getModel().getFile()});
            this.myScreenView = screenView;
            this.myFlatten = flatten;
            this.myIncludeIds = includeIds;
            this.myIncludeCustomViews = includeCustomViews;
            this.myLayout = target;
            this.myRoot = (NlComponent)this.myScreenView.getModel().getComponents().get(0);
            this.myEditor = new ViewEditorImpl(this.myScreenView);
        }

        protected void run(@NotNull Result result) throws Throwable {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (this.myLayout == null) {
                return;
            }
            NlComponentHelperKt.ensureId(this.myLayout);
            boolean directConvert = true;
            if (this.myFlatten) {
                for (NlComponent child : this.myLayout.getChildren()) {
                    if (!this.isLayout(child)) continue;
                    directConvert = false;
                }
            }
            if (directConvert && ScoutDirectConvert.directProcess(this.myLayout)) {
                return;
            }
            this.myToBeFlattened = Lists.newArrayList();
            this.processComponent(this.myLayout);
            this.flatten();
            PsiElement tag = this.myLayout.getTag().setName("android.support.constraint.ConstraintLayout");
            NlModel model = this.myLayout.getModel();
            XmlTag layoutTag = this.myLayout.getTag();
            XmlTag rootTag = this.myRoot.getTag();
            this.myScreenView.getSurface().getSceneManager().layout(false);
            this.myRoot = model.findViewByTag(rootTag);
            this.myLayout = model.findViewByTag(layoutTag);
            tag = CodeStyleManager.getInstance((Project)this.getProject()).reformat(tag);
            this.myLayout.getModel().syncWithPsi((XmlTag)tag, Collections.emptyList());
            final String id = this.myLayout.getId();
            this.myScreenView.getModel().addListener(new ModelListener(){

                @Override
                public void modelRendered(@NotNull NlModel model) {
                    assert (id != null);
                    NlComponent layout = myScreenView.getModel().find(id);
                    NlWriteCommandAction action = new NlWriteCommandAction(Collections.singletonList(layout), "Infer Constraints", () -> {
                        if (layout != null) {
                            Map<NlComponent, Dimension> sizes = myEditor.measureChildren(layout, null);
                            assert (sizes != null);
                            for (NlComponent component2 : sizes.keySet()) {
                                Dimension d = sizes.get(component2);
                                component2.setAttribute("http://schemas.android.com/tools", ConvertToConstraintLayoutAction.ATTR_LAYOUT_CONVERSION_WRAP_WIDTH, Integer.toString(d.width));
                                component2.setAttribute("http://schemas.android.com/tools", ConvertToConstraintLayoutAction.ATTR_LAYOUT_CONVERSION_WRAP_HEIGHT, Integer.toString(d.height));
                            }
                            ConvertToConstraintLayoutAction.inferConstraints(layout);
                            myScreenView.getModel().removeListener(this);
                        }
                    });
                    ApplicationManager.getApplication().invokeLater((Runnable)action);
                }

                @Override
                public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
                }
            });
        }

        private void processComponent(NlComponent component2) {
            for (NlComponent child : component2.getChildren()) {
                int dpx = this.myEditor.pxToDp(NlComponentHelperKt.getX(child) - NlComponentHelperKt.getX(this.myRoot));
                int dpy = this.myEditor.pxToDp(NlComponentHelperKt.getY(child) - NlComponentHelperKt.getY(this.myRoot));
                int dpw = this.myEditor.pxToDp(NlComponentHelperKt.getW(child));
                int dph = this.myEditor.pxToDp(NlComponentHelperKt.getH(child));
                AttributesTransaction transaction = child.startAttributeTransaction();
                transaction.setAttribute("http://schemas.android.com/tools", ConvertToConstraintLayoutAction.ATTR_LAYOUT_CONVERSION_ABSOLUTE_WIDTH, String.format(Locale.ROOT, "%ddp", dpw));
                transaction.setAttribute("http://schemas.android.com/tools", ConvertToConstraintLayoutAction.ATTR_LAYOUT_CONVERSION_ABSOLUTE_HEIGHT, String.format(Locale.ROOT, "%ddp", dph));
                transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", String.format(Locale.ROOT, "%ddp", dpx));
                transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", String.format(Locale.ROOT, "%ddp", dpy));
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", "wrap_content");
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", "wrap_content");
                transaction.commit();
                List toDelete = null;
                for (AttributeSnapshot attribute : child.getAttributes()) {
                    String name = attribute.name;
                    if (!name.startsWith("layout_") || !"http://schemas.android.com/apk/res/android".equals(attribute.namespace) || name.equals("layout_width") || name.equals("layout_height")) continue;
                    if (toDelete == null) {
                        toDelete = Lists.newArrayList();
                    }
                    toDelete.add(name);
                }
                if (toDelete != null) {
                    for (String name : toDelete) {
                        child.setAttribute("http://schemas.android.com/apk/res/android", name, null);
                    }
                }
                if (this.isLayout(child)) {
                    if (!this.myFlatten || !this.shouldFlatten(child)) continue;
                    this.myToBeFlattened.add(child);
                }
                this.processComponent(child);
            }
        }

        private void flatten() {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.getProject());
            Document document = documentManager.getDocument((PsiFile)this.myScreenView.getModel().getFile());
            if (document == null) {
                return;
            }
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            ArrayList ranges = Lists.newArrayList();
            for (NlComponent component2 : this.myToBeFlattened) {
                XmlTag tag = component2.getTag();
                PsiElement openStart = null;
                PsiElement openEnd = null;
                PsiElement closeStart = null;
                PsiElement closeEnd = null;
                for (PsiElement curr = tag.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
                    IElementType elementType = curr.getNode().getElementType();
                    if (elementType == XmlTokenType.XML_START_TAG_START) {
                        openStart = curr;
                        continue;
                    }
                    if (elementType == XmlTokenType.XML_TAG_END) {
                        if (closeStart == null) {
                            openEnd = curr;
                            continue;
                        }
                        closeEnd = curr;
                        break;
                    }
                    if (elementType == XmlTokenType.XML_END_TAG_START) {
                        closeStart = curr;
                        continue;
                    }
                    if (elementType != XmlTokenType.XML_EMPTY_ELEMENT_END) continue;
                    openEnd = curr;
                    break;
                }
                if (openStart == null || openEnd == null || closeStart == null || closeEnd == null) continue;
                ranges.add(new TextRange(openStart.getTextOffset(), openEnd.getTextOffset() + openEnd.getTextLength()));
                ranges.add(new TextRange(closeStart.getTextOffset(), closeEnd.getTextOffset() + closeEnd.getTextLength()));
            }
            ranges.sort((o1, o2) -> o2.getStartOffset() - o1.getStartOffset());
            for (TextRange range : ranges) {
                document.deleteString(range.getStartOffset(), range.getEndOffset());
            }
            documentManager.commitDocument(document);
        }

        private boolean isLayout(@NotNull NlComponent component2) {
            Object viewObject;
            NlComponent child;
            if (!this.myIncludeCustomViews && ConstraintLayoutConverter.isCustomView(component2)) {
                return false;
            }
            List<NlComponent> children = component2.getChildren();
            if (children.size() > 1) {
                return true;
            }
            if (children.size() == 1 && !"requestFocus".equals((child = children.get(0)).getTagName())) {
                return true;
            }
            ViewInfo info = NlComponentHelperKt.getViewInfo(component2);
            if (info != null && (viewObject = info.getViewObject()) != null) {
                for (Class<?> cls = viewObject.getClass(); cls != null; cls = cls.getSuperclass()) {
                    String fqcn = cls.getName();
                    if ("android.widget.AdapterView".equals(fqcn)) {
                        return false;
                    }
                    if (fqcn.startsWith("android.webkit.") && fqcn.endsWith("WebView")) {
                        return false;
                    }
                    if (!"android.view.ViewGroup".equals(fqcn)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isCustomView(NlComponent component2) {
            String tag = component2.getTagName();
            return tag.indexOf(46) != -1;
        }

        private boolean shouldFlatten(@NotNull NlComponent component2) {
            XmlAttributeValue valueElement;
            XmlAttribute attribute;
            if (!this.myIncludeCustomViews && ConstraintLayoutConverter.isCustomView(component2)) {
                return false;
            }
            if (component2.getAttribute("http://schemas.android.com/apk/res/android", "background") != null || component2.getAttribute("http://schemas.android.com/apk/res/android", "foreground") != null) {
                return false;
            }
            String id = component2.getAttribute("http://schemas.android.com/apk/res/android", "id");
            if (id == null) {
                return true;
            }
            if (!this.myIncludeIds && (attribute = component2.getTag().getAttribute("id", "http://schemas.android.com/apk/res/android")) != null && (valueElement = attribute.getValueElement()) != null && valueElement.isValid()) {
                UsageInfo[] usages;
                RenameProcessor processor = new RenameProcessor(this.myScreenView.getSurface().getProject(), (PsiElement)valueElement, "NONEXISTENT_ID12345", false, false);
                processor.setPreviewUsages(false);
                XmlFile layoutFile = this.myScreenView.getModel().getFile();
                for (UsageInfo info : usages = processor.findUsages()) {
                    PsiFile file = info.getFile();
                    if (layoutFile.equals(file)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

