/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.android.dom.layout.AndroidLayoutUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MorphDialog
extends JPanel {
    public static final String MORPH_DIALOG_NAME = "MorphDialog";
    private final AndroidFacet myFacet;
    private final Project myProject;
    private final JComponent myCodePreview;
    private JBLabel myNewTagLabel;
    private TextFieldWithCompletion myNewTagText;
    private JPanel myRoot;
    private JButton myOkButton;
    private Consumer<String> myOkAction;
    @Nullable
    private Consumer<String> myNameChangeConsumer;

    public MorphDialog(@NotNull AndroidFacet facet, @NotNull Project project, @NotNull JComponent codePreviewEditor, @NotNull String oldTag) {
        this.myFacet = facet;
        this.myProject = project;
        this.myCodePreview = codePreviewEditor;
        this.$$$setupUI$$$();
        this.setName(MORPH_DIALOG_NAME);
        this.setFocusable(true);
        this.myOkButton.addActionListener(e -> this.doOkAction());
        this.setupTextTagField(oldTag);
    }

    private void setupTextTagField(@NotNull String oldTag) {
        this.myNewTagText.addDocumentListener((DocumentListener)this.createDocumentListener());
        this.myNewTagText.setText(oldTag);
        this.myNewTagText.registerKeyboardAction(e -> this.doOkAction(), KeyStroke.getKeyStroke(10, 0), 2);
        this.myNewTagText.setRequestFocusEnabled(true);
        this.myNewTagText.requestFocusInWindow();
        this.myNewTagText.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                MorphDialog.this.myNewTagText.selectAll();
            }
        });
    }

    void doOkAction() {
        if (this.myOkAction != null) {
            this.myOkAction.consume((Object)this.myNewTagText.getText());
        }
    }

    @NotNull
    private DocumentAdapter createDocumentListener() {
        return new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                if (MorphDialog.this.myNameChangeConsumer != null) {
                    MorphDialog.this.myNameChangeConsumer.consume((Object)e.getDocument().getText());
                }
            }
        };
    }

    public void createUIComponents() {
        this.myRoot = this;
        this.myNewTagText = this.createAutoCompleteTagField();
    }

    @NotNull
    private TextFieldWithCompletion createAutoCompleteTagField() {
        List<String> possibleRoots = AndroidLayoutUtil.getPossibleRoots(this.myFacet);
        Collections.sort(possibleRoots);
        TextFieldWithAutoCompletion.StringsCompletionProvider completionProvider = new TextFieldWithAutoCompletion.StringsCompletionProvider(possibleRoots, null);
        return new TextFieldWithAutoCompletion(this.myProject, (TextFieldWithAutoCompletionListProvider)completionProvider, true, null);
    }

    public void setOkAction(@Nullable Consumer<String> okAction) {
        this.myOkAction = okAction;
    }

    public void setTagNameChangeConsumer(@Nullable Consumer<String> consumer) {
        this.myNameChangeConsumer = consumer;
    }

    @NotNull
    public Component getPreferredFocusComponent() {
        return this.myNewTagText;
    }

    void setTagNameText(String name) {
        this.myNewTagLabel.setText(name);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JBLabel jBLabel;
        this.createUIComponents();
        JPanel jPanel = this.myRoot;
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        this.myNewTagLabel = jBLabel = new JBLabel();
        jBLabel.setText("Morph View type to:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TextFieldWithCompletion textFieldWithCompletion = this.myNewTagText;
        jPanel.add((Component)textFieldWithCompletion, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        JComponent jComponent = this.myCodePreview;
        jPanel.add((Component)jComponent, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myOkButton = jButton = new JButton();
        jButton.setText("Apply");
        jPanel.add((Component)jButton, new GridConstraints(2, 1, 1, 1, 4, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }
}

