/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.adaptiveicon;

import com.android.resources.Density;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import org.jetbrains.annotations.NotNull;

public class DensityMenuAction
extends DropDownAction {
    private static final Density[] DENSITIES = new Density[]{Density.MEDIUM, Density.HIGH, Density.XHIGH, Density.XXHIGH, Density.XXXHIGH};
    private final NlModel myModel;

    public DensityMenuAction(@NotNull NlModel model) {
        super("", "Device Screen Density", null);
        this.myModel = model;
        for (Density density : DENSITIES) {
            this.add(new SetDensityAction(this.myModel, density));
        }
    }

    public void update(AnActionEvent e) {
        super.update(e);
        int currentValue = this.myModel.getConfiguration().getDensity().getDpiValue();
        for (int i = 0; i < DENSITIES.length; ++i) {
            if (DENSITIES[i].getDpiValue() < currentValue && i != DENSITIES.length - 1) continue;
            e.getPresentation().setText(DENSITIES[i].getResourceValue());
            break;
        }
    }

    private static class SetDensityAction
    extends AnAction {
        private final NlModel myModel;
        private final Density myDensity;

        private SetDensityAction(@NotNull NlModel model, @NotNull Density density) {
            super(density.getResourceValue());
            this.myModel = model;
            this.myDensity = density;
        }

        public void actionPerformed(AnActionEvent e) {
            NlModelHelperKt.overrideConfigurationDensity(this.myModel, this.myDensity);
        }
    }
}

