/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.uibuilder.api.ResizeHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.model.MarginType;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.Segment;
import com.android.tools.idea.uibuilder.model.SegmentType;
import com.intellij.psi.xml.XmlTag;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultResizeHandler
extends ResizeHandler {
    public Rectangle bounds;
    public Dimension wrapBounds;
    public boolean wrapWidth;
    public boolean wrapHeight;
    public boolean fillWidth;
    public boolean fillHeight;
    public Segment horizontalFillSegment;
    public Segment verticalFillSegment;

    public DefaultResizeHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull NlComponent component2, @Nullable SegmentType horizontalEdgeType, @Nullable SegmentType verticalEdgeType) {
        super(editor, handler, component2, horizontalEdgeType, verticalEdgeType);
        Map<NlComponent, Dimension> sizes = editor.measureChildren(this.layout, new RenderTask.AttributeFilter(){

            @Override
            public String getAttribute(@NotNull XmlTag n, @Nullable String namespace, @NotNull String localName) {
                if ("layout_width".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                    return "wrap_content";
                }
                if ("layout_height".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                    return "wrap_content";
                }
                return null;
            }
        });
        if (sizes != null) {
            this.wrapBounds = sizes.get(component2);
        }
    }

    @Override
    @Nullable
    public String update(int x, int y, int modifiers, @NotNull Rectangle newBounds) {
        super.update(x, y, modifiers, newBounds);
        this.bounds = newBounds;
        this.wrapHeight = false;
        this.wrapWidth = false;
        if (this.wrapBounds != null) {
            Dimension b = this.wrapBounds;
            int maxMatchDistance = 20;
            if (this.horizontalEdgeType != null && Math.abs(newBounds.height - b.height) < maxMatchDistance) {
                this.wrapHeight = true;
                if (this.horizontalEdgeType == SegmentType.TOP) {
                    newBounds.y += newBounds.height - b.height;
                }
                newBounds.height = b.height;
            }
            if (this.verticalEdgeType != null && Math.abs(newBounds.width - b.width) < maxMatchDistance) {
                this.wrapWidth = true;
                if (this.verticalEdgeType == SegmentType.LEFT) {
                    newBounds.x += newBounds.width - b.width;
                }
                newBounds.width = b.width;
            }
        }
        this.horizontalFillSegment = null;
        this.fillHeight = false;
        Rectangle parentBounds = new Rectangle(NlComponentHelperKt.getX(this.layout), NlComponentHelperKt.getY(this.layout), NlComponentHelperKt.getW(this.layout), NlComponentHelperKt.getH(this.layout));
        if (this.horizontalEdgeType == SegmentType.BOTTOM && !this.wrapHeight) {
            this.horizontalFillSegment = new Segment(parentBounds.y + parentBounds.height, newBounds.x, newBounds.x + newBounds.width, null, null, SegmentType.BOTTOM, MarginType.NO_MARGIN);
            if (Math.abs(newBounds.y + newBounds.height - (parentBounds.y + parentBounds.height)) < 20) {
                this.fillHeight = true;
                newBounds.height = parentBounds.y + parentBounds.height - newBounds.y;
            }
        }
        this.verticalFillSegment = null;
        this.fillWidth = false;
        if (this.verticalEdgeType == SegmentType.RIGHT && !this.wrapWidth) {
            this.verticalFillSegment = new Segment(parentBounds.x + parentBounds.width, newBounds.y, newBounds.y + newBounds.height, null, null, SegmentType.RIGHT, MarginType.NO_MARGIN);
            if (Math.abs(newBounds.x + newBounds.width - (parentBounds.x + parentBounds.width)) < 20) {
                this.fillWidth = true;
                newBounds.width = parentBounds.x + parentBounds.width - newBounds.x;
            }
        }
        return null;
    }

    @Override
    public void commit(int px, int py, int modifiers, @NotNull Rectangle newBounds) {
        NlComponent parent = this.component.getParent();
        if (parent == null) {
            return;
        }
        this.setNewSizeBounds(this.component, parent, new Rectangle(NlComponentHelperKt.getX(this.component), NlComponentHelperKt.getY(this.component), NlComponentHelperKt.getW(this.component), NlComponentHelperKt.getH(this.component)), newBounds, this.horizontalEdgeType, this.verticalEdgeType);
    }

    @Override
    public void paint(@NotNull NlGraphics graphics) {
        block23: {
            int x;
            Rectangle b;
            block26: {
                int wrapHeight1;
                int wrapWidth1;
                block24: {
                    int y;
                    block25: {
                        Segment s;
                        graphics.useStyle(NlDrawingStyle.RESIZE_PREVIEW);
                        if (this.bounds == null) {
                            return;
                        }
                        b = this.bounds;
                        graphics.drawRect(b.x, b.y, b.width, b.height);
                        if (this.horizontalFillSegment != null) {
                            graphics.useStyle(NlDrawingStyle.GUIDELINE);
                            s = this.horizontalFillSegment;
                            graphics.drawLine(s.from, s.at, s.to, s.at);
                        }
                        if (this.verticalFillSegment != null) {
                            graphics.useStyle(NlDrawingStyle.GUIDELINE);
                            s = this.verticalFillSegment;
                            graphics.drawLine(s.at, s.from, s.at, s.to);
                        }
                        if (this.wrapBounds == null) break block23;
                        graphics.useStyle(NlDrawingStyle.GUIDELINE);
                        wrapWidth1 = this.wrapBounds.width;
                        wrapHeight1 = this.wrapBounds.height;
                        if (this.horizontalEdgeType == null) break block24;
                        y = -1;
                        switch (this.horizontalEdgeType) {
                            case TOP: {
                                y = b.y + b.height - wrapHeight1;
                                break;
                            }
                            case BOTTOM: {
                                y = b.y + wrapHeight1;
                                break;
                            }
                            default: {
                                assert (false) : this.horizontalEdgeType;
                                break;
                            }
                        }
                        if (this.verticalEdgeType == null) break block25;
                        switch (this.verticalEdgeType) {
                            case LEFT: {
                                graphics.drawLine(b.x + b.width - wrapWidth1, y, b.x + b.width, y);
                                break block24;
                            }
                            case RIGHT: {
                                graphics.drawLine(b.x, y, b.x + wrapWidth1, y);
                                break block24;
                            }
                            default: {
                                assert (false) : this.verticalEdgeType;
                                break block24;
                            }
                        }
                    }
                    graphics.drawLine(b.x, y, b.x + b.width, y);
                }
                if (this.verticalEdgeType == null) break block23;
                x = -1;
                switch (this.verticalEdgeType) {
                    case LEFT: {
                        x = b.x + b.width - wrapWidth1;
                        break;
                    }
                    case RIGHT: {
                        x = b.x + wrapWidth1;
                        break;
                    }
                    default: {
                        assert (false) : this.verticalEdgeType;
                        break;
                    }
                }
                if (this.horizontalEdgeType == null) break block26;
                switch (this.horizontalEdgeType) {
                    case TOP: {
                        graphics.drawLine(x, b.y + b.height - wrapHeight1, x, b.y + b.height);
                        break block23;
                    }
                    case BOTTOM: {
                        graphics.drawLine(x, b.y, x, b.y + wrapHeight1);
                        break block23;
                    }
                    default: {
                        assert (false) : this.horizontalEdgeType;
                        break block23;
                    }
                }
            }
            graphics.drawLine(x, b.y, x, b.y + b.height);
        }
    }

    @NotNull
    public String getWidthAttribute() {
        if (this.wrapWidth) {
            return "wrap_content";
        }
        if (this.fillWidth) {
            return "match_parent";
        }
        return String.format("%ddp", this.editor.pxToDp(this.bounds.width));
    }

    @NotNull
    public String getHeightAttribute() {
        if (this.wrapHeight) {
            return "wrap_content";
        }
        if (this.fillHeight) {
            return "match_parent";
        }
        return String.format("%ddp", this.editor.pxToDp(this.bounds.height));
    }

    @Nullable
    protected String getResizeUpdateMessage(@NotNull NlComponent child, @NotNull NlComponent parent, @NotNull Rectangle newBounds, @Nullable SegmentType horizontalEdge, @Nullable SegmentType verticalEdge) {
        String width = this.getWidthAttribute();
        String height = this.getHeightAttribute();
        if (horizontalEdge == null) {
            return width;
        }
        if (verticalEdge == null) {
            return height;
        }
        return String.format("%s \u00d7 %s", width, height);
    }

    protected void setNewSizeBounds(@NotNull NlComponent component2, @NotNull NlComponent layout, @NotNull Rectangle oldBounds, @NotNull Rectangle newBounds, @Nullable SegmentType horizontalEdge, @Nullable SegmentType verticalEdge) {
        if (verticalEdge != null && (newBounds.width != oldBounds.width || this.wrapWidth || this.fillWidth)) {
            component2.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", this.getWidthAttribute());
        }
        if (horizontalEdge != null && (newBounds.height != oldBounds.height || this.wrapHeight || this.fillHeight)) {
            component2.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", this.getHeightAttribute());
        }
    }
}

