/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.intellij.openapi.module.Module;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DragHandler {
    @NotNull
    protected final ViewEditor editor;
    @NotNull
    protected final ViewGroupHandler handler;
    @NotNull
    protected final List<NlComponent> components;
    @NotNull
    protected SceneComponent layout;
    @NotNull
    protected DragType type = DragType.COPY;
    protected int startX;
    protected int startY;
    protected int lastX;
    protected int lastY;
    protected int lastModifiers;

    protected DragHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull SceneComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        this.editor = editor;
        this.handler = handler;
        this.layout = layout;
        this.components = components;
        this.type = type;
    }

    public void setDragType(@NotNull DragType type) {
        this.type = type;
    }

    public void cancel() {
    }

    public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
        this.insertComponents(-1, insertType);
    }

    public void start(int x, int y, int modifiers) {
        this.startX = x;
        this.startY = y;
        this.lastModifiers = modifiers;
    }

    @Nullable
    public String update(int x, int y, int modifiers) {
        this.lastX = x;
        this.lastY = y;
        this.lastModifiers = modifiers;
        return null;
    }

    public void paint(@NotNull NlGraphics graphics) {
    }

    protected final boolean canInsertComponents(int insertIndex, @NotNull InsertType insertType) {
        NlModel model = this.editor.getModel();
        if (!model.canAddComponents(this.components, this.layout.getNlComponent(), this.getChild(insertIndex))) {
            return false;
        }
        List<GradleCoordinate> dependencies2 = this.getMissingDependencies(this.components);
        if (dependencies2.isEmpty()) {
            return true;
        }
        return GradleDependencyManager.userWantToAddDependencies(model.getModule(), dependencies2);
    }

    protected final void insertComponents(int insertIndex, @NotNull InsertType insertType) {
        this.addMissingDependencies();
        this.editor.getModel().addComponents(this.components, this.layout.getNlComponent(), this.getChild(insertIndex), insertType);
    }

    private void addMissingDependencies() {
        List<GradleCoordinate> dependencies2 = this.getMissingDependencies(this.components);
        if (dependencies2.isEmpty()) {
            return;
        }
        Module module = this.editor.getModel().getModule();
        GradleBuildModel model = GradleBuildModel.get(module);
        if (model == null) {
            return;
        }
        GradleDependencyManager.addDependenciesInTransaction(model, module, dependencies2, null);
    }

    @Nullable
    private NlComponent getChild(int i) {
        return 0 <= i && i < this.layout.getChildCount() ? this.layout.getNlComponent().getChild(i) : null;
    }

    @NotNull
    private List<GradleCoordinate> getMissingDependencies(@NotNull Iterable<NlComponent> components) {
        HashSet artifacts = new HashSet();
        components.forEach(component2 -> NlComponentHelperKt.getDependencies(component2, artifacts));
        List<GradleCoordinate> dependencies2 = artifacts.stream().map(artifact -> GradleCoordinate.parseCoordinateString((String)(artifact + ":+"))).filter(Objects::nonNull).collect(Collectors.toList());
        if (dependencies2.isEmpty()) {
            return dependencies2;
        }
        Module module = this.editor.getModel().getModule();
        return GradleDependencyManager.getInstance(module.getProject()).findMissingDependencies(module, dependencies2);
    }
}

