/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.xml.XmlBuilder;
import icons.AndroidIcons;
import javax.swing.Icon;
import org.intellij.lang.annotations.Language;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.annotations.NotNull;

public abstract class PaletteComponentHandler {
    @Language(value="XML")
    public static final String NO_PREVIEW = "";
    public static final String IN_PLATFORM = "";

    @NotNull
    public String getTitle(@NotNull String tagName) {
        return PaletteComponentHandler.getSimpleTagName(tagName);
    }

    @NotNull
    public Icon getIcon(@NotNull String tagName) {
        return this.loadBuiltinIcon(tagName);
    }

    @NotNull
    public Icon getLargeIcon(@NotNull String tagName) {
        return this.loadBuiltinLargeIcon(tagName);
    }

    @NotNull
    public String getGradleCoordinateId(@NotNull NlComponent component2) {
        return this.getGradleCoordinateId(component2.getTagName());
    }

    @NotNull
    public String getGradleCoordinateId(@NotNull String tagName) {
        return PaletteComponentHandler.getBuiltinCoordinate(tagName);
    }

    @NotNull
    @Language(value="XML")
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        return new XmlBuilder().startTag(tagName).androidAttribute("layout_width", "wrap_content").androidAttribute("layout_height", "wrap_content").endTag(tagName).toString();
    }

    public double getPreviewScale(@NotNull String tagName) {
        return 1.0;
    }

    @NotNull
    protected static String getSimpleTagName(@NotNull String tagName) {
        int lastIndex = tagName.lastIndexOf(46);
        return lastIndex < 0 ? tagName : tagName.substring(lastIndex + 1);
    }

    @NotNull
    protected Icon loadBuiltinIcon(@NotNull String tagName) {
        Icon icon = AndroidDomElementDescriptorProvider.getIconForViewTag(PaletteComponentHandler.getSimpleTagName(tagName));
        return icon != null ? icon : AndroidIcons.Views.Unknown;
    }

    @NotNull
    protected Icon loadBuiltinLargeIcon(@NotNull String tagName) {
        Icon icon = AndroidDomElementDescriptorProvider.getLargeIconForViewTag(PaletteComponentHandler.getSimpleTagName(tagName));
        return icon != null ? icon : AndroidIcons.Views.UnknownLarge;
    }

    @NotNull
    private static String getBuiltinCoordinate(@NotNull String tagName) {
        if (tagName.startsWith("android.support.v4.")) {
            return "com.android.support:support-v4";
        }
        if (tagName.startsWith("android.support.v7.")) {
            return "com.android.support:appcompat-v7";
        }
        if (tagName.startsWith("android.support.design.")) {
            return "com.android.support:design";
        }
        if (tagName.startsWith("android.support.v17.leanback.")) {
            return "com.android.support:leanback-v17";
        }
        if (tagName.startsWith("com.google.android.gms.ads.")) {
            return "com.google.android.gms:play-services-ads";
        }
        if (tagName.startsWith("com.google.android.gms.maps.")) {
            return "com.google.android.gms:play-services-maps";
        }
        return "";
    }
}

