/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api;

import android.view.View;
import android.view.ViewGroup;
import com.android.tools.idea.uibuilder.api.ScrollHandler;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import org.jetbrains.annotations.NotNull;

public final class ScrollViewScrollHandler
implements ScrollHandler {
    private final int myMaxScrollableSize;
    private final int myScrollUnitSize;
    private final int myStartScrollPosition;
    @NotNull
    private final IntConsumer myScrollSetter;
    @NotNull
    private final IntSupplier myScrollGetter;
    @NotNull
    private final Runnable myScrollHandler;

    ScrollViewScrollHandler(int maxScrollableSize, int scrollUnitSize, @NotNull IntConsumer scrollSetter, @NotNull IntSupplier scrollGetter, @NotNull Runnable scrollHandler) {
        this.myMaxScrollableSize = maxScrollableSize;
        this.myScrollUnitSize = scrollUnitSize;
        this.myScrollSetter = scrollSetter;
        this.myScrollGetter = scrollGetter;
        this.myStartScrollPosition = scrollGetter.getAsInt();
        this.myScrollHandler = scrollHandler;
    }

    @NotNull
    public static ScrollViewScrollHandler createHandler(@NotNull View view, int maxScrollableSize, int scrollUnitSize, @NotNull Orientation orientation) {
        return new ScrollViewScrollHandler(maxScrollableSize, scrollUnitSize, orientation == Orientation.VERTICAL ? arg_0 -> ((View)view).setScrollY(arg_0) : arg_0 -> ((View)view).setScrollX(arg_0), orientation == Orientation.VERTICAL ? () -> ((View)view).getScrollY() : () -> ((View)view).getScrollX(), () -> ScrollViewScrollHandler.handleScrolling(view));
    }

    private static void handleScrolling(@NotNull View view) {
        int scrollPosX = view.getScrollX();
        int scrollPosY = view.getScrollY();
        if (scrollPosX != 0 || scrollPosY != 0) {
            if (view.isNestedScrollingEnabled()) {
                int[] consumed = new int[2];
                int axis = scrollPosX != 0 ? 1 : 0;
                if (view.startNestedScroll(axis |= scrollPosY != 0 ? 2 : 0)) {
                    view.dispatchNestedPreScroll(scrollPosX, scrollPosY, consumed, null);
                    view.dispatchNestedScroll(consumed[0], consumed[1], scrollPosX, scrollPosY, null);
                    view.stopNestedScroll();
                    scrollPosX -= consumed[0];
                    scrollPosY -= consumed[1];
                }
            }
            if (scrollPosX != 0 || scrollPosY != 0) {
                view.scrollTo(scrollPosX, scrollPosY);
            }
        }
        if (!(view instanceof ViewGroup)) {
            return;
        }
        ViewGroup group = (ViewGroup)view;
        for (int i = 0; i < group.getChildCount(); ++i) {
            View child = group.getChildAt(i);
            ScrollViewScrollHandler.handleScrolling(child);
        }
    }

    @Override
    public int update(int scrollAmount) {
        int currentScrollPosition = this.myScrollGetter.getAsInt();
        int newScrollPos = Math.min(this.myMaxScrollableSize, Math.max(0, this.myStartScrollPosition + scrollAmount * this.myScrollUnitSize));
        if (newScrollPos == currentScrollPosition) {
            return 0;
        }
        this.myScrollSetter.accept(newScrollPos);
        this.myScrollHandler.run();
        return newScrollPos - currentScrollPosition;
    }

    @Override
    public void commit(int scrollAmount) {
        this.update(scrollAmount);
    }

    @Override
    public boolean canScroll(int scrollAmount) {
        if (this.myScrollGetter.getAsInt() == 0 && scrollAmount < 0) {
            return false;
        }
        return this.myScrollGetter.getAsInt() != this.myMaxScrollableSize || scrollAmount <= 0;
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

