/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import java.awt.Dimension;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ViewEditor {
    @Nullable
    public static Integer resolveDimensionPixelSize(@NotNull RenderResources resources, @NotNull String value, @NotNull Configuration configuration) {
        ResourceHelper.TypedValue out;
        String resValue = ResourceHelper.resolveStringValue(resources, value);
        if (ResourceHelper.parseFloatAttribute(resValue, out = new ResourceHelper.TypedValue(), true)) {
            return ResourceHelper.TypedValue.complexToDimensionPixelSize(out.data, configuration);
        }
        return null;
    }

    public abstract int getDpi();

    public int dpToPx(int dp) {
        int dpi = this.getDpi();
        return dp * dpi / 160;
    }

    public int pxToDp(int px) {
        int dpi = this.getDpi();
        return px * 160 / dpi;
    }

    @NotNull
    public String pxToDpWithUnits(int px) {
        return String.format(Locale.US, "%ddp", this.pxToDp(px));
    }

    @Nullable
    public abstract AndroidVersion getCompileSdkVersion();

    @NotNull
    public abstract AndroidVersion getMinSdkVersion();

    @NotNull
    public abstract AndroidVersion getTargetSdkVersion();

    @NotNull
    public abstract Configuration getConfiguration();

    @NotNull
    public abstract NlModel getModel();

    @NotNull
    public abstract LayoutlibSceneManager getSceneBuilder();

    @NotNull
    public abstract Collection<ViewInfo> getRootViews();

    public abstract boolean moduleContainsResource(@NotNull ResourceType var1, @NotNull String var2);

    public abstract void copyVectorAssetToMainModuleSourceSet(@NotNull String var1);

    public abstract void copyLayoutToMainModuleSourceSet(@NotNull String var1, @Language(value="XML") @NotNull String var2);

    @Nullable
    public abstract Map<NlComponent, Dimension> measureChildren(@NotNull NlComponent var1, @Nullable RenderTask.AttributeFilter var2);

    @Nullable
    public final String displayResourceInput(@NotNull EnumSet<ResourceType> types) {
        return this.displayResourceInput("", types);
    }

    @Nullable
    public abstract String displayResourceInput(@NotNull String var1, @NotNull EnumSet<ResourceType> var2);

    @Nullable
    public abstract String displayClassInput(@NotNull Set<String> var1, @Nullable Predicate<PsiClass> var2, @Nullable String var3);

    public abstract boolean openResource(@NotNull Configuration var1, @NotNull String var2, @NotNull VirtualFile var3);
}

