/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import org.jetbrains.annotations.NotNull;

public class AnimationToolbar
extends JPanel
implements Disposable {
    private static final int TICKER_STEP = 33;
    private static final Font BUTTON_FONT = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL);
    @NotNull
    private final AnimationListener myListener;
    private final JButton myPlayButton;
    private final JButton myPauseButton;
    private final JButton myStopButton;
    private final JButton myFrameFwdButton;
    private final JButton myFrameBckButton;
    private final long myTickStepMs;
    private final JSlider myFrameControl;
    private ScheduledFuture<?> myTicker;
    private long myFramePositionMs;
    private long myLastTickMs = 0L;

    public AnimationToolbar(@NotNull Disposable parentDisposable, @NotNull AnimationListener listener, long tickStepMs) {
        super(new BorderLayout());
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myListener = listener;
        this.myTickStepMs = tickStepMs;
        JPanel buttonsPanel = new JPanel();
        this.myPlayButton = AnimationToolbar.newControlButton(">", this::onPlay);
        this.myPauseButton = AnimationToolbar.newControlButton("||", this::onPause);
        this.myStopButton = AnimationToolbar.newControlButton("\u25a0", this::onStop);
        this.myFrameFwdButton = AnimationToolbar.newControlButton(">|", this::onFrameFwd);
        this.myFrameBckButton = AnimationToolbar.newControlButton("|<", this::onFrameBck);
        buttonsPanel.add(this.myPlayButton);
        buttonsPanel.add(this.myPauseButton);
        buttonsPanel.add(this.myStopButton);
        buttonsPanel.add(this.myFrameBckButton);
        buttonsPanel.add(this.myFrameFwdButton);
        this.myFrameControl = new JSlider(-5, 5, 0);
        this.myFrameControl.setSnapToTicks(true);
        this.add((Component)buttonsPanel, "Before");
        this.add((Component)this.myFrameControl, "After");
        this.myFrameControl.addChangeListener(e -> {
            this.stopFrameTicker();
            int value = this.myFrameControl.getValue();
            if (value == 0) {
                this.stopFrameTicker();
                return;
            }
            long frameChange = this.myTickStepMs * (long)value;
            this.myTicker = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(() -> this.onTick(frameChange), 0L, 33L, TimeUnit.MILLISECONDS);
        });
        this.myFrameControl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!AnimationToolbar.this.myFrameControl.isEnabled()) {
                    return;
                }
                AnimationToolbar.this.stopFrameTicker();
                AnimationToolbar.this.myFrameControl.setValue(0);
            }
        });
        this.onStop();
    }

    @NotNull
    private static JButton newControlButton(@NotNull String label, @NotNull Runnable callback) {
        JButton button = new JButton(label);
        button.addActionListener(e -> callback.run());
        button.setFont(BUTTON_FONT);
        button.setEnabled(false);
        return button;
    }

    private void setEnabledState(boolean play, boolean pause, boolean stop, boolean frame) {
        this.myPlayButton.setEnabled(play);
        this.myPauseButton.setEnabled(pause);
        this.myStopButton.setEnabled(stop);
        this.myFrameFwdButton.setEnabled(frame);
        this.myFrameBckButton.setEnabled(frame);
        this.myFrameControl.setEnabled(frame);
    }

    private void onPlay() {
        this.stopFrameTicker();
        this.setEnabledState(false, true, true, false);
        this.myLastTickMs = System.currentTimeMillis();
        this.myTicker = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(() -> {
            long now = System.currentTimeMillis();
            long elapsed = now - this.myLastTickMs;
            this.myLastTickMs = now;
            this.onTick(elapsed);
        }, 0L, 33L, TimeUnit.MILLISECONDS);
    }

    private void onPause() {
        this.setEnabledState(true, false, true, true);
        this.stopFrameTicker();
    }

    private void stopFrameTicker() {
        if (this.myTicker != null) {
            this.myTicker.cancel(true);
            this.myTicker = null;
        }
    }

    private void onStop() {
        this.stopFrameTicker();
        this.setEnabledState(true, false, false, true);
        this.myFramePositionMs = 500L;
        this.doFrame();
    }

    private void doFrame() {
        this.myListener.animateTo(this.myFramePositionMs);
    }

    private void onFrameFwd() {
        this.onTick(this.myTickStepMs);
    }

    private void onFrameBck() {
        this.onTick(-this.myTickStepMs);
    }

    private void onTick(long elapsed) {
        this.myFramePositionMs += elapsed;
        if (this.myFramePositionMs < 0L) {
            this.myFramePositionMs = 0L;
        }
        this.doFrame();
    }

    public void stop() {
        this.onStop();
    }

    public void dispose() {
        this.stopFrameTicker();
    }

    public static interface AnimationListener {
        public void animateTo(long var1);
    }
}

