/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.error;

import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.uibuilder.error.NlIssue;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.collect.ImmutableList;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ModalityState;
import com.intellij.ui.GuiUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssueModel {
    @Nullable
    private RenderErrorModel myRenderErrorModel;
    @Nullable
    private LintAnnotationsModel myLintAnnotationsModel;
    private ImmutableList<NlIssue> myIssues = ImmutableList.of();
    private final ListenerCollection<IssueModelListener> myListeners = ListenerCollection.createWithExecutor(command -> GuiUtils.invokeLaterIfNeeded((Runnable)command, (ModalityState)ModalityState.defaultModalityState()));
    private int myWarningCount;
    private int myErrorCount;

    public void setRenderErrorModel(@NotNull RenderErrorModel renderErrorModel) {
        this.myRenderErrorModel = renderErrorModel;
        this.updateErrorsList();
    }

    private void updateErrorsList() {
        NlIssue issue2;
        this.myWarningCount = 0;
        this.myErrorCount = 0;
        ImmutableList.Builder issueListBuilder = ImmutableList.builder();
        if (this.myRenderErrorModel != null) {
            for (Comparable<RenderErrorModel.Issue> error : this.myRenderErrorModel.getIssues()) {
                issue2 = NlIssue.wrapIssue(error);
                issueListBuilder.add((Object)issue2);
                this.updateIssuesCounts(issue2);
            }
        }
        if (this.myLintAnnotationsModel != null) {
            for (Comparable<RenderErrorModel.Issue> error : this.myLintAnnotationsModel.getIssues()) {
                issue2 = NlIssue.wrapIssue((LintAnnotationsModel.IssueData)error);
                issueListBuilder.add((Object)issue2);
                this.updateIssuesCounts(issue2);
            }
        }
        this.myIssues = issueListBuilder.build();
        this.myListeners.forEach(IssueModelListener::errorModelChanged);
    }

    private void updateIssuesCounts(@NotNull NlIssue issue2) {
        if (issue2.getSeverity().equals((Object)HighlightSeverity.WARNING)) {
            ++this.myWarningCount;
        } else if (issue2.getSeverity().equals((Object)HighlightSeverity.ERROR)) {
            ++this.myErrorCount;
        }
    }

    public void setLintAnnotationsModel(@NotNull LintAnnotationsModel lintAnnotationsModel) {
        this.myLintAnnotationsModel = lintAnnotationsModel;
        this.updateErrorsList();
    }

    @NotNull
    public ImmutableList<NlIssue> getNlErrors() {
        return this.myIssues;
    }

    public boolean hasRenderError() {
        return this.myRenderErrorModel != null && !this.myRenderErrorModel.getIssues().isEmpty();
    }

    public int getIssueCount() {
        return this.myIssues.size();
    }

    public void addErrorModelListener(@NotNull IssueModelListener listener) {
        this.myListeners.add(listener);
    }

    public void removeErrorModelListener(@NotNull IssueModelListener listener) {
        this.myListeners.remove(listener);
    }

    public int getWarningCount() {
        return this.myWarningCount;
    }

    public int getErrorCount() {
        return this.myErrorCount;
    }

    public boolean hasIssues() {
        return !this.myIssues.isEmpty();
    }

    @Nullable
    public NlIssue findIssue(@NotNull NlComponent component2) {
        for (NlIssue issue2 : this.myIssues) {
            if (!component2.equals(issue2.getSource())) continue;
            return issue2;
        }
        return null;
    }

    public static interface IssueModelListener {
        public void errorModelChanged();
    }
}

