/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.error;

import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.rendering.HtmlBuilderHelper;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.HtmlBuilder;
import com.android.utils.Pair;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NlIssue {
    public static final String EXECUTE_FIX = "Execute Fix: ";

    @NotNull
    public abstract String getSummary();

    @NotNull
    public abstract String getDescription();

    @NotNull
    public abstract HighlightSeverity getSeverity();

    @Nullable
    public abstract NlComponent getSource();

    public abstract String getCategory();

    @Nullable
    public HyperlinkListener getHyperlinkListener() {
        return null;
    }

    @NotNull
    public Stream<Pair<String, Runnable>> getFixes() {
        return Stream.empty();
    }

    @NotNull
    public static NlIssue wrapIssue(@NotNull RenderErrorModel.Issue renderIssue) {
        return new NlRenderIssueWrapper(renderIssue);
    }

    @NotNull
    public static NlIssue wrapIssue(@NotNull LintAnnotationsModel.IssueData lintIssue) {
        return new NlLintIssueWrapper(lintIssue);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NlIssue)) {
            return false;
        }
        NlIssue nlIssue = (NlIssue)object;
        return nlIssue.getSeverity().equals((Object)this.getSeverity()) && nlIssue.getSummary().equals(this.getSummary()) && nlIssue.getDescription().equals(this.getDescription()) && nlIssue.getCategory().equals(this.getCategory()) && nlIssue.getSource() == this.getSource();
    }

    public int hashCode() {
        int result = 13;
        result += 17 * this.getSeverity().hashCode();
        result += 19 * this.getSummary().hashCode();
        result += 23 * this.getDescription().hashCode();
        result += 29 * this.getCategory().hashCode();
        NlComponent source = this.getSource();
        if (source != null) {
            result += 31 * source.hashCode();
        }
        return result;
    }

    private static class NlLintIssueWrapper
    extends NlIssue {
        private final LintAnnotationsModel.IssueData myIssue;
        private String myDescription;

        private NlLintIssueWrapper(@NotNull LintAnnotationsModel.IssueData issue2) {
            this.myIssue = issue2;
        }

        private String createFullDescription() {
            Issue issue2 = this.myIssue.issue;
            String headerFontColor = HtmlBuilderHelper.getHeaderFontColor();
            HtmlBuilder builder = new HtmlBuilder();
            builder.addHtml(TextFormat.RAW.convertTo(this.myIssue.message, TextFormat.HTML));
            builder.newline().newline();
            builder.addHtml(issue2.getExplanation(TextFormat.HTML));
            builder.newline();
            List moreInfo = issue2.getMoreInfo();
            int count = moreInfo.size();
            if (count > 1) {
                builder.addHeading("More Info: ", headerFontColor);
                builder.beginList();
            }
            for (String uri : moreInfo) {
                if (count > 1) {
                    builder.listItem();
                }
                builder.addLink(uri, uri);
            }
            if (count > 1) {
                builder.endList();
            }
            builder.newline();
            return builder.getHtml();
        }

        @Override
        @NotNull
        public String getSummary() {
            return this.myIssue.issue.getBriefDescription(TextFormat.RAW);
        }

        @Override
        @NotNull
        public String getDescription() {
            if (this.myDescription == null) {
                this.myDescription = this.createFullDescription();
            }
            return this.myDescription;
        }

        @Override
        @NotNull
        public HighlightSeverity getSeverity() {
            return this.myIssue.level.getSeverity();
        }

        @Override
        @NotNull
        public NlComponent getSource() {
            return this.myIssue.component;
        }

        @Override
        public String getCategory() {
            return this.myIssue.issue.getCategory().getFullName();
        }

        @Override
        @NotNull
        public Stream<Pair<String, Runnable>> getFixes() {
            AndroidLintInspectionBase inspection = this.myIssue.inspection;
            AndroidLintQuickFix[] quickFixes = inspection.getQuickFixes(this.myIssue.startElement, this.myIssue.endElement, this.myIssue.message, this.myIssue.quickfixData);
            IntentionAction[] intentions = inspection.getIntentions(this.myIssue.startElement, this.myIssue.endElement);
            return Stream.concat(Arrays.stream(quickFixes).map(this::createQuickFixPair), Arrays.stream(intentions).map(this::createQuickFixPair));
        }

        @NotNull
        private Pair<String, Runnable> createQuickFixPair(@NotNull AndroidLintQuickFix fix) {
            return Pair.of((Object)fix.getName(), (Object)this.createQuickFixRunnable(fix));
        }

        @NotNull
        private Pair<String, Runnable> createQuickFixPair(@NotNull IntentionAction fix) {
            return Pair.of((Object)fix.getText(), (Object)this.createQuickFixRunnable(fix));
        }

        @NotNull
        private Runnable createQuickFixRunnable(@NotNull AndroidLintQuickFix fix) {
            return () -> {
                NlModel model = this.myIssue.component.getModel();
                Editor editor = PsiEditorUtil.Service.getInstance().findEditorByPsiElement(this.myIssue.startElement);
                if (editor != null) {
                    Project project = model.getProject();
                    CommandProcessor.getInstance().executeCommand(project, () -> fix.apply(this.myIssue.startElement, this.myIssue.endElement, AndroidQuickfixContexts.BatchContext.getInstance()), NlIssue.EXECUTE_FIX + fix.getName(), null);
                }
            };
        }

        @NotNull
        private Runnable createQuickFixRunnable(@NotNull IntentionAction fix) {
            return () -> {
                NlModel model = this.myIssue.component.getModel();
                Editor editor = PsiEditorUtil.Service.getInstance().findEditorByPsiElement(this.myIssue.startElement);
                if (editor != null) {
                    Project project = model.getProject();
                    CommandProcessor.getInstance().executeCommand(project, () -> fix.invoke(project, editor, (PsiFile)model.getFile()), NlIssue.EXECUTE_FIX + fix.getFamilyName(), null);
                }
            };
        }
    }

    private static class NlRenderIssueWrapper
    extends NlIssue {
        private final RenderErrorModel.Issue myIssue;

        private NlRenderIssueWrapper(@NotNull RenderErrorModel.Issue issue2) {
            this.myIssue = issue2;
        }

        @Override
        @NotNull
        public String getSummary() {
            return this.myIssue.getSummary();
        }

        @Override
        @NotNull
        public String getDescription() {
            return this.myIssue.getHtmlContent();
        }

        @Override
        @NotNull
        public HighlightSeverity getSeverity() {
            return this.myIssue.getSeverity();
        }

        @Override
        @Nullable
        public NlComponent getSource() {
            return null;
        }

        @Override
        public String getCategory() {
            return "Rendering Issue";
        }

        @Override
        @Nullable
        public HyperlinkListener getHyperlinkListener() {
            return this.myIssue.getHyperlinkListener();
        }
    }
}

