/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.handlers.DelegatingViewGroupHandler;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import javax.swing.Icon;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomViewGroupHandler
extends DelegatingViewGroupHandler {
    private final Icon myIcon16;
    private final Icon myIcon24;
    private final String myTagName;
    @Language(value="XML")
    private final String myXml;
    @Language(value="XML")
    private final String myPreviewXml;
    private final String myLibraryCoordinate;
    private final String myPreferredProperty;
    private final List<String> myProperties;
    private final List<String> myLayoutProperties;

    public CustomViewGroupHandler(@NotNull ViewGroupHandler handler, @Nullable Icon icon16, @Nullable Icon icon24, @NotNull String tagName, @Nullable @Language(value="XML") String xml, @Nullable @Language(value="XML") String previewXml, @NotNull String libraryCoordinate, @Nullable String preferredProperty, @NotNull List<String> properties, @NotNull List<String> layoutProperties) {
        super(handler);
        this.myIcon16 = icon16;
        this.myIcon24 = icon24;
        this.myTagName = tagName;
        this.myXml = xml;
        this.myPreviewXml = previewXml;
        this.myLibraryCoordinate = libraryCoordinate;
        this.myPreferredProperty = preferredProperty;
        this.myProperties = properties;
        this.myLayoutProperties = layoutProperties;
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull String tagName) {
        return this.myIcon16 != null && tagName.equals(this.myTagName) ? this.myIcon16 : super.getIcon(tagName);
    }

    @Override
    @NotNull
    public Icon getLargeIcon(@NotNull String tagName) {
        return this.myIcon24 != null && tagName.equals(this.myTagName) ? this.myIcon24 : super.getIcon(tagName);
    }

    @Override
    @NotNull
    public String getGradleCoordinateId(@NotNull String tagName) {
        return tagName.equals(this.myTagName) ? this.myLibraryCoordinate : super.getGradleCoordinateId(tagName);
    }

    @Override
    @NotNull
    @Language(value="XML")
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        if (xmlType == XmlType.COMPONENT_CREATION) {
            return tagName.equals(this.myTagName) && !StringUtil.isEmpty((String)this.myXml) ? this.myXml : super.getXml(tagName, xmlType);
        }
        return tagName.equals(this.myTagName) && !StringUtil.isEmpty((String)this.myPreviewXml) ? this.myPreviewXml : "";
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull NlComponent component2) {
        return component2.getTagName().equals(this.myTagName) && this.myIcon16 != null ? this.myIcon16 : super.getIcon(component2);
    }

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return this.myProperties;
    }

    @Override
    @NotNull
    public List<String> getLayoutInspectorProperties() {
        return this.myLayoutProperties;
    }

    @Override
    @Nullable
    public String getPreferredProperty() {
        return this.myPreferredProperty;
    }
}

