/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import icons.AndroidIcons;
import java.util.List;
import javax.swing.Icon;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FragmentHandler
extends ViewHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"name", (Object)"layout", (Object)"class");
    }

    @Override
    @NotNull
    public String getTitle(@NotNull String tagName) {
        return "<fragment>";
    }

    @Override
    @NotNull
    public String getTitle(@NotNull NlComponent component2) {
        return "<fragment>";
    }

    @Override
    @NotNull
    public String getTitleAttributes(@NotNull NlComponent component2) {
        String name = component2.getAttribute("http://schemas.android.com/apk/res/android", "name");
        return StringUtil.isEmpty((String)name) ? "" : "- " + name;
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull String tagName) {
        return AndroidIcons.Views.Fragment;
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull NlComponent component2) {
        return AndroidIcons.Views.Fragment;
    }

    @Override
    @Language(value="XML")
    @NotNull
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        switch (xmlType) {
            case PREVIEW_ON_PALETTE: 
            case DRAG_PREVIEW: {
                return "";
            }
        }
        return super.getXml(tagName, xmlType);
    }

    @Override
    public boolean onCreate(@NotNull ViewEditor editor, @Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (insertType == InsertType.CREATE) {
            if (newChild.getAttribute("http://schemas.android.com/apk/res/android", "name") != null) {
                return true;
            }
            String src = editor.displayClassInput(Sets.newHashSet((Object[])new String[]{"android.app.Fragment", "android.support.v4.app.Fragment"}), null, null);
            if (src != null) {
                newChild.setAttribute("http://schemas.android.com/apk/res/android", "name", src);
                return true;
            }
            return false;
        }
        return true;
    }
}

