/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.api.DefaultResizeHandler;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.ResizeHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.SegmentType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameLayoutHandler
extends ViewGroupHandler {
    @Override
    @Nullable
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull SceneComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        return new FrameDragHandler(editor, this, layout, components, type){};
    }

    @Override
    @Nullable
    public ResizeHandler createResizeHandler(@NotNull ViewEditor editor, @NotNull NlComponent component2, @Nullable SegmentType horizontalEdgeType, @Nullable SegmentType verticalEdgeType) {
        return new DefaultResizeHandler(editor, this, component2, horizontalEdgeType, verticalEdgeType);
    }

    protected static class FrameDragHandler
    extends DragHandler {
        protected FrameDragHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull SceneComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
            super(editor, handler, layout, components, type);
        }

        @Override
        public void paint(@NotNull NlGraphics graphics) {
            graphics.useStyle(NlDrawingStyle.DROP_RECIPIENT);
            graphics.drawRectDp(this.layout.getDrawX(), this.layout.getDrawY(), this.layout.getDrawWidth(), this.layout.getDrawHeight());
            for (NlComponent nlComponent : this.components) {
                SceneComponent component2 = this.layout.getSceneComponent(nlComponent);
                if (component2 == null) continue;
                int x = this.layout.getDrawX();
                int y = this.layout.getDrawY();
                int w = NlComponentHelperKt.getW(nlComponent);
                int h = NlComponentHelperKt.getH(nlComponent);
                graphics.useStyle(NlDrawingStyle.DROP_PREVIEW);
                graphics.drawRectDp(x, y, w, h);
            }
        }
    }
}

