/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import android.view.View;
import android.view.ViewGroup;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ScrollHandler;
import com.android.tools.idea.uibuilder.api.ScrollViewScrollHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.handlers.ScrollViewHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HorizontalScrollViewHandler
extends ScrollViewHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"fillViewport");
    }

    @Override
    public void onChildInserted(@NotNull ViewEditor editor, @NotNull NlComponent parent, @NotNull NlComponent child, @NotNull InsertType insertType) {
        child.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", "wrap_content");
        child.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", "match_parent");
    }

    @Override
    public boolean onCreate(@NotNull ViewEditor editor, @Nullable NlComponent parent, @NotNull NlComponent node, @NotNull InsertType insertType) {
        if (insertType.isCreate()) {
            NlComponent linear = NlComponentHelperKt.createChild(node, editor, "android.widget.LinearLayout", null, InsertType.VIEW_HANDLER);
            linear.setAttribute("http://schemas.android.com/apk/res/android", "orientation", "vertical");
        }
        return true;
    }

    @Override
    @Nullable
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull SceneComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        return new ScrollViewHandler.OneChildDragHandler(editor, this, layout, components, type);
    }

    @Override
    @Nullable
    public ScrollHandler createScrollHandler(@NotNull ViewEditor editor, @NotNull NlComponent component2) {
        ViewGroup viewGroup = HorizontalScrollViewHandler.getViewGroupFromComponent(component2);
        if (viewGroup == null) {
            return null;
        }
        int maxScrollableWidth = HorizontalScrollViewHandler.getMaxScrollable(viewGroup, View::getWidth, View::getMeasuredWidth);
        if (maxScrollableWidth > 0) {
            return ScrollViewScrollHandler.createHandler((View)viewGroup, maxScrollableWidth, 10, ScrollViewScrollHandler.Orientation.HORIZONTAL);
        }
        return null;
    }

    @Override
    public void addToolbarActions(@NotNull List<ViewAction> actions) {
        actions.add(new ScrollViewHandler.ToggleRenderModeAction());
    }
}

