/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.resources.ResourceType;
import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.property.assistant.ComponentAssistant;
import com.android.xml.XmlBuilder;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import java.util.EnumSet;
import java.util.List;
import javax.swing.JButton;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageViewHandler
extends ViewHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"src", (Object)"contentDescription", (Object)"background", (Object)"scaleType", (Object)"adjustViewBounds", (Object)"cropToPadding");
    }

    @Override
    @NotNull
    public String getPreferredProperty() {
        return "src";
    }

    @Override
    @NotNull
    @Language(value="XML")
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        return new XmlBuilder().startTag(tagName).androidAttribute("src", this.getSampleImageSrc()).androidAttribute("layout_width", "wrap_content").androidAttribute("layout_height", "wrap_content").endTag(tagName).toString();
    }

    @Override
    public boolean onCreate(@NotNull ViewEditor editor, @Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (insertType == InsertType.CREATE) {
            return this.showImageChooser(editor, newChild);
        }
        if (insertType.isCreate()) {
            this.setSrcAttribute(newChild, this.getSampleImageSrc());
        }
        return true;
    }

    private boolean showImageChooser(@NotNull ViewEditor editor, @NotNull NlComponent component2) {
        String src = editor.displayResourceInput(EnumSet.of(ResourceType.DRAWABLE));
        if (src != null) {
            this.setSrcAttribute(component2, src);
            return true;
        }
        return false;
    }

    @NotNull
    public String getSampleImageSrc() {
        return "@android:drawable/btn_star";
    }

    public void setSrcAttribute(@NotNull NlComponent component2, @NotNull String imageSource) {
        NlWriteCommandAction.run(component2, "", () -> {
            if (this.shouldUseSrcCompat(component2.getModel())) {
                component2.setAttribute("http://schemas.android.com/apk/res/android", "src", null);
                component2.setAttribute("http://schemas.android.com/apk/res-auto", "srcCompat", imageSource);
            } else {
                component2.setAttribute("http://schemas.android.com/apk/res/android", "src", imageSource);
                component2.setAttribute("http://schemas.android.com/apk/res-auto", "srcCompat", null);
            }
        });
    }

    @Nullable
    public String getSrcAttribute(@NotNull NlComponent component2) {
        String srcAttribute = null;
        if (this.shouldUseSrcCompat(component2.getModel())) {
            srcAttribute = component2.getAttribute("http://schemas.android.com/apk/res-auto", "srcCompat");
        }
        return srcAttribute != null ? srcAttribute : component2.getAttribute("http://schemas.android.com/apk/res/android", "src");
    }

    public boolean shouldUseSrcCompat(@NotNull NlModel model) {
        return ImageViewHandler.moduleDependsOnAppCompat(model) && ImageViewHandler.currentActivityIsDerivedFromAppCompatActivity(model);
    }

    private static boolean moduleDependsOnAppCompat(@NotNull NlModel model) {
        GradleDependencyManager manager = GradleDependencyManager.getInstance(model.getProject());
        return manager.dependsOn(model.getModule(), "com.android.support:appcompat-v7");
    }

    private static boolean currentActivityIsDerivedFromAppCompatActivity(@NotNull NlModel model) {
        PsiClass activityClass;
        Configuration configuration = model.getConfiguration();
        String activityClassName = configuration.getActivity();
        if (activityClassName == null) {
            return true;
        }
        if (activityClassName.startsWith(".")) {
            MergedManifest manifest = MergedManifest.get(model.getModule());
            String pkg = StringUtil.notNullize((String)manifest.getPackage());
            activityClassName = pkg + activityClassName;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)model.getProject());
        for (activityClass = facade.findClass(activityClassName, model.getModule().getModuleScope()); activityClass != null && !"android.support.v7.app.AppCompatActivity".equals(activityClass.getQualifiedName()); activityClass = activityClass.getSuperClass()) {
        }
        return activityClass != null;
    }

    @Override
    @Nullable
    public ComponentAssistant.PanelFactory getComponentAssistant(@NotNull DesignSurface surface, @NotNull NlComponent component2) {
        SceneView sceneView = surface.getCurrentSceneView();
        if (sceneView == null || this.getSrcAttribute(component2) != null) {
            return null;
        }
        JButton button = new JButton("Set image");
        button.addActionListener(e -> this.showImageChooser(new ViewEditorImpl(surface.getCurrentSceneView()), component2));
        return (comp, close) -> button;
    }
}

