/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.resources.ResourceType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.EnumSet;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IncludeHandler
extends ViewHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"layout", (Object)"visibility");
    }

    @Override
    @NotNull
    public String getTitle(@NotNull String tagName) {
        return "<include>";
    }

    @Override
    @NotNull
    public String getTitle(@NotNull NlComponent component2) {
        return "<include>";
    }

    @Override
    @NotNull
    public String getTitleAttributes(@NotNull NlComponent component2) {
        String layout = component2.getAttribute(null, "layout");
        return StringUtil.isEmpty((String)layout) ? "" : "- " + layout;
    }

    @Override
    @Language(value="XML")
    @NotNull
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        switch (xmlType) {
            case COMPONENT_CREATION: {
                return "<include/>";
            }
        }
        return "";
    }

    @Override
    public boolean onCreate(@NotNull ViewEditor editor, @Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (insertType == InsertType.CREATE) {
            String src = editor.displayResourceInput(EnumSet.of(ResourceType.LAYOUT));
            if (src != null) {
                newChild.setAttribute(null, "layout", src);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void onActivateInComponentTree(@NotNull ViewEditor editor, @NotNull NlComponent component2) {
        IncludeHandler.openIncludedLayout(editor, component2);
    }

    @Override
    public void onActivateInDesignSurface(@NotNull ViewEditor editor, @NotNull NlComponent component2, int x, int y) {
        IncludeHandler.openIncludedLayout(editor, component2);
    }

    private static void openIncludedLayout(ViewEditor viewEditor, @NotNull NlComponent component2) {
        NlModel model = component2.getModel();
        String attribute = component2.getAttribute(null, "layout");
        if (attribute == null) {
            return;
        }
        Configuration configuration = model.getConfiguration();
        boolean editorOpened = viewEditor.openResource(configuration, attribute, component2.getTag().getContainingFile().getVirtualFile());
        if (!editorOpened) {
            Logger.getInstance(IncludeHandler.class).warn(String.format("Cannot open included layout \"%s\" for %s tag with id \"%s\"", attribute, component2.getTag(), component2.getId()));
        }
    }
}

