/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import android.view.View;
import android.view.ViewGroup;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ScrollHandler;
import com.android.tools.idea.uibuilder.api.ScrollViewScrollHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.ToggleViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.google.common.collect.ImmutableList;
import icons.AndroidDesignerIcons;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollViewHandler
extends ViewGroupHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"scrollbarStyle", (Object)"style", (Object)"fillViewport", (Object)"clipToPadding");
    }

    @Override
    public void onChildInserted(@NotNull ViewEditor editor, @NotNull NlComponent parent, @NotNull NlComponent child, @NotNull InsertType insertType) {
        child.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", "match_parent");
        child.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", "wrap_content");
    }

    @Override
    public boolean onCreate(@NotNull ViewEditor editor, @Nullable NlComponent parent, @NotNull NlComponent node, @NotNull InsertType insertType) {
        if (insertType.isCreate()) {
            NlComponent linear = NlComponentHelperKt.createChild(node, editor, "android.widget.LinearLayout", null, InsertType.VIEW_HANDLER);
            linear.setAttribute("http://schemas.android.com/apk/res/android", "orientation", "vertical");
        }
        return true;
    }

    @Override
    @Nullable
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull SceneComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        return new OneChildDragHandler(editor, this, layout, components, type);
    }

    @Override
    @Nullable
    public ScrollHandler createScrollHandler(@NotNull ViewEditor editor, @NotNull NlComponent component2) {
        ViewGroup viewGroup = ScrollViewHandler.getViewGroupFromComponent(component2);
        if (viewGroup == null) {
            return null;
        }
        int maxScrollableHeight = ScrollViewHandler.getMaxScrollable(viewGroup, View::getHeight, View::getMeasuredHeight);
        if (maxScrollableHeight > 0) {
            return ScrollViewScrollHandler.createHandler((View)viewGroup, maxScrollableHeight, 10, ScrollViewScrollHandler.Orientation.VERTICAL);
        }
        return null;
    }

    @Nullable
    static ViewGroup getViewGroupFromComponent(@NotNull NlComponent component2) {
        Object viewObject;
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(component2);
        Object object = viewObject = viewInfo != null ? viewInfo.getViewObject() : null;
        if (viewObject != null && viewObject instanceof ViewGroup) {
            return (ViewGroup)viewObject;
        }
        return null;
    }

    static int getMaxScrollable(@NotNull ViewGroup viewGroup, @NotNull Function<ViewGroup, Integer> measureGroup, @NotNull Function<View, Integer> measureChildren) {
        int maxScrollable = 0;
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            maxScrollable += measureChildren.apply(viewGroup.getChildAt(i)).intValue();
        }
        if ((maxScrollable -= measureGroup.apply(viewGroup).intValue()) < 0) {
            maxScrollable = 0;
        }
        return maxScrollable;
    }

    @Override
    public void addToolbarActions(@NotNull List<ViewAction> actions) {
        actions.add(new ToggleRenderModeAction());
    }

    static class ToggleRenderModeAction
    extends ToggleViewAction {
        public ToggleRenderModeAction() {
            super(AndroidDesignerIcons.ViewportRender, AndroidDesignerIcons.NormalRender, "Toggle Viewport Render Mode", null);
        }

        @Override
        public boolean isSelected(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren) {
            return LayoutlibSceneManager.isRenderViewPort();
        }

        @Override
        public void setSelected(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren, boolean selected) {
            LayoutlibSceneManager.setRenderViewPort(selected);
            editor.getSceneBuilder().requestRender();
        }
    }

    static class OneChildDragHandler
    extends DragHandler {
        public OneChildDragHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull SceneComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
            super(editor, handler, layout, components, type);
        }

        @Override
        @Nullable
        public String update(int x, int y, int modifiers) {
            super.update(x, y, modifiers);
            if (this.layout.getChildCount() > 1 || this.components.size() > 1) {
                return "Layout only allows 1 child";
            }
            return null;
        }

        @Override
        public void paint(@NotNull NlGraphics graphics) {
            if (this.layout.getChildCount() == 0) {
                graphics.useStyle(NlDrawingStyle.DROP_RECIPIENT);
                graphics.drawRectDp(this.layout.getDrawX(), this.layout.getDrawY(), this.layout.getDrawWidth(), this.layout.getDrawHeight());
            }
        }
    }
}

