/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.npw.assetstudio.GraphicGenerator;
import com.android.tools.idea.npw.assetstudio.MaterialDesignIcons;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.res.ModuleResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.ui.resourcechooser.ChooseResourceDialog;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.editor.LayoutNavigationManager;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.intellij.lang.annotations.Language;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ChooseClassDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewEditorImpl
extends ViewEditor {
    private final SceneView mySceneView;

    public ViewEditorImpl(@NotNull SceneView scene) {
        this.mySceneView = scene;
    }

    @Override
    public int getDpi() {
        return this.mySceneView.getConfiguration().getDensity().getDpiValue();
    }

    @Override
    @Nullable
    public AndroidVersion getCompileSdkVersion() {
        return AndroidModuleInfo.getInstance(this.mySceneView.getModel().getFacet()).getBuildSdkVersion();
    }

    @Override
    @NotNull
    public AndroidVersion getMinSdkVersion() {
        return AndroidModuleInfo.getInstance(this.mySceneView.getModel().getFacet()).getMinSdkVersion();
    }

    @Override
    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        return AndroidModuleInfo.getInstance(this.mySceneView.getModel().getFacet()).getTargetSdkVersion();
    }

    @Override
    @NotNull
    public Configuration getConfiguration() {
        return this.mySceneView.getConfiguration();
    }

    @Override
    @NotNull
    public NlModel getModel() {
        return this.mySceneView.getModel();
    }

    @Override
    @NotNull
    public LayoutlibSceneManager getSceneBuilder() {
        return (LayoutlibSceneManager)this.mySceneView.getSceneManager();
    }

    @Override
    @NotNull
    public Collection<ViewInfo> getRootViews() {
        RenderResult result = this.getSceneBuilder().getRenderResult();
        if (result == null) {
            return Collections.emptyList();
        }
        return result.getRootViews();
    }

    @Override
    public boolean moduleContainsResource(@NotNull ResourceType type, @NotNull String name) {
        AndroidFacet facet = this.mySceneView.getModel().getFacet();
        return ModuleResourceRepository.getOrCreateInstance(facet).hasResourceItem(type, name);
    }

    @Override
    public void copyVectorAssetToMainModuleSourceSet(@NotNull String asset) {
        String path = MaterialDesignIcons.getPathForBasename(asset);
        try (InputStreamReader reader = new InputStreamReader(GraphicGenerator.class.getClassLoader().getResourceAsStream(path), StandardCharsets.UTF_8);){
            this.createResourceFile("drawable", asset + ".xml", CharStreams.toString((Readable)reader));
        }
        catch (IOException exception) {
            Logger.getInstance(ViewEditorImpl.class).warn((Throwable)exception);
        }
    }

    @Override
    public void copyLayoutToMainModuleSourceSet(@NotNull String layout, @Language(value="XML") @NotNull String xml) {
        String message = "Do you want to copy layout " + layout + " to your main module source set?";
        if (Messages.showYesNoDialog((Project)this.mySceneView.getModel().getProject(), (String)message, (String)"Copy Layout", (Icon)Messages.getQuestionIcon()) == 1) {
            return;
        }
        this.createResourceFile("layout", layout + ".xml", xml);
    }

    private void createResourceFile(@NotNull String resourceDirectory, @NotNull String resourceFileName, @NotNull CharSequence resourceFileContent) {
        try {
            VirtualFile directory = this.getResourceDirectoryChild(resourceDirectory);
            if (directory == null) {
                return;
            }
            Document document = FileDocumentManager.getInstance().getDocument(directory.createChildData((Object)this, resourceFileName));
            assert (document != null);
            document.setText(resourceFileContent);
        }
        catch (IOException exception) {
            Logger.getInstance(ViewEditorImpl.class).warn((Throwable)exception);
        }
    }

    @Nullable
    private VirtualFile getResourceDirectoryChild(@NotNull String child) throws IOException {
        VirtualFile resourceDirectory = this.mySceneView.getModel().getFacet().getPrimaryResourceDir();
        if (resourceDirectory == null) {
            Logger.getInstance(ViewEditorImpl.class).warn("resourceDirectory is null");
            return null;
        }
        VirtualFile resourceDirectoryChild = resourceDirectory.findChild(child);
        if (resourceDirectoryChild == null) {
            return resourceDirectory.createChildDirectory((Object)this, child);
        }
        return resourceDirectoryChild;
    }

    @Override
    @Nullable
    public Map<NlComponent, Dimension> measureChildren(@NotNull NlComponent parent, @Nullable RenderTask.AttributeFilter filter) {
        HashMap unweightedSizes = Maps.newHashMap();
        XmlTag parentTag = parent.getTag();
        if (parentTag.isValid()) {
            if (parent.getChildCount() == 0) {
                return Collections.emptyMap();
            }
            HashMap tagToComponent = Maps.newHashMapWithExpectedSize((int)parent.getChildCount());
            for (NlComponent child : parent.getChildren()) {
                tagToComponent.put(child.getTag(), child);
            }
            NlModel model = this.mySceneView.getModel();
            XmlFile xmlFile = model.getFile();
            AndroidFacet facet = model.getFacet();
            RenderService renderService = RenderService.getInstance(facet);
            RenderLogger logger = renderService.createLogger();
            RenderTask task = renderService.createTask((PsiFile)xmlFile, this.getConfiguration(), logger, null);
            if (task == null) {
                return null;
            }
            Map<XmlTag, ViewInfo> map = task.measureChildren(parentTag, filter);
            task.dispose();
            if (map != null) {
                for (Map.Entry<XmlTag, ViewInfo> entry : map.entrySet()) {
                    ViewInfo viewInfo = entry.getValue();
                    viewInfo = RenderService.getSafeBounds(viewInfo);
                    Dimension size = new Dimension(viewInfo.getRight() - viewInfo.getLeft(), viewInfo.getBottom() - viewInfo.getTop());
                    NlComponent child = (NlComponent)tagToComponent.get(entry.getKey());
                    if (child == null) continue;
                    unweightedSizes.put(child, size);
                }
            }
        }
        return unweightedSizes;
    }

    @Override
    @Nullable
    public String displayResourceInput(@NotNull String title, @NotNull EnumSet<ResourceType> types) {
        String resource;
        NlModel model = this.mySceneView.getModel();
        ChooseResourceDialog dialog = ChooseResourceDialog.builder().setModule(model.getModule()).setTypes(types).setConfiguration(model.getConfiguration()).build();
        if (!title.isEmpty()) {
            dialog.setTitle(title);
        }
        dialog.show();
        if (dialog.isOK() && (resource = dialog.getResourceName()) != null && !resource.isEmpty()) {
            return resource;
        }
        return null;
    }

    @Override
    @Nullable
    public String displayClassInput(@NotNull Set<String> superTypes, @Nullable Predicate<PsiClass> filter, @Nullable String currentValue) {
        Module module = this.mySceneView.getModel().getModule();
        String[] superTypesArray = ArrayUtil.toStringArray(superTypes);
        Condition psiFilter = psiClass -> {
            if (ViewEditorImpl.isRestricted(psiClass)) {
                return false;
            }
            if (filter != null) {
                return filter.test((PsiClass)psiClass);
            }
            return true;
        };
        return ChooseClassDialog.openDialog(module, "Classes", true, (Condition<PsiClass>)psiFilter, superTypesArray);
    }

    public static boolean isRestricted(@NotNull PsiClass psiClass) {
        PsiModifierList modifiers = psiClass.getModifierList();
        if (modifiers == null) {
            return false;
        }
        for (PsiAnnotation annotation : modifiers.getAnnotations()) {
            if (!Objects.equals(annotation.getQualifiedName(), "android.support.annotation.RestrictTo")) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public SceneView getSceneView() {
        return this.mySceneView;
    }

    @Override
    public boolean openResource(@NotNull Configuration configuration, @NotNull String reference, @Nullable VirtualFile currentFile) {
        VirtualFile file;
        ResourceResolver resourceResolver = configuration.getResourceResolver();
        if (resourceResolver == null) {
            return false;
        }
        ResourceValue resValue = resourceResolver.findResValue(reference, false);
        File path = ResourceHelper.resolveLayout((RenderResources)resourceResolver, resValue);
        if (path != null && (file = LocalFileSystem.getInstance().findFileByIoFile(path)) != null) {
            Project project = this.mySceneView.getModel().getProject();
            if (currentFile != null) {
                return LayoutNavigationManager.getInstance(project).pushFile(currentFile, file);
            }
            FileEditor[] editors = FileEditorManager.getInstance((Project)project).openFile(file, true, true);
            if (editors.length > 0) {
                return true;
            }
        }
        return false;
    }
}

