/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.handlers.ActionMenuViewHandler;
import com.android.tools.idea.uibuilder.handlers.AdapterViewHandler;
import com.android.tools.idea.uibuilder.handlers.AppBarLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.AutoCompleteTextViewHandler;
import com.android.tools.idea.uibuilder.handlers.ButtonHandler;
import com.android.tools.idea.uibuilder.handlers.CardViewHandler;
import com.android.tools.idea.uibuilder.handlers.CheckBoxHandler;
import com.android.tools.idea.uibuilder.handlers.CheckedTextViewHandler;
import com.android.tools.idea.uibuilder.handlers.ChronometerHandler;
import com.android.tools.idea.uibuilder.handlers.CollapsingToolbarLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.DrawerLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.EditTextHandler;
import com.android.tools.idea.uibuilder.handlers.FloatingActionButtonHandler;
import com.android.tools.idea.uibuilder.handlers.FragmentHandler;
import com.android.tools.idea.uibuilder.handlers.FrameLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.HorizontalScrollViewHandler;
import com.android.tools.idea.uibuilder.handlers.ImageButtonHandler;
import com.android.tools.idea.uibuilder.handlers.ImageSwitcherHandler;
import com.android.tools.idea.uibuilder.handlers.ImageViewHandler;
import com.android.tools.idea.uibuilder.handlers.IncludeHandler;
import com.android.tools.idea.uibuilder.handlers.ListViewHandler;
import com.android.tools.idea.uibuilder.handlers.MergeHandler;
import com.android.tools.idea.uibuilder.handlers.NavigationViewHandler;
import com.android.tools.idea.uibuilder.handlers.NestedScrollViewHandler;
import com.android.tools.idea.uibuilder.handlers.NoPreviewHandler;
import com.android.tools.idea.uibuilder.handlers.ProgressBarHandler;
import com.android.tools.idea.uibuilder.handlers.RatingBarHandler;
import com.android.tools.idea.uibuilder.handlers.RecyclerViewHandler;
import com.android.tools.idea.uibuilder.handlers.RequestFocusHandler;
import com.android.tools.idea.uibuilder.handlers.ScrollViewHandler;
import com.android.tools.idea.uibuilder.handlers.SeekBarHandler;
import com.android.tools.idea.uibuilder.handlers.SpaceHandler;
import com.android.tools.idea.uibuilder.handlers.SpinnerHandler;
import com.android.tools.idea.uibuilder.handlers.SwitchHandler;
import com.android.tools.idea.uibuilder.handlers.TabHostHandler;
import com.android.tools.idea.uibuilder.handlers.TabItemHandler;
import com.android.tools.idea.uibuilder.handlers.TabLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.TableLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.TableRowHandler;
import com.android.tools.idea.uibuilder.handlers.TextInputLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.TextViewHandler;
import com.android.tools.idea.uibuilder.handlers.ToggleButtonHandler;
import com.android.tools.idea.uibuilder.handlers.ToolbarHandler;
import com.android.tools.idea.uibuilder.handlers.ViewPagerHandler;
import com.android.tools.idea.uibuilder.handlers.ViewStubHandler;
import com.android.tools.idea.uibuilder.handlers.ViewTagHandler;
import com.android.tools.idea.uibuilder.handlers.ZoomButtonHandler;
import com.android.tools.idea.uibuilder.handlers.absolute.AbsoluteLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintHelperHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutBarrierHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutChainHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutLayerHandler;
import com.android.tools.idea.uibuilder.handlers.coordinator.CoordinatorLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.google.AdViewHandler;
import com.android.tools.idea.uibuilder.handlers.google.MapViewHandler;
import com.android.tools.idea.uibuilder.handlers.grid.GridLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.grid.GridLayoutV7Handler;
import com.android.tools.idea.uibuilder.handlers.leanback.BrowseFragmentHandler;
import com.android.tools.idea.uibuilder.handlers.leanback.DetailsFragmentHandler;
import com.android.tools.idea.uibuilder.handlers.leanback.PlaybackOverlayFragmentHandler;
import com.android.tools.idea.uibuilder.handlers.leanback.SearchFragmentHandler;
import com.android.tools.idea.uibuilder.handlers.linear.LinearLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.preference.CheckBoxPreferenceHandler;
import com.android.tools.idea.uibuilder.handlers.preference.EditTextPreferenceHandler;
import com.android.tools.idea.uibuilder.handlers.preference.ListPreferenceHandler;
import com.android.tools.idea.uibuilder.handlers.preference.MultiSelectListPreferenceHandler;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceCategoryHandler;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceScreenHandler;
import com.android.tools.idea.uibuilder.handlers.preference.RingtonePreferenceHandler;
import com.android.tools.idea.uibuilder.handlers.preference.SwitchPreferenceHandler;
import com.android.tools.idea.uibuilder.handlers.relative.RelativeLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.relative.RelativeLayoutHandlerKt;
import com.android.tools.idea.uibuilder.menu.GroupHandler;
import com.android.tools.idea.uibuilder.menu.MenuHandler;
import com.android.tools.idea.uibuilder.menu.MenuViewHandlerManager;
import com.android.tools.idea.uibuilder.model.NlComponentHelper;
import com.android.tools.idea.uibuilder.statelist.ItemHandler;
import com.android.tools.idea.uibuilder.statelist.SelectorHandler;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewHandlerManager
implements ProjectComponent {
    private static final String HANDLER_CLASS_SUFFIX = "Handler";
    private static final Set<String> NO_PREFIX_PACKAGES = ImmutableSet.of((Object)"android.widget.", (Object)"android.view.", (Object)"android.webkit.", (Object)"android.app.");
    private final Project myProject;
    private final Map<String, ViewHandler> myHandlers = Maps.newHashMap();
    public static final ViewHandler NONE = new ViewHandler();
    private static final ViewHandler STANDARD_HANDLER = new ViewHandler();
    private static final ViewHandler TEXT_HANDLER = new TextViewHandler();
    private static final ViewHandler NO_PREVIEW_HANDLER = new NoPreviewHandler();
    private final Map<ViewHandler, List<ViewAction>> myToolbarActions = Maps.newHashMap();
    private final Map<ViewHandler, List<ViewAction>> myMenuActions = Maps.newHashMap();

    @NotNull
    public static ViewHandlerManager get(@NotNull Project project) {
        ViewHandlerManager manager = (ViewHandlerManager)project.getComponent(ViewHandlerManager.class);
        assert (manager != null);
        return manager;
    }

    @NotNull
    public static ViewHandlerManager get(@NotNull AndroidFacet facet) {
        return ViewHandlerManager.get(facet.getModule().getProject());
    }

    public ViewHandlerManager(@NotNull Project project) {
        this.myProject = project;
    }

    @Nullable
    public ViewHandler getHandler(@NotNull NlComponent component2) {
        String tag;
        switch (tag = component2.getTagName()) {
            case "item": {
                ViewHandler handler = MenuViewHandlerManager.getHandler(component2);
                if (handler != null) {
                    return handler;
                }
                return new ItemHandler();
            }
            case "merge": {
                String parentTag = component2.getAttribute("http://schemas.android.com/tools", "parentTag");
                return this.getHandler(parentTag == null ? tag : parentTag);
            }
        }
        return this.getHandler(tag);
    }

    @NotNull
    public ViewHandler getHandlerOrDefault(@NotNull NlComponent component2) {
        ViewHandler handler = this.getHandler(component2);
        return handler != null ? handler : NONE;
    }

    @NotNull
    public ViewHandler getHandlerOrDefault(@NotNull String viewTag) {
        ViewHandler handler = this.getHandler(viewTag);
        return handler != null ? handler : NONE;
    }

    @Nullable
    public ViewHandler getHandler(@NotNull String viewTag) {
        ViewHandler handler = this.myHandlers.get(viewTag);
        if (handler == null) {
            String tag;
            if (viewTag.indexOf(46) != -1 && !(tag = NlComponentHelper.INSTANCE.viewClassToTag(viewTag)).equals(viewTag) && (handler = this.getHandler(tag)) != null) {
                this.myHandlers.put(viewTag, handler);
                return handler;
            }
            handler = this.createHandler(viewTag);
            this.myHandlers.put(viewTag, handler);
        }
        return handler != NONE ? handler : null;
    }

    public void registerHandler(@NotNull String viewTag, @NotNull ViewHandler handler) {
        this.myHandlers.put(viewTag, handler);
    }

    @Nullable
    public ViewGroupHandler findLayoutHandler(@NotNull NlComponent component2, boolean strict) {
        NlComponent curr = component2;
        if (strict) {
            curr = curr.getParent();
        }
        while (curr != null) {
            ViewHandler handler = this.getHandler(curr);
            if (handler instanceof ViewGroupHandler) {
                return (ViewGroupHandler)handler;
            }
            curr = curr.getParent();
        }
        return null;
    }

    private ViewHandler createHandler(@NotNull String viewTag) {
        switch (viewTag) {
            case "AbsoluteLayout": 
            case "WebView": {
                return new AbsoluteLayoutHandler();
            }
            case "AbsListView": 
            case "AdapterViewAnimator": 
            case "AdapterViewFlipper": 
            case "GridView": 
            case "ViewGroup": {
                return new ViewGroupHandler();
            }
            case "android.support.v7.widget.ActionMenuView": {
                return new ActionMenuViewHandler();
            }
            case "AdapterView": 
            case "StackView": {
                return new AdapterViewHandler();
            }
            case "com.google.android.gms.ads.AdView": {
                return new AdViewHandler();
            }
            case "android.support.design.widget.AppBarLayout": {
                return new AppBarLayoutHandler();
            }
            case "AutoCompleteTextView": {
                return new AutoCompleteTextViewHandler();
            }
            case "android.support.v17.leanback.app.BrowseFragment": {
                return new BrowseFragmentHandler();
            }
            case "Button": {
                return new ButtonHandler();
            }
            case "android.support.v7.widget.CardView": {
                return new CardViewHandler();
            }
            case "CheckedTextView": {
                return new CheckedTextViewHandler();
            }
            case "CheckBox": 
            case "RadioButton": {
                return new CheckBoxHandler();
            }
            case "Chronometer": {
                return new ChronometerHandler();
            }
            case "android.support.constraint.Barrier": {
                return new ConstraintLayoutBarrierHandler();
            }
            case "android.support.constraint.Chain": {
                return new ConstraintLayoutChainHandler();
            }
            case "android.support.constraint.ConstraintHelper": {
                return new ConstraintHelperHandler();
            }
            case "android.support.constraint.Layer": {
                return new ConstraintLayoutLayerHandler();
            }
            case "android.support.design.widget.CollapsingToolbarLayout": {
                return new CollapsingToolbarLayoutHandler();
            }
            case "android.support.constraint.ConstraintLayout": {
                return new ConstraintLayoutHandler();
            }
            case "android.support.design.widget.CoordinatorLayout": {
                return new CoordinatorLayoutHandler();
            }
            case "android.support.v17.leanback.app.DetailsFragment": {
                return new DetailsFragmentHandler();
            }
            case "DialerFilter": 
            case "android.widget.RelativeLayout": 
            case "RelativeLayout": {
                return StudioFlags.NELE_TARGET_RELATIVE.get() != false ? new RelativeLayoutHandlerKt() : new RelativeLayoutHandler();
            }
            case "android.support.v4.widget.DrawerLayout": {
                return new DrawerLayoutHandler();
            }
            case "EditText": {
                return new EditTextHandler();
            }
            case "ExpandableListView": {
                return new ListViewHandler();
            }
            case "com.google.android.flexbox.FlexboxLayout": {
                return NONE;
            }
            case "android.support.design.widget.FloatingActionButton": {
                return new FloatingActionButtonHandler();
            }
            case "android.widget.LinearLayout": 
            case "LinearLayout": 
            case "SearchView": {
                return new LinearLayoutHandler();
            }
            case "FrameLayout": 
            case "GestureOverlayView": 
            case "TextSwitcher": 
            case "ViewAnimator": 
            case "ViewFlipper": 
            case "ViewSwitcher": {
                return new FrameLayoutHandler();
            }
            case "GridLayout": {
                return new GridLayoutHandler();
            }
            case "android.support.v7.widget.GridLayout": {
                return new GridLayoutV7Handler();
            }
            case "HorizontalScrollView": {
                return new HorizontalScrollViewHandler();
            }
            case "ImageButton": {
                return new ImageButtonHandler();
            }
            case "ImageSwitcher": {
                return new ImageSwitcherHandler();
            }
            case "ImageView": 
            case "QuickContactBadge": {
                return new ImageViewHandler();
            }
            case "com.google.android.gms.maps.MapView": {
                return new MapViewHandler();
            }
            case "MultiAutoCompleteTextView": 
            case "TextView": {
                return TEXT_HANDLER;
            }
            case "android.support.design.widget.NavigationView": {
                return new NavigationViewHandler();
            }
            case "android.support.v4.widget.NestedScrollView": {
                return new NestedScrollViewHandler();
            }
            case "android.support.v17.leanback.app.PlaybackOverlayFragment": {
                return new PlaybackOverlayFragmentHandler();
            }
            case "ProgressBar": {
                return new ProgressBarHandler();
            }
            case "CheckBoxPreference": {
                return new CheckBoxPreferenceHandler();
            }
            case "EditTextPreference": {
                return new EditTextPreferenceHandler();
            }
            case "ListPreference": {
                return new ListPreferenceHandler();
            }
            case "MultiSelectListPreference": {
                return new MultiSelectListPreferenceHandler();
            }
            case "PreferenceCategory": {
                return new PreferenceCategoryHandler();
            }
            case "PreferenceScreen": {
                return new PreferenceScreenHandler();
            }
            case "RingtonePreference": {
                return new RingtonePreferenceHandler();
            }
            case "SwitchPreference": {
                return new SwitchPreferenceHandler();
            }
            case "RatingBar": {
                return new RatingBarHandler();
            }
            case "android.support.v7.widget.RecyclerView": {
                return new RecyclerViewHandler();
            }
            case "requestFocus": {
                return new RequestFocusHandler();
            }
            case "ScrollView": {
                return new ScrollViewHandler();
            }
            case "android.support.v17.leanback.app.SearchFragment": {
                return new SearchFragmentHandler();
            }
            case "SeekBar": {
                return new SeekBarHandler();
            }
            case "android.support.design.widget.Snackbar": {
                return STANDARD_HANDLER;
            }
            case "Space": {
                return new SpaceHandler();
            }
            case "Spinner": {
                return new SpinnerHandler();
            }
            case "SurfaceView": 
            case "TextureView": 
            case "VideoView": {
                return NO_PREVIEW_HANDLER;
            }
            case "Switch": {
                return new SwitchHandler();
            }
            case "android.support.constraint.TableConstraintLayout": {
                return new ConstraintLayoutHandler();
            }
            case "TableLayout": {
                return new TableLayoutHandler();
            }
            case "TableRow": {
                return new TableRowHandler();
            }
            case "TabHost": {
                return new TabHostHandler();
            }
            case "android.support.design.widget.TabItem": {
                return new TabItemHandler();
            }
            case "android.support.design.widget.TabLayout": {
                return new TabLayoutHandler();
            }
            case "group": {
                return new GroupHandler();
            }
            case "menu": {
                return new MenuHandler();
            }
            case "selector": {
                return new SelectorHandler();
            }
            case "TextClock": {
                return STANDARD_HANDLER;
            }
            case "android.support.design.widget.TextInputLayout": {
                return new TextInputLayoutHandler();
            }
            case "ToggleButton": {
                return new ToggleButtonHandler();
            }
            case "android.support.v7.widget.Toolbar": {
                return new ToolbarHandler();
            }
            case "View": {
                return STANDARD_HANDLER;
            }
            case "fragment": {
                return new FragmentHandler();
            }
            case "include": {
                return new IncludeHandler();
            }
            case "merge": {
                return new MergeHandler();
            }
            case "android.support.v4.view.ViewPager": {
                return new ViewPagerHandler();
            }
            case "ViewStub": {
                return new ViewStubHandler();
            }
            case "view": {
                return new ViewTagHandler();
            }
            case "ZoomButton": {
                return new ZoomButtonHandler();
            }
        }
        try {
            String defaultHandlerPkgPrefix = "com.android.tools.idea.uibuilder.handlers.";
            String handlerClass = defaultHandlerPkgPrefix + viewTag + HANDLER_CLASS_SUFFIX;
            Class<?> cls = Class.forName(handlerClass);
            return (ViewHandler)cls.newInstance();
        }
        catch (Exception exception) {
            return (ViewHandler)ApplicationManager.getApplication().runReadAction(() -> {
                try {
                    String qualifiedClassName = this.getFullyQualifiedClassName(viewTag);
                    if (qualifiedClassName != null) {
                        String handlerName = viewTag + HANDLER_CLASS_SUFFIX;
                        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myProject);
                        PsiClass[] classes = facade.findClasses(handlerName, GlobalSearchScope.allScope((Project)this.myProject));
                        if (classes.length == 0) {
                            for (PsiClass cls : classes = facade.findClasses(qualifiedClassName, GlobalSearchScope.allScope((Project)this.myProject))) {
                                String fqn;
                                PsiClass superClass = cls.getSuperClass();
                                if (superClass == null || (fqn = superClass.getQualifiedName()) == null) continue;
                                return this.getHandler(NlComponentHelper.INSTANCE.viewClassToTag(fqn));
                            }
                        } else {
                            for (PsiClass cls : classes) {
                                System.out.println("Find view handler " + cls.getQualifiedName() + " of type " + cls.getClass().getName());
                            }
                        }
                    }
                }
                catch (IndexNotReadyException ignore) {
                    return NONE;
                }
                return NONE;
            });
        }
    }

    @Nullable
    private String getFullyQualifiedClassName(@NotNull String viewTag) {
        if (viewTag.indexOf(46) > 0) {
            return viewTag;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myProject);
        for (String packageName : NO_PREFIX_PACKAGES) {
            PsiClass[] classes = facade.findClasses(packageName + viewTag, GlobalSearchScope.allScope((Project)this.myProject));
            if (classes.length <= 0) continue;
            return packageName + viewTag;
        }
        return null;
    }

    public List<ViewAction> getToolbarActions(@NotNull ViewHandler handler) {
        ArrayList actions = this.myToolbarActions.get(handler);
        if (actions == null) {
            actions = Lists.newArrayList();
            handler.addToolbarActions(actions);
            this.myToolbarActions.put(handler, actions);
        }
        return actions;
    }

    public List<ViewAction> getPopupMenuActions(@NotNull ViewHandler handler) {
        ArrayList actions = this.myMenuActions.get(handler);
        if (actions == null) {
            actions = Lists.newArrayList();
            handler.addPopupMenuActions(actions);
            this.myMenuActions.put(handler, actions);
        }
        return actions;
    }

    public void projectOpened() {
    }

    public void projectClosed() {
        this.myHandlers.clear();
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        this.myHandlers.clear();
    }

    @NotNull
    public String getComponentName() {
        return "ViewHandlerManager";
    }
}

