/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.psi.PsiClass;
import java.util.Collections;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewTagHandler
extends ViewHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"class", (Object)"style");
    }

    @Override
    @NotNull
    public String getTitle(@NotNull String tagName) {
        return "<view>";
    }

    @Override
    @NotNull
    public String getTitle(@NotNull NlComponent component2) {
        return "<view>";
    }

    @Override
    @Language(value="XML")
    @NotNull
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        switch (xmlType) {
            case COMPONENT_CREATION: {
                return "<view/>";
            }
            case PREVIEW_ON_PALETTE: 
            case DRAG_PREVIEW: {
                return "";
            }
        }
        return super.getXml(tagName, xmlType);
    }

    @Override
    public boolean onCreate(@NotNull ViewEditor editor, @Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (insertType == InsertType.CREATE) {
            String src = editor.displayClassInput(Collections.singleton("android.view.View"), ViewTagHandler::isViewSuitableForLayout, null);
            if (src != null) {
                newChild.setAttribute(null, "class", src);
                return true;
            }
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static boolean isViewSuitableForLayout(@NotNull PsiClass psiClass) {
        if (!psiClass.hasModifierProperty("public")) {
            return false;
        }
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        return !qualifiedName.startsWith("android.") || qualifiedName.startsWith("android.support.");
    }
}

