/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.common;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.common.MatchPos;
import com.android.tools.idea.uibuilder.model.Insets;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import java.util.ArrayList;
import java.util.List;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericLinearDragHandler
extends DragHandler {
    private final boolean myVertical;
    private final List<MatchPos> myIndices;
    private final int myNumPositions;
    private Integer myCurrX;
    private Integer myCurrY;
    private int mySelfPos;
    private int myInsertPos = -1;
    private Integer myWidth;
    private Integer myHeight;
    private SceneComponent myComponent;

    public GenericLinearDragHandler(@NotNull ViewEditor editor, @NotNull SceneComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type, @NotNull ViewGroupHandler viewGroupHandler, boolean isVertical) {
        super(editor, viewGroupHandler, layout, components, type);
        assert (!components.isEmpty());
        this.myVertical = isVertical;
        this.myIndices = new ArrayList<MatchPos>();
        int last = this.myVertical ? layout.getDrawY() + editor.pxToDp(NlComponentHelperKt.getPadding((NlComponent)layout.getNlComponent()).top) : layout.getDrawX() + editor.pxToDp(NlComponentHelperKt.getPadding((NlComponent)layout.getNlComponent()).left);
        int pos = 0;
        boolean lastDragged = false;
        this.mySelfPos = -1;
        if (this.myVertical) {
            layout.getChildren().sort((c1, c2) -> c1.getDrawY() - c2.getDrawY());
        } else {
            layout.getChildren().sort((c1, c2) -> c1.getDrawX() - c2.getDrawX());
        }
        for (SceneComponent it : layout.getChildren()) {
            if (it.getDrawWidth() > 0 && it.getDrawHeight() > 0) {
                int v;
                boolean isDragged = components.contains(it.getNlComponent());
                if (isDragged) {
                    v = this.myVertical ? it.getDrawY() + it.getDrawHeight() / 2 : it.getDrawX() + it.getDrawWidth() / 2;
                    this.mySelfPos = pos;
                    this.myIndices.add(new MatchPos(v, pos++));
                } else if (lastDragged) {
                    ++pos;
                } else {
                    v = this.myVertical ? it.getDrawY() : it.getDrawX();
                    v = (last + v) / 2;
                    this.myIndices.add(new MatchPos(v, pos++));
                }
                last = this.myVertical ? it.getDrawY() + it.getDrawHeight() : it.getDrawX() + it.getDrawWidth();
                lastDragged = isDragged;
                continue;
            }
            ++pos;
        }
        if (!lastDragged) {
            int v = last + 1;
            this.myIndices.add(new MatchPos(v, pos));
        }
        this.myNumPositions = layout.getChildCount() + 1;
        NlComponent component2 = components.get(0);
        this.myComponent = new TemporarySceneComponent(layout.getScene(), component2);
        this.myComponent.setSize(editor.pxToDp(NlComponentHelperKt.getW(component2)), editor.pxToDp(NlComponentHelperKt.getH(component2)), false);
    }

    @Override
    @Nullable
    public String update(int x, int y, @JdkConstants.InputEventMask int modifiers) {
        super.update(x, y, modifiers);
        boolean isVertical = this.myVertical;
        int bestDist = Integer.MAX_VALUE;
        int bestIndex = Integer.MIN_VALUE;
        Integer bestPos = null;
        for (MatchPos index : this.myIndices) {
            int i = index.getDistance();
            int pos = index.getPosition();
            int dist = (isVertical ? y : x) - i;
            if (dist < 0) {
                dist = -dist;
            }
            if (dist >= bestDist) continue;
            bestDist = dist;
            bestIndex = i;
            bestPos = pos;
            if (bestDist > 0) continue;
            break;
        }
        if (bestIndex != Integer.MIN_VALUE) {
            if (isVertical) {
                this.myCurrX = this.layout.getDrawX() + this.layout.getDrawWidth() / 2;
                this.myCurrY = bestIndex;
                this.myWidth = this.layout.getDrawWidth();
                this.myHeight = null;
            } else {
                this.myCurrX = bestIndex;
                this.myCurrY = this.layout.getDrawY() + this.layout.getDrawHeight() / 2;
                this.myWidth = null;
                this.myHeight = this.layout.getDrawHeight();
            }
            this.myInsertPos = bestPos;
        }
        return null;
    }

    @Override
    public void paint(@NotNull NlGraphics gc) {
        Insets padding = NlComponentHelperKt.getPadding(this.layout.getNlComponent());
        int layoutX = this.layout.getDrawX() + this.editor.pxToDp(padding.left);
        int layoutW = this.layout.getDrawWidth() - this.editor.pxToDp(padding.width());
        int layoutY = this.layout.getDrawY() + this.editor.pxToDp(padding.top);
        int layoutH = this.layout.getDrawHeight() - this.editor.pxToDp(padding.height());
        gc.useStyle(NlDrawingStyle.DROP_RECIPIENT);
        gc.drawRectDp(layoutX, layoutY, layoutW, layoutH);
        gc.useStyle(NlDrawingStyle.DROP_ZONE);
        boolean isVertical = this.myVertical;
        int selfPos = this.mySelfPos;
        for (MatchPos it : this.myIndices) {
            int i = it.getDistance();
            int pos = it.getPosition();
            if (pos == selfPos) continue;
            if (isVertical) {
                gc.drawLineDp(layoutX, i, layoutX + layoutW, i);
                continue;
            }
            gc.drawLineDp(i, layoutY, i, layoutY + layoutH);
        }
        Integer currX = this.myCurrX;
        Integer currY = this.myCurrY;
        if (currX != null && currY != null) {
            SceneComponent be;
            gc.useStyle(NlDrawingStyle.DROP_ZONE_ACTIVE);
            int x = currX;
            int y = currY;
            if (this.myInsertPos != selfPos || selfPos == -1) {
                gc.useStyle(NlDrawingStyle.DROP_PREVIEW);
                if (this.myWidth != null) {
                    int width = this.myWidth;
                    int fromX = x - width / 2;
                    int toX = x + width / 2;
                    gc.drawLineDp(fromX, y, toX, y);
                } else if (this.myHeight != null) {
                    int height = this.myHeight;
                    int fromY = y - height / 2;
                    int toY = y + height / 2;
                    gc.drawLineDp(x, fromY, x, toY);
                }
            }
            if ((be = this.myComponent).getDrawWidth() > 0 && be.getDrawHeight() > 0) {
                int offsetY;
                int offsetX;
                boolean isLast;
                boolean bl = isLast = this.myInsertPos == this.myNumPositions - 1;
                if (isVertical) {
                    offsetX = layoutX - be.getDrawX();
                    offsetY = currY - be.getDrawY() - (isLast ? 0 : be.getDrawHeight() / 2);
                } else {
                    offsetX = currX - be.getDrawX() - (isLast ? 0 : be.getDrawWidth() / 2);
                    offsetY = layoutY - be.getDrawY();
                }
                gc.useStyle(NlDrawingStyle.DROP_ZONE_ACTIVE);
                for (NlComponent nlComponent : this.components) {
                    SceneComponent element = this.layout.getSceneComponent(nlComponent);
                    if (nlComponent == this.myComponent.getNlComponent()) {
                        element = this.myComponent;
                    }
                    if (element == null) continue;
                    if (element.getDrawWidth() > 0 && element.getDrawHeight() > 0 && (element.getDrawWidth() > layoutW || element.getDrawHeight() > layoutH) && this.layout.getChildCount() == 0) {
                        int ph;
                        int py;
                        int pw;
                        int px;
                        if (element.getDrawWidth() > layoutW) {
                            px = layoutX;
                            pw = layoutW;
                        } else {
                            px = element.getDrawX() + offsetX;
                            pw = element.getDrawWidth();
                        }
                        if (element.getDrawHeight() > layoutH) {
                            py = layoutY;
                            ph = layoutH;
                        } else {
                            py = element.getDrawY() + offsetY;
                            ph = element.getDrawHeight();
                        }
                        gc.drawRectDp(px, py, pw, ph);
                        continue;
                    }
                    this.drawElement(gc, element, this.editor.dpToPx(offsetX), this.editor.dpToPx(offsetY));
                }
            }
        }
    }

    public void drawElement(NlGraphics gc, SceneComponent component2, int offsetX, int offsetY) {
        int w = this.editor.dpToPx(component2.getDrawWidth());
        int h = this.editor.dpToPx(component2.getDrawHeight());
        if (w > 0 && h > 0) {
            gc.fillRect(offsetX, offsetY, w, h);
            gc.drawRect(offsetX, offsetY, w, h);
        }
        for (SceneComponent inner : component2.getChildren()) {
            this.drawElement(gc, inner, offsetX, offsetY);
        }
    }

    @Override
    public void cancel() {
        Scene scene = ((ViewEditorImpl)this.editor).getSceneView().getScene();
        scene.removeComponent(this.myComponent);
    }

    @Override
    public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
        this.insertComponents(this.myInsertPos, insertType);
        Scene scene = ((ViewEditorImpl)this.editor).getSceneView().getScene();
        scene.removeComponent(this.myComponent);
    }
}

