/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.AnchorTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.android.tools.idea.uibuilder.scene.decorator.DecoratorUtilities;
import com.android.tools.idea.uibuilder.scout.Direction;
import com.android.utils.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConstraintComponentUtilities {
    public static final HashMap<String, String> ourReciprocalAttributes;
    public static final HashMap<String, String> ourMapMarginAttributes;
    public static final HashMap<String, AnchorTarget.Type> ourMapSideToOriginAnchors;
    public static final ArrayList<String> ourLeftAttributes;
    public static final ArrayList<String> ourTopAttributes;
    public static final ArrayList<String> ourRightAttributes;
    public static final ArrayList<String> ourBottomAttributes;
    public static final ArrayList<String> ourStartAttributes;
    public static final ArrayList<String> ourEndAttributes;
    public static final ArrayList<String> ourBaselineAttributes;
    public static final ArrayList<String> ourHorizontalAttributes;
    public static final ArrayList<String> ourVerticalAttributes;
    public static final HashMap<String, String> ourLayoutUriToPrefix;
    public static final ArrayList<Pair<String, String>> ourLayoutAttributes;
    private static final HashMap<Pair<AnchorTarget.Type, AnchorTarget.Type>, String> ourConstraintAttributes;
    private static final HashMap<String, String> ourLTRConvertedAttributes;
    private static final HashMap<Pair<AnchorTarget.Type, AnchorTarget.Type>, String> ourLTRConstraintAnchorsToMargin;
    public static final HashMap<String, AnchorTarget.Type> ourLTRMapSideToTargetAnchors;
    private static final HashMap<String, String> ourRTLConvertedAttributes;
    private static final HashMap<Pair<AnchorTarget.Type, AnchorTarget.Type>, String> ourRTLConstraintAnchorsToMargin;
    public static final HashMap<String, AnchorTarget.Type> ourRTLMapSideToTargetAnchors;
    private static final HashMap<AnchorTarget.Type, Pair<String, String>> ourPotentialAttributes;
    private static final HashMap<AnchorTarget.Type, Pair<String, String>> ourPotentialLTRAttributes;
    private static final HashMap<AnchorTarget.Type, Pair<String, String>> ourPotentialRTLAttributes;
    public static final String[] ourConstraintLayoutAttributesToClear;
    public static final String[] ourLayoutAttributesToClear;
    public static String[][] ATTRIB_MATRIX;
    public static String[][] ATTRIB_CLEAR;
    public static String[] ATTRIB_MARGIN;

    public static String getAttribute(AnchorTarget.Type source, AnchorTarget.Type destination, boolean useRtlAttributes, boolean isRtl) {
        if (source == AnchorTarget.Type.BASELINE && destination == AnchorTarget.Type.BASELINE) {
            return "layout_constraintBaseline_toBaselineOf";
        }
        String attribute = ourConstraintAttributes.get(Pair.of((Object)((Object)source), (Object)((Object)destination)));
        if (useRtlAttributes) {
            String converted = null;
            converted = isRtl ? ourRTLConvertedAttributes.get(attribute) : ourLTRConvertedAttributes.get(attribute);
            if (converted != null) {
                attribute = converted;
            }
        }
        return attribute;
    }

    public static void clearAnchor(AnchorTarget.Type type, AttributesTransaction transaction, boolean useRtlAttributes, boolean isRtl) {
        switch (type) {
            case LEFT: {
                ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourPotentialAttributes.get((Object)AnchorTarget.Type.LEFT), transaction);
                if (!useRtlAttributes) break;
                if (isRtl) {
                    ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourPotentialRTLAttributes.get((Object)AnchorTarget.Type.LEFT), transaction);
                    break;
                }
                ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourPotentialLTRAttributes.get((Object)AnchorTarget.Type.LEFT), transaction);
                break;
            }
            case RIGHT: {
                ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourPotentialAttributes.get((Object)AnchorTarget.Type.RIGHT), transaction);
                if (!useRtlAttributes) break;
                if (isRtl) {
                    ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourPotentialRTLAttributes.get((Object)AnchorTarget.Type.RIGHT), transaction);
                    break;
                }
                ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourPotentialLTRAttributes.get((Object)AnchorTarget.Type.RIGHT), transaction);
                break;
            }
            case TOP: {
                ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourTopAttributes, transaction);
                break;
            }
            case BOTTOM: {
                ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourBottomAttributes, transaction);
                break;
            }
            case BASELINE: {
                transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf", null);
            }
        }
    }

    public static boolean isAnchorConnected(AnchorTarget.Type type, NlComponent component2, boolean useRtlAttributes, boolean isRtl) {
        if (type == AnchorTarget.Type.BASELINE) {
            return component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf") != null;
        }
        boolean isConnected = false;
        Pair<String, String> pair = ourPotentialAttributes.get((Object)type);
        if (pair != null) {
            isConnected |= component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getFirst()) != null;
            isConnected |= component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getSecond()) != null;
        }
        if (useRtlAttributes) {
            if (isRtl) {
                pair = ourPotentialRTLAttributes.get((Object)type);
                if (pair != null) {
                    isConnected |= component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getFirst()) != null;
                    isConnected |= component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getSecond()) != null;
                }
            } else {
                pair = ourPotentialLTRAttributes.get((Object)type);
                if (pair != null) {
                    isConnected |= component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getFirst()) != null;
                    isConnected |= component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getSecond()) != null;
                }
            }
        }
        return isConnected;
    }

    public static AnchorTarget getOriginAnchor(Scene scene, NlComponent targetComponent, String attribute) {
        AnchorTarget.Type type = ourMapSideToOriginAnchors.get(attribute);
        SceneComponent component2 = scene.getSceneComponent(targetComponent);
        if (component2 != null) {
            return ConstraintComponentUtilities.getAnchorTarget(component2, type);
        }
        return null;
    }

    public static AnchorTarget getTargetAnchor(Scene scene, NlComponent targetComponent, String attribute, boolean supportsRtl, boolean isInRtl) {
        SceneComponent component2 = scene.getSceneComponent(targetComponent);
        if (component2 == null) {
            return null;
        }
        if (supportsRtl) {
            if (isInRtl) {
                return ConstraintComponentUtilities.getAnchorTarget(component2, ourRTLMapSideToTargetAnchors.get(attribute));
            }
            return ConstraintComponentUtilities.getAnchorTarget(component2, ourLTRMapSideToTargetAnchors.get(attribute));
        }
        return ConstraintComponentUtilities.getAnchorTarget(component2, ourLTRMapSideToTargetAnchors.get(attribute));
    }

    public static AnchorTarget getAnchorTarget(@NotNull SceneComponent component2, @NotNull AnchorTarget.Type type) {
        for (Target target : component2.getTargets()) {
            if (!(target instanceof AnchorTarget) || ((AnchorTarget)target).getType() != type) continue;
            return (AnchorTarget)target;
        }
        return null;
    }

    private static boolean hasConstraints(NlComponent component2, String uri, ArrayList<String> constraints) {
        int count = constraints.size();
        for (int i = 0; i < count; ++i) {
            if (component2.getLiveAttribute(uri, constraints.get(i)) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean hasHorizontalConstraints(NlComponent component2) {
        return ConstraintComponentUtilities.hasConstraints(component2, "http://schemas.android.com/apk/res-auto", ourHorizontalAttributes);
    }

    public static boolean hasVerticalConstraints(NlComponent component2) {
        return ConstraintComponentUtilities.hasConstraints(component2, "http://schemas.android.com/apk/res-auto", ourVerticalAttributes);
    }

    public static int getDpValue(@NotNull NlComponent component2, String value) {
        Configuration configuration;
        ResourceResolver resourceResolver;
        if (value != null && (resourceResolver = (configuration = component2.getModel().getConfiguration()).getResourceResolver()) != null) {
            Integer px = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver, value, configuration);
            return px == null ? 0 : (int)(0.5f + (float)px.intValue() / ((float)configuration.getDensity().getDpiValue() / 160.0f));
        }
        return 0;
    }

    public static int getGuidelineMode(SceneComponent component2) {
        NlComponent nlComponent = component2.getAuthoritativeNlComponent();
        String begin = nlComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin");
        String end = nlComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end");
        if (begin != null) {
            return 0;
        }
        if (end != null) {
            return 1;
        }
        return 16;
    }

    public static NlComponent getOriginalComponent(@NotNull NlComponent component2) {
        NlComponent parent;
        if (NlComponentHelperKt.isOrHasSuperclass(component2, "android.support.constraint.Reference") && NlComponentHelperKt.isOrHasSuperclass(parent = component2.getParent(), "android.support.constraint.Constraints") && NlComponentHelperKt.isOrHasSuperclass(parent = parent.getParent(), "android.support.constraint.ConstraintLayout")) {
            for (NlComponent child : parent.getChildren()) {
                if (child.getId() == null || !child.getId().equals(component2.getId())) continue;
                return child;
            }
        }
        return component2;
    }

    public static void clearAttributes(NlComponent component2) {
        AttributesTransaction transaction = component2.startAttributeTransaction();
        ConstraintComponentUtilities.clearAllAttributes(component2, transaction);
        transaction.apply();
        NlWriteCommandAction.run(component2, "Cleared all constraints", transaction::commit);
    }

    public static void setDpAttribute(String uri, String attribute, AttributesTransaction transaction, int value) {
        if (value > 0) {
            String position = String.format("%ddp", value);
            transaction.setAttribute(uri, attribute, position);
        }
    }

    public static void clearAttributes(String uri, ArrayList<String> attributes, AttributesTransaction transaction) {
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            transaction.setAttribute(uri, attribute, null);
        }
    }

    public static void clearAttributes(String uri, String[] attributes, AttributesTransaction transaction) {
        for (int i = 0; i < attributes.length; ++i) {
            transaction.setAttribute(uri, attributes[i], null);
        }
    }

    public static void clearAttributes(String uri, Pair<String, String> attributes, AttributesTransaction transaction) {
        transaction.setAttribute(uri, (String)attributes.getFirst(), null);
        transaction.setAttribute(uri, (String)attributes.getSecond(), null);
    }

    public static void clearConnections(NlComponent component2, ArrayList<String> attributes, AttributesTransaction transaction) {
        float dpiFactor;
        NlComponent parent;
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", attribute, null);
        }
        if (attributes == ourLeftAttributes) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
        } else if (attributes == ourRightAttributes) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
        } else if (attributes == ourStartAttributes) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
        } else if (attributes == ourEndAttributes) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
        } else if (attributes == ourTopAttributes) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
        } else if (attributes == ourBottomAttributes) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
        }
        if (!ConstraintComponentUtilities.hasHorizontalConstraints(component2)) {
            int offsetX = 0;
            parent = component2.getParent();
            if (parent != null) {
                offsetX = NlComponentHelperKt.getX(component2) - NlComponentHelperKt.getX(parent);
                dpiFactor = (float)component2.getModel().getConfiguration().getDensity().getDpiValue() / 160.0f;
                offsetX = (int)(0.5f + (float)offsetX / dpiFactor);
            }
            ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", transaction, offsetX);
        }
        if (!ConstraintComponentUtilities.hasVerticalConstraints(component2)) {
            int offsetY = 0;
            parent = component2.getParent();
            if (parent != null) {
                offsetY = NlComponentHelperKt.getY(component2) - NlComponentHelperKt.getY(parent);
                dpiFactor = (float)component2.getModel().getConfiguration().getDensity().getDpiValue() / 160.0f;
                offsetY = (int)(0.5f + (float)offsetY / dpiFactor);
            }
            ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", transaction, offsetY);
        }
    }

    private static void clearAllAttributes(NlComponent component2, AttributesTransaction transaction) {
        if (ConstraintComponentUtilities.isWidthConstrained(component2) && ConstraintComponentUtilities.isHorizontalResizable(component2)) {
            String fixedWidth = String.format("%ddp", ConstraintComponentUtilities.getDpWidth(component2));
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", fixedWidth);
        }
        if (ConstraintComponentUtilities.isHeightConstrained(component2) && ConstraintComponentUtilities.isVerticalResizable(component2)) {
            String fixedHeight = String.format("%ddp", ConstraintComponentUtilities.getDpHeight(component2));
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", fixedHeight);
        }
        ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourConstraintLayoutAttributesToClear, transaction);
        ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res/android", ourLayoutAttributesToClear, transaction);
        component2 = ConstraintComponentUtilities.getOriginalComponent(component2);
        int offsetX = Coordinates.pxToDp(component2.getModel(), NlComponentHelperKt.getX(component2) - (component2.isRoot() ? 0 : NlComponentHelperKt.getX(component2.getParent())));
        int offsetY = Coordinates.pxToDp(component2.getModel(), NlComponentHelperKt.getY(component2) - (component2.isRoot() ? 0 : NlComponentHelperKt.getY(component2.getParent())));
        ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", transaction, offsetX);
        ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", transaction, offsetY);
    }

    public static void updateOnDelete(NlComponent component2, String targetId) {
        AttributesTransaction transaction = null;
        transaction = ConstraintComponentUtilities.updateOnDelete(component2, ourLeftAttributes, transaction, targetId);
        transaction = ConstraintComponentUtilities.updateOnDelete(component2, ourTopAttributes, transaction, targetId);
        transaction = ConstraintComponentUtilities.updateOnDelete(component2, ourRightAttributes, transaction, targetId);
        transaction = ConstraintComponentUtilities.updateOnDelete(component2, ourBottomAttributes, transaction, targetId);
        transaction = ConstraintComponentUtilities.updateOnDelete(component2, ourBaselineAttributes, transaction, targetId);
        transaction = ConstraintComponentUtilities.updateOnDelete(component2, ourStartAttributes, transaction, targetId);
        if ((transaction = ConstraintComponentUtilities.updateOnDelete(component2, ourEndAttributes, transaction, targetId)) != null) {
            transaction.apply();
            NlWriteCommandAction.run(component2, "Remove constraints pointing to a deleted component", transaction::commit);
        }
    }

    public static AttributesTransaction updateOnDelete(NlComponent component2, ArrayList<String> attributes, AttributesTransaction transaction, String targetId) {
        if (ConstraintComponentUtilities.isConnectedTo(component2, attributes, targetId)) {
            if (transaction == null) {
                transaction = component2.startAttributeTransaction();
            }
            ConstraintComponentUtilities.clearConnections(component2, attributes, transaction);
        }
        return transaction;
    }

    public static boolean isConnectedTo(NlComponent component2, ArrayList<String> attributes, String targetId) {
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            String target = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", attribute);
            if ((target = NlComponent.extractId(target)) == null || !target.equalsIgnoreCase(targetId)) continue;
            return true;
        }
        return false;
    }

    public static void ensureHorizontalPosition(NlComponent component2, AttributesTransaction transaction) {
        if (ConstraintComponentUtilities.hasHorizontalConstraints(component2)) {
            return;
        }
        int dx = NlComponentHelperKt.getX(component2) - (component2.getParent() != null ? NlComponentHelperKt.getX(component2.getParent()) : 0);
        if (dx > 0) {
            float dipValue = (float)component2.getModel().getConfiguration().getDensity().getDpiValue() / 160.0f;
            String position = String.format("%ddp", (int)(0.5f + (float)dx / dipValue));
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", position);
        }
    }

    public static void ensureVerticalPosition(NlComponent component2, AttributesTransaction transaction) {
        if (ConstraintComponentUtilities.hasVerticalConstraints(component2)) {
            return;
        }
        int dy = NlComponentHelperKt.getY(component2) - (component2.getParent() != null ? NlComponentHelperKt.getY(component2.getParent()) : 0);
        if (dy > 0) {
            float dipValue = (float)component2.getModel().getConfiguration().getDensity().getDpiValue() / 160.0f;
            String position = String.format("%ddp", (int)(0.5f + (float)dy / dipValue));
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", position);
        }
    }

    public static boolean isConstraintModelGreaterThan(NlModel model, int major, int ... version) {
        String constraint_artifact = "com.android.support.constraint:constraint-layout";
        GradleVersion v = NlModelHelperKt.getModuleDependencyVersion(model, constraint_artifact);
        return ConstraintComponentUtilities.versionGreaterThan(v, major, version.length > 0 ? version[0] : -1, version.length > 1 ? version[1] : -1, 0, 0);
    }

    private static boolean versionGreaterThan(GradleVersion v, int major, int minor, int micro, int beta, int alpha) {
        if (v == null) {
            return true;
        }
        if (v.getMajor() != major) {
            return v.getMajor() > major;
        }
        if (v.getMinor() != minor) {
            return v.getMinor() > minor;
        }
        if (micro == -1) {
            return false;
        }
        if (v.getMicro() != micro) {
            return v.getMicro() > micro;
        }
        if (alpha > 0) {
            if ("alpha".equals(v.getPreviewType())) {
                return v.getPreview() > alpha;
            }
            return true;
        }
        if (beta > 0) {
            if ("beta".equals(v.getPreviewType())) {
                return v.getPreview() > beta;
            }
            return true;
        }
        return false;
    }

    public static int getDpX(@NotNull NlComponent component2) {
        float dpiFactor = (float)component2.getModel().getConfiguration().getDensity().getDpiValue() / 160.0f;
        return (int)(0.5f + (float)NlComponentHelperKt.getX(component2) / dpiFactor);
    }

    private static boolean hasAttributes(@NotNull AttributesTransaction transaction, String uri, ArrayList<String> attributes) {
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            if (transaction.getAttribute(uri, attribute) == null) continue;
            return true;
        }
        return false;
    }

    public static String getConnectionId(@NotNull NlComponent component2, String uri, ArrayList<String> attributes) {
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = component2.getLiveAttribute(uri, attributes.get(i));
            if (attribute == null) continue;
            return NlComponent.extractId(attribute);
        }
        return null;
    }

    private static boolean hasLeft(@NotNull AttributesTransaction transaction) {
        return ConstraintComponentUtilities.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourLeftAttributes);
    }

    private static boolean hasTop(@NotNull AttributesTransaction transaction) {
        return ConstraintComponentUtilities.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourTopAttributes);
    }

    private static boolean hasRight(@NotNull AttributesTransaction transaction) {
        return ConstraintComponentUtilities.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourRightAttributes);
    }

    private static boolean hasBottom(@NotNull AttributesTransaction transaction) {
        return ConstraintComponentUtilities.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourBottomAttributes);
    }

    private static boolean hasStart(@NotNull AttributesTransaction transaction) {
        return ConstraintComponentUtilities.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourStartAttributes);
    }

    private static boolean hasEnd(@NotNull AttributesTransaction transaction) {
        return ConstraintComponentUtilities.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourEndAttributes);
    }

    public static void cleanup(@NotNull AttributesTransaction transaction, @NotNull SceneComponent component2) {
        String margin;
        boolean hasEnd;
        boolean supportsRTL = component2.getScene().supportsRTL();
        boolean hasLeft = ConstraintComponentUtilities.hasLeft(transaction);
        boolean hasRight = ConstraintComponentUtilities.hasRight(transaction);
        boolean hasTop = ConstraintComponentUtilities.hasTop(transaction);
        boolean hasBottom = ConstraintComponentUtilities.hasBottom(transaction);
        boolean hasBaseline = transaction.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf") != null;
        boolean hasStart = supportsRTL && ConstraintComponentUtilities.hasStart(transaction);
        boolean bl = hasEnd = supportsRTL && ConstraintComponentUtilities.hasEnd(transaction);
        if (!hasLeft) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", null);
        } else {
            margin = transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft");
            if (margin != null && margin.equalsIgnoreCase("0dp")) {
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", null);
            }
        }
        if (!hasRight) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", null);
        } else {
            margin = transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight");
            if (margin != null && margin.equalsIgnoreCase("0dp")) {
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", null);
            }
        }
        if (!hasStart) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart", null);
        } else {
            margin = transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart");
            if (margin != null && margin.equalsIgnoreCase("0dp")) {
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart", null);
            }
        }
        if (!hasEnd) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd", null);
        } else {
            margin = transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd");
            if (margin != null && margin.equalsIgnoreCase("0dp")) {
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd", null);
            }
        }
        if (!(hasLeft && hasRight || hasStart && hasEnd)) {
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
        }
        if (!(hasLeft || hasRight || hasStart || hasEnd)) {
            if (transaction.getAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX") == null) {
                ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", transaction, component2.getOffsetParentX());
                transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_chainStyle", null);
            }
        } else {
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", null);
        }
        if (!hasTop) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
        } else {
            margin = transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop");
            if (margin != null && margin.equalsIgnoreCase("0dp")) {
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", null);
            }
        }
        if (!hasBottom) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
        } else {
            margin = transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom");
            if (margin != null && margin.equalsIgnoreCase("0dp")) {
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", null);
            }
        }
        if (!(hasTop || hasBottom || hasBaseline)) {
            if (transaction.getAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY") == null) {
                ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", transaction, component2.getOffsetParentY());
                transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_chainStyle", null);
            }
        } else {
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", null);
        }
        if (!component2.allowsFixedPosition()) {
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", null);
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", null);
        }
    }

    @Nullable
    public static SceneComponent findChainHead(@NotNull SceneComponent component2, @NotNull ArrayList<String> sideA, @NotNull ArrayList<String> sideB) {
        int maxAttempts = 1000;
        for (int i = 0; i < 1000; ++i) {
            NlComponent nlComponent = component2.getAuthoritativeNlComponent();
            String attributeA = ConstraintComponentUtilities.getConnectionId(nlComponent, "http://schemas.android.com/apk/res-auto", sideA);
            if (attributeA == null) {
                return component2;
            }
            SceneComponent target = component2.getScene().getSceneComponent(attributeA);
            if (target == null) {
                return component2;
            }
            String attributeB = ConstraintComponentUtilities.getConnectionId(target.getAuthoritativeNlComponent(), "http://schemas.android.com/apk/res-auto", sideB);
            if (attributeB == null) {
                return component2;
            }
            if (!attributeB.equalsIgnoreCase(nlComponent.getId())) {
                return component2;
            }
            component2 = target;
        }
        return null;
    }

    public static boolean isInChain(ArrayList<String> sideA, ArrayList<String> sideB, SceneComponent component2) {
        String attributeB;
        SceneComponent target;
        String attributeA = ConstraintComponentUtilities.getConnectionId(component2.getAuthoritativeNlComponent(), "http://schemas.android.com/apk/res-auto", sideA);
        return attributeA != null && (target = component2.getScene().getSceneComponent(attributeA)) != null && (attributeB = ConstraintComponentUtilities.getConnectionId(target.getAuthoritativeNlComponent(), "http://schemas.android.com/apk/res-auto", sideB)) != null && attributeB.equalsIgnoreCase(component2.getAuthoritativeNlComponent().getId());
    }

    @Nullable
    public static NlComponent findChainHead(@Nullable NlComponent component2, @Nullable ArrayList<String> sideA, @Nullable ArrayList<String> sideB) {
        int maxAttempts = 1000;
        for (int i = 0; i < 1000; ++i) {
            String attributeA = ConstraintComponentUtilities.getConnectionId(component2, "http://schemas.android.com/apk/res-auto", sideA);
            if (attributeA == null) {
                return component2;
            }
            List<NlComponent> list = component2.getParent().getChildren();
            NlComponent target = ConstraintComponentUtilities.getComponent(list, attributeA);
            if (target == null) {
                return component2;
            }
            String attributeB = ConstraintComponentUtilities.getConnectionId(target, "http://schemas.android.com/apk/res-auto", sideB);
            if (attributeB == null) {
                return component2;
            }
            if (!attributeB.equalsIgnoreCase(component2.getId())) {
                return component2;
            }
            component2 = target;
        }
        return null;
    }

    public static NlComponent getComponent(List<NlComponent> list, String id) {
        for (NlComponent nlComponent : list) {
            if (!id.equals(nlComponent.getId())) continue;
            return nlComponent;
        }
        return null;
    }

    public static boolean isInChain(@NotNull ArrayList<String> sideA, @NotNull ArrayList<String> sideB, @NotNull NlComponent component2) {
        String attributeB;
        List<NlComponent> list;
        NlComponent target;
        String attributeA = ConstraintComponentUtilities.getConnectionId(component2, "http://schemas.android.com/apk/res-auto", sideA);
        NlComponent parent = component2.getParent();
        return attributeA != null && parent != null && (target = ConstraintComponentUtilities.getComponent(list = parent.getChildren(), attributeA)) != null && (attributeB = ConstraintComponentUtilities.getConnectionId(target, "http://schemas.android.com/apk/res-auto", sideB)) != null && attributeB.equalsIgnoreCase(component2.getId());
    }

    public static void cycleChainStyle(@NotNull SceneComponent chainHeadComponent, @NotNull String orientationStyle, @NotNull SceneComponent component2) {
        NlComponent chainHead = chainHeadComponent.getAuthoritativeNlComponent();
        String chainStyle = chainHead.getLiveAttribute("http://schemas.android.com/apk/res-auto", orientationStyle);
        if (chainStyle != null) {
            if (chainStyle.equalsIgnoreCase("spread")) {
                chainStyle = "spread_inside";
            } else if (chainStyle.equalsIgnoreCase("spread_inside")) {
                chainStyle = "packed";
            } else if (chainStyle.equalsIgnoreCase("packed")) {
                chainStyle = "spread";
            }
        } else {
            chainStyle = "spread_inside";
        }
        AttributesTransaction transaction = chainHead.startAttributeTransaction();
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", orientationStyle, chainStyle);
        transaction.apply();
        NlWriteCommandAction.run(chainHead, "Cycle chain style", transaction::commit);
        component2.getScene().needsRebuildList();
    }

    public static int getDpY(@NotNull NlComponent component2) {
        float dpiFactor = (float)component2.getModel().getConfiguration().getDensity().getDpiValue() / 160.0f;
        return (int)(0.5f + (float)NlComponentHelperKt.getY(component2) / dpiFactor);
    }

    public static int getDpWidth(@NotNull NlComponent component2) {
        float dpiFactor = (float)component2.getModel().getConfiguration().getDensity().getDpiValue() / 160.0f;
        return (int)(0.5f + (float)NlComponentHelperKt.getW(component2) / dpiFactor);
    }

    public static int getDpHeight(@NotNull NlComponent component2) {
        float dpiFactor = (float)component2.getModel().getConfiguration().getDensity().getDpiValue() / 160.0f;
        return (int)(0.5f + (float)NlComponentHelperKt.getH(component2) / dpiFactor);
    }

    public static int pixelToDP(@NotNull NlComponent component2, int size) {
        float dpiFactor = (float)component2.getModel().getConfiguration().getDensity().getDpiValue() / 160.0f;
        return (int)(0.5f + (float)size / dpiFactor);
    }

    public static int getDpBaseline(@NotNull NlComponent component2) {
        float dpiFactor = (float)component2.getModel().getConfiguration().getDensity().getDpiValue() / 160.0f;
        return (int)(0.5f + (float)NlComponentHelperKt.getBaseline(component2) / dpiFactor);
    }

    public static boolean hasBaseline(@NotNull NlComponent component2) {
        return NlComponentHelperKt.getBaseline(component2) > 0;
    }

    public static boolean isLine(@NotNull NlComponent component2) {
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(component2);
        if (viewInfo == null) {
            return false;
        }
        if (NlComponentHelperKt.isOrHasSuperclass(component2, "android.support.constraint.Guideline")) {
            return true;
        }
        return NlComponentHelperKt.isOrHasSuperclass(component2, "android.support.constraint.Barrier");
    }

    public static boolean isVerticalLine(@NotNull NlComponent component2) {
        String dir;
        String orientation;
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(component2);
        if (viewInfo == null) {
            return false;
        }
        if (NlComponentHelperKt.isOrHasSuperclass(component2, "android.support.constraint.Guideline") && (orientation = component2.getAttribute("http://schemas.android.com/apk/res/android", "orientation")) != null && orientation.equalsIgnoreCase("vertical")) {
            return true;
        }
        return NlComponentHelperKt.isOrHasSuperclass(component2, "android.support.constraint.Barrier") && (dir = component2.getAttribute("http://schemas.android.com/apk/res-auto", "barrierDirection")) != null && (dir.equalsIgnoreCase("left") || dir.equalsIgnoreCase("right") || dir.equalsIgnoreCase("start") || dir.equalsIgnoreCase("end"));
    }

    public static boolean isHorizontalLine(@NotNull NlComponent component2) {
        String dir;
        String orientation;
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(component2);
        if (viewInfo == null) {
            return false;
        }
        if (NlComponentHelperKt.isOrHasSuperclass(component2, "android.support.constraint.Guideline") && (orientation = component2.getAttribute("http://schemas.android.com/apk/res/android", "orientation")) != null && orientation.equalsIgnoreCase("horizontal")) {
            return true;
        }
        return NlComponentHelperKt.isOrHasSuperclass(component2, "android.support.constraint.Barrier") && (dir = component2.getAttribute("http://schemas.android.com/apk/res-auto", "barrierDirection")) != null && (dir.equalsIgnoreCase("top") || dir.equalsIgnoreCase("bottom"));
    }

    public static boolean isHorizontalGuideline(@NotNull NlComponent component2) {
        String orientation;
        return NlComponentHelperKt.getViewInfo(component2) != null && NlComponentHelperKt.isOrHasSuperclass(component2, "android.support.constraint.Guideline") && (orientation = component2.getAttribute("http://schemas.android.com/apk/res/android", "orientation")) != null && orientation.equalsIgnoreCase("horizontal");
    }

    public static boolean isVerticalGuideline(@NotNull NlComponent component2) {
        String orientation;
        return NlComponentHelperKt.getViewInfo(component2) != null && NlComponentHelperKt.isOrHasSuperclass(component2, "android.support.constraint.Guideline") && (orientation = component2.getAttribute("http://schemas.android.com/apk/res/android", "orientation")) != null && orientation.equalsIgnoreCase("vertical");
    }

    public static boolean isHeightConstrained(@NotNull NlComponent component2) {
        String tb = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toBottomOf");
        String tt = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toTopOf");
        if (tt == null && tb == null) {
            return false;
        }
        String bb = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toBottomOf");
        String bt = component2.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toTopOf");
        return !(tt == null && tb == null || bt == null && bb == null);
    }

    public static boolean isWidthConstrained(@NotNull NlComponent component2) {
        String se = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintStart_toEndOf");
        String ss = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintStart_toStartOf");
        String ee = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintEnd_toEndOf");
        String es = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintEnd_toStartOf");
        if (ee != null || es != null || se != null || ss != null) {
            return !(ee == null && es == null || se == null && ss == null);
        }
        String ll = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toLeftOf");
        String lr = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toRightOf");
        String rr = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toRightOf");
        String rl = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toLeftOf");
        return !(ll == null && lr == null || rl == null && rr == null);
    }

    public static boolean isHorizontalResizable(@NotNull NlComponent component2) {
        String dimension = component2.getAttribute("http://schemas.android.com/apk/res/android", "layout_width");
        if (dimension == null) {
            return false;
        }
        return dimension.equalsIgnoreCase("0dp");
    }

    public static boolean isVerticalResizable(@NotNull NlComponent component2) {
        String dimension = component2.getAttribute("http://schemas.android.com/apk/res/android", "layout_height");
        if (dimension == null) {
            return false;
        }
        return dimension.equalsIgnoreCase("0dp");
    }

    public static boolean hasUserResizedHorizontally(@NotNull NlComponent component2) {
        String dimension = component2.getAttribute("http://schemas.android.com/apk/res/android", "layout_width");
        return !dimension.equalsIgnoreCase("wrap_content");
    }

    public static boolean hasUserResizedVertically(@NotNull NlComponent component2) {
        String dimension = component2.getAttribute("http://schemas.android.com/apk/res/android", "layout_height");
        return !dimension.equalsIgnoreCase("wrap_content");
    }

    public static int getMargin(@NotNull NlComponent component2, String margin_attr) {
        boolean margin = false;
        String marginString = component2.getLiveAttribute("http://schemas.android.com/apk/res/android", margin_attr);
        if (marginString == null) {
            marginString = "layout_marginLeft".equalsIgnoreCase(margin_attr) ? component2.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart") : component2.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd");
        }
        if (marginString == null || marginString.startsWith("@")) {
            // empty if block
        }
        float dpiFactor = (float)component2.getModel().getConfiguration().getDensity().getDpiValue() / 160.0f;
        return (int)(0.5f + (float)margin / dpiFactor);
    }

    public static void setScoutAbsoluteDpX(@NotNull NlComponent component2, int dp, boolean apply) {
        ConstraintComponentUtilities.setScoutAttributeValue(component2, "http://schemas.android.com/tools", "layout_editor_absoluteX", dp, apply);
    }

    public static void setScoutAbsoluteDpY(@NotNull NlComponent component2, int dp, boolean apply) {
        ConstraintComponentUtilities.setScoutAttributeValue(component2, "http://schemas.android.com/tools", "layout_editor_absoluteY", dp, apply);
    }

    public static void setScoutAbsoluteDpWidth(@NotNull NlComponent component2, int dp, boolean apply) {
        ConstraintComponentUtilities.setScoutAttributeValue(component2, "http://schemas.android.com/apk/res/android", "layout_width", dp, apply);
    }

    public static void setScoutAbsoluteDpHeight(@NotNull NlComponent component2, int dp, boolean apply) {
        ConstraintComponentUtilities.setScoutAttributeValue(component2, "http://schemas.android.com/apk/res/android", "layout_height", dp, apply);
    }

    public static void setScoutVerticalBiasPercent(@NotNull NlComponent component2, float value) {
        AttributesTransaction transaction = component2.startAttributeTransaction();
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", Float.toString(value));
        transaction.apply();
    }

    public static void setScoutHorizontalBiasPercent(@NotNull NlComponent component2, float value) {
        AttributesTransaction transaction = component2.startAttributeTransaction();
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", Float.toString(value));
        transaction.apply();
    }

    public static void setScoutAttributeValue(@NotNull NlComponent component2, @NotNull String uri, @NotNull String attribute, int dp, boolean apply) {
        if (dp <= 0) {
            return;
        }
        String position = String.format("%ddp", dp);
        AttributesTransaction transaction = component2.startAttributeTransaction();
        transaction.setAttribute(uri, attribute, position);
        if (apply) {
            transaction.apply();
        }
    }

    public static void scoutClearAttributes(@NotNull NlComponent component2, ArrayList<String> attributes) {
        AttributesTransaction transaction = component2.startAttributeTransaction();
        ConstraintComponentUtilities.clearConnections(component2, attributes, transaction);
        transaction.apply();
    }

    public static void setScoutAttributeValue(@NotNull NlComponent component2, @NotNull String uri, @NotNull String attribute, @NotNull String value) {
        AttributesTransaction transaction = component2.startAttributeTransaction();
        transaction.setAttribute(uri, attribute, value);
        transaction.apply();
    }

    public static boolean isConstraintLayout(@NotNull NlComponent component2) {
        return NlComponentHelperKt.isOrHasSuperclass(component2, "android.support.constraint.ConstraintLayout") || component2.getTag().getName().equals("android.support.constraint.ConstraintLayout");
    }

    public static void scoutConnect(NlComponent source, Direction sourceDirection, NlComponent target, Direction targetDirection, int margin) {
        int srcIndex = sourceDirection.ordinal();
        String attrib = ATTRIB_MATRIX[srcIndex][targetDirection.ordinal()];
        if (attrib == null) {
            throw new RuntimeException("cannot connect " + (Object)((Object)sourceDirection) + " to " + (Object)((Object)targetDirection));
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < ATTRIB_CLEAR[srcIndex].length; ++i) {
            String clr_attr = ATTRIB_CLEAR[srcIndex][i];
            if (attrib.equals(clr_attr)) continue;
            list.add(clr_attr);
        }
        AttributesTransaction transaction = source.startAttributeTransaction();
        ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", list, transaction);
        String targetId = null;
        targetId = target == source.getParent() ? "parent" : "@+id/" + NlComponentHelperKt.ensureLiveId(target);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", attrib, targetId);
        if (srcIndex <= Direction.BASELINE.ordinal() && margin > 0) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", ATTRIB_MARGIN[srcIndex], margin + "dp");
        }
        transaction.apply();
        String str = null;
        switch (sourceDirection) {
            case BASELINE: {
                str = "baseline";
                break;
            }
            case BOTTOM: {
                str = "bottom";
                break;
            }
            case LEFT: {
                str = "left";
                break;
            }
            case RIGHT: {
                str = "right";
                break;
            }
            case TOP: {
                str = "north";
            }
        }
        if (str != null) {
            DecoratorUtilities.setTimeChange(source, str, DecoratorUtilities.ViewStates.INFERRED, DecoratorUtilities.ViewStates.SELECTED);
        }
    }

    public static void scoutChainConnect(NlComponent source, Direction sourceDirection, NlComponent target, Direction targetDirection, ArrayList<String[]> attrList) {
        int srcIndex = sourceDirection.ordinal();
        String attrib = ATTRIB_MATRIX[srcIndex][targetDirection.ordinal()];
        if (attrib == null) {
            throw new RuntimeException("cannot connect " + (Object)((Object)sourceDirection) + " to " + (Object)((Object)targetDirection));
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < ATTRIB_CLEAR[srcIndex].length; ++i) {
            String clr_attr = ATTRIB_CLEAR[srcIndex][i];
            if (attrib.equals(clr_attr)) continue;
            list.add(clr_attr);
        }
        AttributesTransaction transaction = source.startAttributeTransaction();
        ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", list, transaction);
        String targetId = null;
        targetId = target == source.getParent() ? "parent" : "@+id/" + NlComponentHelperKt.ensureLiveId(target);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", attrib, targetId);
        for (int i = 0; i < attrList.size(); ++i) {
            String[] bundle = attrList.get(i);
            transaction.setAttribute(bundle[0], bundle[1], bundle[2]);
        }
        transaction.apply();
        String str = null;
        switch (sourceDirection) {
            case BASELINE: {
                str = "baseline";
                break;
            }
            case BOTTOM: {
                str = "bottom";
                break;
            }
            case LEFT: {
                str = "left";
                break;
            }
            case RIGHT: {
                str = "right";
                break;
            }
            case TOP: {
                str = "north";
            }
        }
        DecoratorUtilities.setTimeChange(source, str, DecoratorUtilities.ViewStates.INFERRED, DecoratorUtilities.ViewStates.SELECTED);
    }

    public static boolean wouldCreateLoop(NlComponent source, Direction sourceDirection, NlComponent target) {
        if (source.getParent() == null) {
            return true;
        }
        List<NlComponent> sisters = source.getParent().getChildren();
        switch (sourceDirection) {
            case BOTTOM: 
            case TOP: {
                HashSet<String> connected = ConstraintComponentUtilities.getConnected(source, sisters, ourBottomAttributes, ourTopAttributes, ourBaselineAttributes);
                return connected.contains(target.getId());
            }
            case LEFT: 
            case RIGHT: {
                HashSet<String> connected = ConstraintComponentUtilities.getConnected(source, sisters, ourRightAttributes, ourLeftAttributes, ourStartAttributes, ourEndAttributes);
                return connected.contains(target.getId());
            }
            case BASELINE: {
                HashSet<String> connected = ConstraintComponentUtilities.getConnected(source, sisters, ourBottomAttributes, ourTopAttributes, ourBaselineAttributes);
                return connected.contains(target.getId());
            }
        }
        return false;
    }

    static HashSet<String> getConnected(NlComponent c, List<NlComponent> sisters, ArrayList<String> ... list) {
        int lastCount;
        HashSet<String> set = new HashSet<String>();
        set.add(c.getId());
        do {
            lastCount = set.size();
            for (NlComponent sister : sisters) {
                for (int i = 0; i < list.length; ++i) {
                    String str = ConstraintComponentUtilities.getConnectionId(sister, "http://schemas.android.com/apk/res-auto", list[i]);
                    if (!set.contains(str)) continue;
                    set.add(sister.getId());
                }
            }
        } while (set.size() > lastCount);
        return set;
    }

    static {
        ourLayoutUriToPrefix = new HashMap();
        ourLayoutUriToPrefix.put("http://schemas.android.com/apk/res/android", "android:");
        ourLayoutUriToPrefix.put("http://schemas.android.com/apk/res-auto", "app:");
        ourLayoutAttributes = new ArrayList();
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_width"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_height"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_marginStart"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_marginEnd"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_marginLeft"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_marginRight"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_marginTop"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_marginBottom"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintEnd_toStartOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintEnd_toEndOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintStart_toStartOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintStart_toEndOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintLeft_toLeftOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintLeft_toRightOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintRight_toLeftOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintRight_toRightOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintTop_toTopOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintTop_toBottomOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintBottom_toTopOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintBottom_toBottomOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintHorizontal_bias"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintVertical_bias"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintHorizontal_chainStyle"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintVertical_chainStyle"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintHorizontal_weight"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintVertical_weight"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintDimensionRatio"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"horizontal"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"vertical"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_goneMarginStart"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_goneMarginEnd"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_goneMarginLeft"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_goneMarginRight"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_goneMarginTop"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_goneMarginBottom"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintWidth_default"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintHeight_default"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_minWidth"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_minHeight"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_maxWidth"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_maxHeight"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_minWidth"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_editor_absoluteX"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_editor_absoluteY"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintGuide_begin"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintGuide_end"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintGuide_percent"));
        ourConstraintAttributes = new HashMap();
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.LEFT), (Object)((Object)AnchorTarget.Type.LEFT)), "layout_constraintLeft_toLeftOf");
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.LEFT), (Object)((Object)AnchorTarget.Type.RIGHT)), "layout_constraintLeft_toRightOf");
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.RIGHT), (Object)((Object)AnchorTarget.Type.LEFT)), "layout_constraintRight_toLeftOf");
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.RIGHT), (Object)((Object)AnchorTarget.Type.RIGHT)), "layout_constraintRight_toRightOf");
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.TOP), (Object)((Object)AnchorTarget.Type.TOP)), "layout_constraintTop_toTopOf");
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.TOP), (Object)((Object)AnchorTarget.Type.BOTTOM)), "layout_constraintTop_toBottomOf");
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.BOTTOM), (Object)((Object)AnchorTarget.Type.TOP)), "layout_constraintBottom_toTopOf");
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.BOTTOM), (Object)((Object)AnchorTarget.Type.BOTTOM)), "layout_constraintBottom_toBottomOf");
        ourLTRConvertedAttributes = new HashMap();
        ourLTRConstraintAnchorsToMargin = new HashMap();
        ourLTRMapSideToTargetAnchors = new HashMap();
        ourLTRConvertedAttributes.put("layout_constraintLeft_toLeftOf", "layout_constraintStart_toStartOf");
        ourLTRConvertedAttributes.put("layout_constraintLeft_toRightOf", "layout_constraintStart_toEndOf");
        ourLTRConvertedAttributes.put("layout_constraintRight_toLeftOf", "layout_constraintEnd_toStartOf");
        ourLTRConvertedAttributes.put("layout_constraintRight_toRightOf", "layout_constraintEnd_toEndOf");
        ourLTRConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.LEFT), (Object)((Object)AnchorTarget.Type.LEFT)), "layout_marginStart");
        ourLTRConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.LEFT), (Object)((Object)AnchorTarget.Type.RIGHT)), "layout_marginStart");
        ourLTRConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.RIGHT), (Object)((Object)AnchorTarget.Type.LEFT)), "layout_marginEnd");
        ourLTRConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.RIGHT), (Object)((Object)AnchorTarget.Type.RIGHT)), "layout_marginEnd");
        ourLTRMapSideToTargetAnchors.put("layout_constraintLeft_toLeftOf", AnchorTarget.Type.LEFT);
        ourLTRMapSideToTargetAnchors.put("layout_constraintLeft_toRightOf", AnchorTarget.Type.RIGHT);
        ourLTRMapSideToTargetAnchors.put("layout_constraintRight_toLeftOf", AnchorTarget.Type.LEFT);
        ourLTRMapSideToTargetAnchors.put("layout_constraintRight_toRightOf", AnchorTarget.Type.RIGHT);
        ourLTRMapSideToTargetAnchors.put("layout_constraintTop_toTopOf", AnchorTarget.Type.TOP);
        ourLTRMapSideToTargetAnchors.put("layout_constraintTop_toBottomOf", AnchorTarget.Type.BOTTOM);
        ourLTRMapSideToTargetAnchors.put("layout_constraintBottom_toTopOf", AnchorTarget.Type.TOP);
        ourLTRMapSideToTargetAnchors.put("layout_constraintBottom_toBottomOf", AnchorTarget.Type.BOTTOM);
        ourLTRMapSideToTargetAnchors.put("layout_constraintBaseline_toBaselineOf", AnchorTarget.Type.BASELINE);
        ourLTRMapSideToTargetAnchors.put("layout_constraintStart_toStartOf", AnchorTarget.Type.LEFT);
        ourLTRMapSideToTargetAnchors.put("layout_constraintStart_toEndOf", AnchorTarget.Type.LEFT);
        ourLTRMapSideToTargetAnchors.put("layout_constraintEnd_toStartOf", AnchorTarget.Type.RIGHT);
        ourLTRMapSideToTargetAnchors.put("layout_constraintEnd_toEndOf", AnchorTarget.Type.RIGHT);
        ourRTLConvertedAttributes = new HashMap();
        ourRTLConstraintAnchorsToMargin = new HashMap();
        ourRTLMapSideToTargetAnchors = new HashMap();
        ourRTLConvertedAttributes.put("layout_constraintLeft_toLeftOf", "layout_constraintEnd_toEndOf");
        ourRTLConvertedAttributes.put("layout_constraintLeft_toRightOf", "layout_constraintEnd_toStartOf");
        ourRTLConvertedAttributes.put("layout_constraintRight_toLeftOf", "layout_constraintStart_toEndOf");
        ourRTLConvertedAttributes.put("layout_constraintRight_toRightOf", "layout_constraintStart_toStartOf");
        ourRTLConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.LEFT), (Object)((Object)AnchorTarget.Type.LEFT)), "layout_marginEnd");
        ourRTLConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.LEFT), (Object)((Object)AnchorTarget.Type.RIGHT)), "layout_marginEnd");
        ourRTLConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.RIGHT), (Object)((Object)AnchorTarget.Type.LEFT)), "layout_marginStart");
        ourRTLConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.RIGHT), (Object)((Object)AnchorTarget.Type.RIGHT)), "layout_marginStart");
        ourRTLMapSideToTargetAnchors.put("layout_constraintLeft_toLeftOf", AnchorTarget.Type.LEFT);
        ourRTLMapSideToTargetAnchors.put("layout_constraintLeft_toRightOf", AnchorTarget.Type.RIGHT);
        ourRTLMapSideToTargetAnchors.put("layout_constraintRight_toLeftOf", AnchorTarget.Type.LEFT);
        ourRTLMapSideToTargetAnchors.put("layout_constraintRight_toRightOf", AnchorTarget.Type.RIGHT);
        ourRTLMapSideToTargetAnchors.put("layout_constraintTop_toTopOf", AnchorTarget.Type.TOP);
        ourRTLMapSideToTargetAnchors.put("layout_constraintTop_toBottomOf", AnchorTarget.Type.BOTTOM);
        ourRTLMapSideToTargetAnchors.put("layout_constraintBottom_toTopOf", AnchorTarget.Type.TOP);
        ourRTLMapSideToTargetAnchors.put("layout_constraintBottom_toBottomOf", AnchorTarget.Type.BOTTOM);
        ourRTLMapSideToTargetAnchors.put("layout_constraintBaseline_toBaselineOf", AnchorTarget.Type.BASELINE);
        ourRTLMapSideToTargetAnchors.put("layout_constraintStart_toStartOf", AnchorTarget.Type.RIGHT);
        ourRTLMapSideToTargetAnchors.put("layout_constraintStart_toEndOf", AnchorTarget.Type.RIGHT);
        ourRTLMapSideToTargetAnchors.put("layout_constraintEnd_toStartOf", AnchorTarget.Type.LEFT);
        ourRTLMapSideToTargetAnchors.put("layout_constraintEnd_toEndOf", AnchorTarget.Type.LEFT);
        ourPotentialAttributes = new HashMap();
        ourPotentialAttributes.put(AnchorTarget.Type.LEFT, (Pair<String, String>)Pair.of((Object)"layout_constraintLeft_toLeftOf", (Object)"layout_constraintLeft_toRightOf"));
        ourPotentialAttributes.put(AnchorTarget.Type.RIGHT, (Pair<String, String>)Pair.of((Object)"layout_constraintRight_toLeftOf", (Object)"layout_constraintRight_toRightOf"));
        ourPotentialAttributes.put(AnchorTarget.Type.TOP, (Pair<String, String>)Pair.of((Object)"layout_constraintTop_toTopOf", (Object)"layout_constraintTop_toBottomOf"));
        ourPotentialAttributes.put(AnchorTarget.Type.BOTTOM, (Pair<String, String>)Pair.of((Object)"layout_constraintBottom_toTopOf", (Object)"layout_constraintBottom_toBottomOf"));
        ourPotentialLTRAttributes = new HashMap();
        ourPotentialLTRAttributes.put(AnchorTarget.Type.LEFT, (Pair<String, String>)Pair.of((Object)"layout_constraintStart_toStartOf", (Object)"layout_constraintStart_toEndOf"));
        ourPotentialLTRAttributes.put(AnchorTarget.Type.RIGHT, (Pair<String, String>)Pair.of((Object)"layout_constraintEnd_toStartOf", (Object)"layout_constraintEnd_toEndOf"));
        ourPotentialRTLAttributes = new HashMap();
        ourPotentialRTLAttributes.put(AnchorTarget.Type.LEFT, (Pair<String, String>)Pair.of((Object)"layout_constraintEnd_toEndOf", (Object)"layout_constraintEnd_toStartOf"));
        ourPotentialRTLAttributes.put(AnchorTarget.Type.RIGHT, (Pair<String, String>)Pair.of((Object)"layout_constraintStart_toEndOf", (Object)"layout_constraintStart_toStartOf"));
        ourConstraintLayoutAttributesToClear = new String[]{"layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf", "layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf", "layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf", "layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf", "layout_constraintBaseline_toBaselineOf", "layout_constraintStart_toEndOf", "layout_constraintStart_toStartOf", "layout_constraintEnd_toStartOf", "layout_constraintEnd_toEndOf", "layout_goneMarginLeft", "layout_goneMarginTop", "layout_goneMarginRight", "layout_goneMarginBottom", "layout_goneMarginStart", "layout_goneMarginEnd", "layout_constraintHorizontal_bias", "layout_constraintVertical_bias", "layout_constraintWidth_default", "layout_constraintHeight_default", "layout_constraintWidth_min", "layout_constraintWidth_max", "layout_constraintHeight_min", "layout_constraintHeight_max", "layout_constraintLeft_creator", "layout_constraintTop_creator", "layout_constraintRight_creator", "layout_constraintBottom_creator", "layout_constraintBaseline_creator", "layout_constraintDimensionRatio", "layout_constraintHorizontal_weight", "layout_constraintVertical_weight", "layout_constraintHorizontal_chainStyle", "layout_constraintVertical_chainStyle"};
        ourLayoutAttributesToClear = new String[]{"layout_margin", "layout_marginLeft", "layout_marginStart", "layout_marginRight", "layout_marginEnd", "layout_marginTop", "layout_marginBottom", "layout_marginStart"};
        ourReciprocalAttributes = new HashMap();
        ourReciprocalAttributes.put("layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf");
        ourReciprocalAttributes.put("layout_constraintLeft_toRightOf", "layout_constraintLeft_toLeftOf");
        ourReciprocalAttributes.put("layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf");
        ourReciprocalAttributes.put("layout_constraintRight_toRightOf", "layout_constraintRight_toLeftOf");
        ourReciprocalAttributes.put("layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf");
        ourReciprocalAttributes.put("layout_constraintTop_toBottomOf", "layout_constraintTop_toTopOf");
        ourReciprocalAttributes.put("layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf");
        ourReciprocalAttributes.put("layout_constraintBottom_toBottomOf", "layout_constraintBottom_toTopOf");
        ourReciprocalAttributes.put("layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf");
        ourReciprocalAttributes.put("layout_constraintStart_toEndOf", "layout_constraintStart_toStartOf");
        ourReciprocalAttributes.put("layout_constraintEnd_toStartOf", "layout_constraintEnd_toEndOf");
        ourReciprocalAttributes.put("layout_constraintEnd_toEndOf", "layout_constraintEnd_toStartOf");
        ourMapMarginAttributes = new HashMap();
        ourMapMarginAttributes.put("layout_constraintLeft_toLeftOf", "layout_marginLeft");
        ourMapMarginAttributes.put("layout_constraintLeft_toRightOf", "layout_marginLeft");
        ourMapMarginAttributes.put("layout_constraintRight_toLeftOf", "layout_marginRight");
        ourMapMarginAttributes.put("layout_constraintRight_toRightOf", "layout_marginRight");
        ourMapMarginAttributes.put("layout_constraintTop_toTopOf", "layout_marginTop");
        ourMapMarginAttributes.put("layout_constraintTop_toBottomOf", "layout_marginTop");
        ourMapMarginAttributes.put("layout_constraintBottom_toTopOf", "layout_marginBottom");
        ourMapMarginAttributes.put("layout_constraintBottom_toBottomOf", "layout_marginBottom");
        ourMapMarginAttributes.put("layout_constraintStart_toStartOf", "layout_marginStart");
        ourMapMarginAttributes.put("layout_constraintStart_toEndOf", "layout_marginStart");
        ourMapMarginAttributes.put("layout_constraintEnd_toStartOf", "layout_marginEnd");
        ourMapMarginAttributes.put("layout_constraintEnd_toEndOf", "layout_marginEnd");
        ourMapSideToOriginAnchors = new HashMap();
        ourMapSideToOriginAnchors.put("layout_constraintLeft_toLeftOf", AnchorTarget.Type.LEFT);
        ourMapSideToOriginAnchors.put("layout_constraintLeft_toRightOf", AnchorTarget.Type.LEFT);
        ourMapSideToOriginAnchors.put("layout_constraintRight_toLeftOf", AnchorTarget.Type.RIGHT);
        ourMapSideToOriginAnchors.put("layout_constraintRight_toRightOf", AnchorTarget.Type.RIGHT);
        ourMapSideToOriginAnchors.put("layout_constraintTop_toTopOf", AnchorTarget.Type.TOP);
        ourMapSideToOriginAnchors.put("layout_constraintTop_toBottomOf", AnchorTarget.Type.TOP);
        ourMapSideToOriginAnchors.put("layout_constraintBottom_toTopOf", AnchorTarget.Type.BOTTOM);
        ourMapSideToOriginAnchors.put("layout_constraintBottom_toBottomOf", AnchorTarget.Type.BOTTOM);
        ourMapSideToOriginAnchors.put("layout_constraintBaseline_toBaselineOf", AnchorTarget.Type.BASELINE);
        ourLeftAttributes = new ArrayList();
        ourLeftAttributes.add("layout_constraintLeft_toLeftOf");
        ourLeftAttributes.add("layout_constraintLeft_toRightOf");
        ourTopAttributes = new ArrayList();
        ourTopAttributes.add("layout_constraintTop_toTopOf");
        ourTopAttributes.add("layout_constraintTop_toBottomOf");
        ourRightAttributes = new ArrayList();
        ourRightAttributes.add("layout_constraintRight_toLeftOf");
        ourRightAttributes.add("layout_constraintRight_toRightOf");
        ourBottomAttributes = new ArrayList();
        ourBottomAttributes.add("layout_constraintBottom_toTopOf");
        ourBottomAttributes.add("layout_constraintBottom_toBottomOf");
        ourBaselineAttributes = new ArrayList();
        ourBaselineAttributes.add("layout_constraintBaseline_toBaselineOf");
        ourStartAttributes = new ArrayList();
        ourStartAttributes.add("layout_constraintStart_toStartOf");
        ourStartAttributes.add("layout_constraintStart_toEndOf");
        ourEndAttributes = new ArrayList();
        ourEndAttributes.add("layout_constraintEnd_toStartOf");
        ourEndAttributes.add("layout_constraintEnd_toEndOf");
        ourHorizontalAttributes = new ArrayList();
        ourHorizontalAttributes.add("layout_constraintLeft_toLeftOf");
        ourHorizontalAttributes.add("layout_constraintLeft_toRightOf");
        ourHorizontalAttributes.add("layout_constraintRight_toLeftOf");
        ourHorizontalAttributes.add("layout_constraintRight_toRightOf");
        ourHorizontalAttributes.add("layout_constraintStart_toStartOf");
        ourHorizontalAttributes.add("layout_constraintStart_toEndOf");
        ourHorizontalAttributes.add("layout_constraintEnd_toStartOf");
        ourHorizontalAttributes.add("layout_constraintEnd_toEndOf");
        ourVerticalAttributes = new ArrayList();
        ourVerticalAttributes.add("layout_constraintTop_toTopOf");
        ourVerticalAttributes.add("layout_constraintTop_toBottomOf");
        ourVerticalAttributes.add("layout_constraintBottom_toTopOf");
        ourVerticalAttributes.add("layout_constraintBottom_toBottomOf");
        ourVerticalAttributes.add("layout_constraintBaseline_toBaselineOf");
        ATTRIB_MATRIX = new String[][]{{"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf", null, null, null}, {"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf", null, null, null}, {null, null, "layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", null}, {null, null, "layout_constraintEnd_toStartOf", "layout_constraintEnd_toEndOf", null}, {null, null, null, null, "layout_constraintBaseline_toBaselineOf"}};
        ATTRIB_CLEAR = new String[][]{{"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf", "layout_constraintBaseline_toBaselineOf"}, {"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf", "layout_constraintBaseline_toBaselineOf"}, {"layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf"}, {"layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf", "layout_toStartOf"}, {"layout_constraintBaseline_toBaselineOf"}};
        ATTRIB_MARGIN = new String[]{"layout_marginTop", "layout_marginBottom", "layout_marginStart", "layout_marginEnd"};
    }
}

