/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.structure.DelegatedTreeEvent;
import com.android.tools.idea.uibuilder.structure.DelegatedTreeEventHandler;
import com.android.tools.idea.uibuilder.structure.NlDropListener;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstraintHelperHandler
extends ViewGroupHandler
implements DelegatedTreeEventHandler {
    public static final boolean USE_HELPER_TAGS = false;

    @Override
    public void performDrop(@NotNull NlModel model, @NotNull DropTargetDropEvent event, @NotNull NlComponent receiver, @NotNull List<NlComponent> dragged, @Nullable NlComponent before, @NotNull InsertType insertType) {
        if (NlComponentHelperKt.isOrHasSuperclass(receiver, "android.support.constraint.ConstraintHelper")) {
            try {
                ConstraintHelperHandler.addComponentsIds(receiver, dragged);
                event.acceptDrop(insertType == InsertType.COPY ? event.getDropAction() : 1);
                event.dropComplete(true);
                model.notifyModified(NlModel.ChangeType.DROP);
            }
            catch (Exception exception) {
                Logger.getInstance(NlDropListener.class).warn((Throwable)exception);
                event.rejectDrop();
            }
        }
    }

    private static void addComponentsIds(@NotNull NlComponent receiver, @NotNull List<NlComponent> dragged) {
        ArrayList<String> draggedIds = new ArrayList<String>();
        for (NlComponent component2 : dragged) {
            draggedIds.add(NlComponentHelperKt.ensureLiveId(component2));
        }
        ConstraintHelperHandler.addReferencesIds(receiver, draggedIds, null);
    }

    private static void addReferencesIds(@NotNull NlComponent receiver, @NotNull List<String> draggedIds, @Nullable String before) {
        AttributesTransaction transaction = receiver.startAttributeTransaction();
        String originalIdsList = transaction.getAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids");
        String idList = ConstraintHelperHandler.addIds(originalIdsList, draggedIds, before);
        ConstraintHelperHandler.writeIds(receiver, transaction, idList);
    }

    @Nullable
    private static String removeIds(@NotNull String originalIds, @NotNull List<String> toRemove) {
        String[] splitIds = originalIds.split(",");
        ArrayList strings = new ArrayList(splitIds.length);
        Collections.addAll(strings, splitIds);
        strings.removeAll(toRemove);
        return strings.isEmpty() ? null : String.join((CharSequence)",", strings);
    }

    @Nullable
    private static String addIds(@Nullable String ids, @NotNull List<String> newIds, @Nullable String before) {
        int insertionIndex;
        ArrayList<String> idsList;
        if (newIds.isEmpty()) {
            return ids;
        }
        if (ids != null) {
            String[] splitIds = ids.split(",");
            idsList = new ArrayList(splitIds.length);
            Collections.addAll(idsList, splitIds);
            idsList.removeAll(newIds);
        } else {
            idsList = new ArrayList<String>();
        }
        int n = insertionIndex = before == null ? -1 : idsList.indexOf(before);
        if (insertionIndex >= 0) {
            idsList.addAll(insertionIndex, newIds);
        } else {
            idsList.addAll(newIds);
        }
        return String.join((CharSequence)",", new LinkedHashSet(idsList));
    }

    public static void willDelete(@NotNull NlComponent parent, @NotNull String id) {
        for (NlComponent child : parent.getChildren()) {
            String ids;
            if (!NlComponentHelperKt.isOrHasSuperclass(child, "android.support.constraint.ConstraintHelper") || (ids = child.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids")) == null) continue;
            ids = ConstraintHelperHandler.removeIds(ids, Collections.singletonList(id));
            AttributesTransaction transaction = child.startAttributeTransaction();
            ConstraintHelperHandler.writeIds(child, transaction, ids);
        }
    }

    @Override
    public int getComponentTreeChildCount(@NotNull Object element) {
        String ids;
        NlComponent component2;
        if (element instanceof NlComponent && NlComponentHelperKt.isOrHasSuperclass(component2 = (NlComponent)element, "android.support.constraint.ConstraintHelper") && (ids = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids")) != null) {
            String[] list = ids.split(",");
            return list.length;
        }
        return 0;
    }

    @Override
    public Object getComponentTreeChild(@NotNull Object element, int i) {
        if (element instanceof NlComponent) {
            String ids;
            NlComponent component2 = (NlComponent)element;
            if (NlComponentHelperKt.isOrHasSuperclass(component2, "android.support.constraint.ConstraintHelper") && (ids = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids")) != null) {
                String[] list = ids.split(",");
                return list[i];
            }
            return component2.getChild(i);
        }
        return null;
    }

    public void deleteReference(@NotNull NlComponent component2, @NotNull String id) {
        String ids = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids");
        if (ids != null) {
            ids = ConstraintHelperHandler.removeIds(ids, Collections.singletonList(id));
            AttributesTransaction transaction = component2.startAttributeTransaction();
            ConstraintHelperHandler.writeIds(component2, transaction, ids);
        }
    }

    private static void writeIds(@NotNull NlComponent component2, @NotNull AttributesTransaction transaction, @Nullable String idList) {
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids", idList);
        NlWriteCommandAction.run(component2, "", transaction::commit);
    }

    @Override
    public boolean handleTreeEvent(@NotNull DelegatedTreeEvent event, @NotNull NlComponent constraintHelper) {
        if (event.getType() == DelegatedTreeEvent.Type.DELETE) {
            this.handleDeletion(event, constraintHelper);
        } else if (event.getType() == DelegatedTreeEvent.Type.DROP) {
            ConstraintHelperHandler.handleHelperIdDrop(event, constraintHelper);
        }
        return true;
    }

    private void handleDeletion(@NotNull DelegatedTreeEvent event, @NotNull NlComponent constraintHelper) {
        for (Object last : event.getSelected()) {
            if (!(last instanceof String)) continue;
            this.deleteReference(constraintHelper, (String)last);
        }
    }

    private static void handleHelperIdDrop(@NotNull DelegatedTreeEvent event, @NotNull NlComponent component2) {
        List<Object> selected = event.getSelected();
        List<String> ids = selected.stream().filter(o -> o instanceof String).map(o -> (String)o).collect(Collectors.toList());
        Object sibling = event.getNextSibling();
        String nextSibling = sibling instanceof String ? (String)sibling : null;
        ConstraintHelperHandler.addReferencesIds(component2, ids, nextSibling);
    }

    @Override
    public Transferable getTransferable(TreePath[] paths) {
        ArrayList<String> barriersList = new ArrayList<String>();
        for (int i = 0; i < paths.length; ++i) {
            Object component2 = paths[i].getLastPathComponent();
            if (!(component2 instanceof String)) continue;
            barriersList.add((String)component2);
        }
        if (barriersList.isEmpty()) {
            return null;
        }
        return new BarrierTransferable(barriersList);
    }

    private static class BarrierTransferable
    implements Transferable {
        public static final DataFlavor BARRIER_FLAVOR = new DataFlavor(BarrierTransferable.class, "Barrier Item");
        private final List<String> myBarrierReferences;

        public BarrierTransferable(List<String> barrierReferences) {
            this.myBarrierReferences = barrierReferences;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{BARRIER_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return BARRIER_FLAVOR.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (BARRIER_FLAVOR.equals(flavor)) {
                return this.myBarrierReferences;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

