/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.property.EmptyProperty;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlBaseComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.inspector.InspectorComponent;
import com.android.tools.idea.uibuilder.property.inspector.InspectorPanel;
import com.android.tools.idea.uibuilder.property.inspector.InspectorProvider;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J2\u0010\u000f\u001a\u00020\u00102\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/constraint/ConstraintSetInspectorProvider;", "Lcom/android/tools/idea/uibuilder/property/inspector/InspectorProvider;", "()V", "inspectorComponent", "Lcom/android/tools/idea/uibuilder/property/inspector/InspectorComponent;", "createCustomInspector", "components", "", "Lcom/android/tools/idea/common/model/NlComponent;", "properties", "", "", "Lcom/android/tools/idea/uibuilder/property/NlProperty;", "propertiesManager", "Lcom/android/tools/idea/uibuilder/property/NlPropertiesManager;", "isApplicable", "", "resetCache", "", "ConstraintLayoutInspectorComponent", "ConstraintSetEditor", "designer"})
public final class ConstraintSetInspectorProvider
implements InspectorProvider {
    private InspectorComponent inspectorComponent = new ConstraintLayoutInspectorComponent();

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        Intrinsics.checkParameterIsNotNull(components, (String)"components");
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        Intrinsics.checkParameterIsNotNull((Object)propertiesManager, (String)"propertiesManager");
        if (components.size() != 1) {
            return false;
        }
        NlComponent component2 = components.get(0);
        if (!NlComponentHelperKt.isOrHasSuperclass(component2, "android.support.constraint.ConstraintLayout")) {
            return false;
        }
        return component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraintSet") != null;
    }

    @Override
    @NotNull
    public InspectorComponent createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        Intrinsics.checkParameterIsNotNull(components, (String)"components");
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        Intrinsics.checkParameterIsNotNull((Object)propertiesManager, (String)"propertiesManager");
        this.inspectorComponent.updateProperties(components, properties, propertiesManager);
        return this.inspectorComponent;
    }

    @Override
    public void resetCache() {
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001bH\u0016J\u0012\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0012\u0010'\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0012\u0010(\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u001e\u0010)\u001a\u00020$2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\b\u0010+\u001a\u0004\u0018\u00010\nJ\u0010\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020\u001bH\u0016R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006."}, d2={"Lcom/android/tools/idea/uibuilder/handlers/constraint/ConstraintSetInspectorProvider$ConstraintSetEditor;", "Lcom/android/tools/idea/uibuilder/property/editors/NlBaseComponentEditor;", "Ljavax/swing/event/PopupMenuListener;", "listener", "Lcom/android/tools/idea/uibuilder/property/editors/NlEditingListener;", "inspector", "Lcom/android/tools/idea/uibuilder/handlers/constraint/ConstraintSetInspectorProvider$ConstraintLayoutInspectorComponent;", "(Lcom/android/tools/idea/uibuilder/property/editors/NlEditingListener;Lcom/android/tools/idea/uibuilder/handlers/constraint/ConstraintSetInspectorProvider$ConstraintLayoutInspectorComponent;)V", "myComboBox", "Ljavax/swing/JComboBox;", "", "getMyComboBox", "()Ljavax/swing/JComboBox;", "setMyComboBox", "(Ljavax/swing/JComboBox;)V", "myInspector", "myList", "Ljava/util/ArrayList;", "myPanel", "Ljavax/swing/JPanel;", "getMyPanel", "()Ljavax/swing/JPanel;", "setMyPanel", "(Ljavax/swing/JPanel;)V", "myPopupChanged", "", "myProperty", "Lcom/android/tools/idea/uibuilder/property/NlProperty;", "getMyProperty", "()Lcom/android/tools/idea/uibuilder/property/NlProperty;", "setMyProperty", "(Lcom/android/tools/idea/uibuilder/property/NlProperty;)V", "getComponent", "Ljavax/swing/JComponent;", "getProperty", "popupMenuCanceled", "", "e", "Ljavax/swing/event/PopupMenuEvent;", "popupMenuWillBecomeInvisible", "popupMenuWillBecomeVisible", "setList", "list", "current", "setProperty", "property", "designer"})
    private static final class ConstraintSetEditor
    extends NlBaseComponentEditor
    implements PopupMenuListener {
        @NotNull
        private JPanel myPanel;
        @NotNull
        private NlProperty myProperty;
        @NotNull
        private JComboBox<String> myComboBox;
        private ArrayList<String> myList;
        private ConstraintLayoutInspectorComponent myInspector;
        private boolean myPopupChanged;

        @NotNull
        public final JPanel getMyPanel() {
            return this.myPanel;
        }

        public final void setMyPanel(@NotNull JPanel jPanel) {
            Intrinsics.checkParameterIsNotNull((Object)jPanel, (String)"<set-?>");
            this.myPanel = jPanel;
        }

        @NotNull
        public final NlProperty getMyProperty() {
            return this.myProperty;
        }

        public final void setMyProperty(@NotNull NlProperty nlProperty) {
            Intrinsics.checkParameterIsNotNull((Object)nlProperty, (String)"<set-?>");
            this.myProperty = nlProperty;
        }

        @NotNull
        public final JComboBox<String> getMyComboBox() {
            return this.myComboBox;
        }

        public final void setMyComboBox(@NotNull JComboBox<String> jComboBox) {
            Intrinsics.checkParameterIsNotNull(jComboBox, (String)"<set-?>");
            this.myComboBox = jComboBox;
        }

        @Override
        public void popupMenuWillBecomeInvisible(@Nullable PopupMenuEvent e) {
            if (this.myPopupChanged) {
                this.myPopupChanged = false;
                Object object = this.myComboBox.getSelectedItem();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                String value = (String)object;
                this.stopEditing(value);
            }
        }

        @Override
        public void popupMenuCanceled(@Nullable PopupMenuEvent e) {
            this.myPopupChanged = false;
        }

        @Override
        public void popupMenuWillBecomeVisible(@Nullable PopupMenuEvent e) {
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            return this.myPanel;
        }

        @Override
        @NotNull
        public NlProperty getProperty() {
            return this.myProperty;
        }

        @Override
        public void setProperty(@NotNull NlProperty property) {
            Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
            this.myProperty = property;
        }

        public final void setList(@NotNull ArrayList<String> list, @Nullable String current) {
            Intrinsics.checkParameterIsNotNull(list, (String)"list");
            this.myList = list;
            this.myComboBox.removeAllItems();
            for (String element : this.myList) {
                this.myComboBox.addItem(element);
            }
            this.myComboBox.setSelectedItem(current);
        }

        public ConstraintSetEditor(@NotNull NlEditingListener listener, @NotNull ConstraintLayoutInspectorComponent inspector) {
            Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
            Intrinsics.checkParameterIsNotNull((Object)inspector, (String)"inspector");
            super(listener);
            this.myPanel = new JPanel(new BorderLayout());
            EmptyProperty emptyProperty = EmptyProperty.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)emptyProperty, (String)"EmptyProperty.INSTANCE");
            this.myProperty = emptyProperty;
            this.myComboBox = new JComboBox();
            this.myList = new ArrayList();
            this.myInspector = inspector;
            this.myPanel.add(this.myComboBox);
            this.myComboBox.addPopupMenuListener(this);
            this.myComboBox.addActionListener(new ActionListener(){

                @Override
                public final void actionPerformed(ActionEvent it) {
                    myPopupChanged = true;
                }
            });
        }

        public static final /* synthetic */ boolean access$getMyPopupChanged$p(ConstraintSetEditor $this) {
            return $this.myPopupChanged;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\nJ\b\u0010\u0013\u001a\u00020\nH\u0016J2\u0010\u0014\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00060\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/constraint/ConstraintSetInspectorProvider$ConstraintLayoutInspectorComponent;", "Lcom/android/tools/idea/uibuilder/property/inspector/InspectorComponent;", "()V", "myComponent", "Lcom/android/tools/idea/common/model/NlComponent;", "myConstraintSet", "Lcom/android/tools/idea/uibuilder/property/NlProperty;", "myConstraintSetEditor", "Lcom/android/tools/idea/uibuilder/handlers/constraint/ConstraintSetInspectorProvider$ConstraintSetEditor;", "attachToInspector", "", "inspector", "Lcom/android/tools/idea/uibuilder/property/inspector/InspectorPanel;", "getEditors", "", "Lcom/android/tools/idea/uibuilder/property/editors/NlComponentEditor;", "getMaxNumberOfRows", "", "populate", "refresh", "updateProperties", "components", "properties", "", "", "propertiesManager", "Lcom/android/tools/idea/uibuilder/property/NlPropertiesManager;", "designer"})
    private static final class ConstraintLayoutInspectorComponent
    implements InspectorComponent {
        private final ConstraintSetEditor myConstraintSetEditor;
        private NlProperty myConstraintSet;
        private NlComponent myComponent;

        @Override
        public void refresh() {
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            Intrinsics.checkParameterIsNotNull(components, (String)"components");
            Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
            Intrinsics.checkParameterIsNotNull((Object)propertiesManager, (String)"propertiesManager");
            this.myConstraintSet = properties.get("constraintSet");
            this.myComponent = components.get(0);
            NlProperty nlProperty = this.myConstraintSet;
            if (nlProperty == null) {
                Intrinsics.throwNpe();
            }
            this.myConstraintSetEditor.setProperty(nlProperty);
            this.populate();
        }

        @Override
        public int getMaxNumberOfRows() {
            return 2;
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            Intrinsics.checkParameterIsNotNull((Object)inspector, (String)"inspector");
            inspector.addTitle("ConstraintSet");
            this.refresh();
            NlProperty nlProperty = this.myConstraintSet;
            this.myConstraintSetEditor.setLabel(inspector.addComponent("constraintSet", nlProperty != null ? nlProperty.getTooltipText() : null, this.myConstraintSetEditor.getComponent()));
        }

        @Override
        @NotNull
        public List<NlComponentEditor> getEditors() {
            List<NlComponentEditor> list = Arrays.asList(this.myConstraintSetEditor);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"asList(myConstraintSetEditor)");
            return list;
        }

        public final void populate() {
            if (this.myComponent == null) {
                return;
            }
            ArrayList<String> list = new ArrayList<String>();
            NlComponent nlComponent = this.myComponent;
            if (nlComponent == null) {
                Intrinsics.throwNpe();
            }
            for (NlComponent child : nlComponent.getChildren()) {
                String attribute;
                if (!NlComponentHelperKt.isOrHasSuperclass(child, "android.support.constraint.Constraints") || (attribute = child.getLiveAttribute("http://schemas.android.com/apk/res/android", "id")) == null) continue;
                list.add(attribute);
            }
            NlComponent nlComponent2 = this.myComponent;
            if (nlComponent2 == null) {
                Intrinsics.throwNpe();
            }
            String constraintSet = nlComponent2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraintSet");
            this.myConstraintSetEditor.setList(list, constraintSet);
        }

        public ConstraintLayoutInspectorComponent() {
            NlEditingListener nlEditingListener = NlEditingListener.DEFAULT_LISTENER;
            Intrinsics.checkExpressionValueIsNotNull((Object)nlEditingListener, (String)"DEFAULT_LISTENER");
            this.myConstraintSetEditor = new ConstraintSetEditor(nlEditingListener, this);
        }
    }
}

