/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.resources.LayoutDirection;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class ConstraintUtilities {
    private static HashMap<String, Integer> alignmentMap_ltr = new HashMap();
    private static HashMap<String, Integer> alignmentMap_rtl = new HashMap();
    static String[] mode = new String[]{"0", "1", "2", "3", "center", "START", "END"};

    public static int getAlignment(String s, boolean rtl) {
        HashMap<String, Integer> alignmentMap;
        HashMap<String, Integer> hashMap = alignmentMap = rtl ? alignmentMap_rtl : alignmentMap_ltr;
        if (alignmentMap.containsKey(s)) {
            return alignmentMap.get(s);
        }
        return 5;
    }

    static int getMargin(@NotNull NlComponent component2, @NotNull String attr) {
        String margin = component2.getLiveAttribute("http://schemas.android.com/apk/res/android", attr);
        if (margin == null) {
            if (attr == "layout_marginStart") {
                margin = component2.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft");
            } else if (attr == "layout_marginEnd") {
                margin = component2.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight");
            }
        }
        if (margin != null) {
            return ConstraintUtilities.getDpValue(component2, margin);
        }
        return 0;
    }

    public static boolean isInRTL(@NotNull NlComponent component2) {
        Configuration configuration = component2.getModel().getConfiguration();
        if (configuration == null) {
            return false;
        }
        LayoutDirectionQualifier qualifier = configuration.getFullConfig().getLayoutDirectionQualifier();
        if (qualifier == null) {
            return false;
        }
        return qualifier.getValue() == LayoutDirection.RTL;
    }

    public static int getDpValue(@NotNull NlComponent component2, String value) {
        Configuration configuration;
        ResourceResolver resourceResolver;
        if (value != null && (resourceResolver = (configuration = component2.getModel().getConfiguration()).getResourceResolver()) != null) {
            Integer px = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver, value, configuration);
            return px == null ? 0 : (int)(0.5f + (float)px.intValue() / ((float)configuration.getDensity().getDpiValue() / 160.0f));
        }
        return 0;
    }

    @NotNull
    static String resolveStringResource(@NotNull NlComponent component2, @NotNull String text) {
        Configuration configuration = component2.getModel().getConfiguration();
        ResourceResolver resourceResolver = configuration.getResourceResolver();
        if (resourceResolver != null) {
            return ResourceHelper.resolveStringValue((RenderResources)resourceResolver, text);
        }
        return "";
    }

    @NotNull
    public static String getResolvedText(@NotNull NlComponent component2) {
        String text = component2.getAttribute("http://schemas.android.com/tools", "text");
        if (text != null) {
            if (text.startsWith("@")) {
                if (!text.startsWith("@sample/") && !text.startsWith("@tools:sample/")) {
                    return ConstraintUtilities.resolveStringResource(component2, text);
                }
                return "";
            }
            return text;
        }
        text = component2.getAttribute("http://schemas.android.com/apk/res/android", "text");
        if (text != null) {
            if (text.startsWith("@")) {
                return ConstraintUtilities.resolveStringResource(component2, text);
            }
            return text;
        }
        return "";
    }

    static {
        alignmentMap_rtl.put("center", 4);
        alignmentMap_rtl.put("textStart", 2);
        alignmentMap_rtl.put("textEnd", 3);
        alignmentMap_rtl.put("viewStart", 6);
        alignmentMap_rtl.put("viewEnd", 5);
        alignmentMap_ltr.put("center", 4);
        alignmentMap_ltr.put("textStart", 2);
        alignmentMap_ltr.put("textEnd", 3);
        alignmentMap_ltr.put("viewStart", 5);
        alignmentMap_ltr.put("viewEnd", 6);
    }
}

