/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.tools.sherpa.drawing.ColorSet;
import com.intellij.ui.JBColor;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import org.jetbrains.annotations.NotNull;

public class MarginWidget
extends JPanel {
    private String[] str = new String[]{"0", "8", "16", "24", "32"};
    private boolean mInternal;
    private JComboBox<String> combo = new JComboBox<String>(this.str);
    private static final String COMBO = "combo";
    private static final String TEXT = "text";
    private ColorSet mColorSet;
    private ArrayList<ActionListener> mCallbacks = new ArrayList();
    private JLabel label = new JLabel("0");
    private CardLayout layout;
    private BasicComboBoxUI ui = new BasicComboBoxUI(){

        @Override
        protected JButton createArrowButton() {
            Color background = MarginWidget.this.mColorSet.getInspectorBackgroundColor();
            Color shadow = MarginWidget.this.mColorSet.getInspectorStrokeColor();
            Color darkShadow = MarginWidget.this.mColorSet.getInspectorStrokeColor();
            Color highlight = MarginWidget.this.mColorSet.getSubduedFrames();
            BasicArrowButton button = new BasicArrowButton(5, background, shadow, darkShadow, highlight);
            button.setForeground((Color)JBColor.RED);
            button.setBorder(new MatteBorder(0, 1, 0, 0, MarginWidget.this.mColorSet.getInspectorStrokeColor()));
            return button;
        }
    };

    @Override
    public void setToolTipText(String text) {
        this.combo.setToolTipText(text);
    }

    public void showUI(Show show) {
        if (this.combo.getEditor().getEditorComponent().hasFocus()) {
            return;
        }
        switch (show) {
            case IN_WIDGET: {
                this.layout.show(this, COMBO);
                this.label.setText((String)this.combo.getSelectedItem());
                break;
            }
            case OUT_WIDGET: {
                if (this.combo.isPopupVisible()) break;
                this.layout.show(this, TEXT);
                break;
            }
            case OUT_PANEL: {
                this.layout.show(this, TEXT);
            }
        }
        this.label.setText((String)this.combo.getSelectedItem());
    }

    public MarginWidget(@NotNull ColorSet colorSet, int alignment, @NotNull String name) {
        super(new CardLayout());
        this.mColorSet = colorSet;
        this.layout = (CardLayout)this.getLayout();
        this.initLabel(alignment);
        this.initComboBox(name);
        this.setBackground(null);
        this.setName(name);
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(42, 23));
        this.add((Component)this.label, TEXT);
        this.add(this.combo, COMBO);
    }

    private void initLabel(int alignment) {
        this.label.setBackground(null);
        this.label.setForeground(this.mColorSet.getInspectorStrokeColor());
        this.label.setHorizontalAlignment(alignment);
        this.label.setOpaque(false);
    }

    private void initComboBox(@NotNull String name) {
        this.combo.setAlignmentX(0.0f);
        this.combo.setBorder(new LineBorder(this.mColorSet.getInspectorStrokeColor()));
        this.combo.setEditable(true);
        this.combo.setEditor(new BasicComboBoxEditor(){

            @Override
            @NotNull
            public Component getEditorComponent() {
                return super.getEditorComponent();
            }
        });
        this.combo.setName(name + "ComboBox");
        this.combo.setRenderer(new DefaultListCellRenderer(){

            @Override
            @NotNull
            public Component getListCellRendererComponent(@NotNull JList list, @NotNull Object value, int index, boolean selected, boolean focused) {
                Component component2 = super.getListCellRendererComponent((JList<?>)list, value, index, selected, focused);
                ((JComponent)component2).setBorder(new LineBorder(MarginWidget.this.mColorSet.getSubduedFrames(), 1));
                return component2;
            }
        });
        this.combo.setUI(this.ui);
        this.combo.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(@NotNull FocusEvent event) {
                MarginWidget.this.showUI(Show.OUT_PANEL);
            }
        });
        this.combo.addActionListener(event -> {
            if (this.mInternal) {
                return;
            }
            this.label.setText((String)this.combo.getSelectedItem());
            this.mCallbacks.forEach(listener -> listener.actionPerformed(event));
        });
    }

    public void setMargin(int margin) {
        this.mInternal = true;
        String marginText = String.valueOf(margin);
        this.combo.setSelectedItem(marginText);
        this.label.setText(marginText);
        this.mInternal = false;
    }

    public int getMargin() {
        try {
            return Integer.parseInt(this.label.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.mCallbacks.add(actionListener);
    }

    public static enum Show {
        IN_WIDGET,
        OUT_WIDGET,
        OUT_PANEL;

    }
}

