/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.draw;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.scene.target.Notch;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ConstraintLayoutNotchProvider
implements Notch.Provider {
    protected static final ArrayList<String> ourLeftAttributes = new ArrayList();
    protected static final ArrayList<String> ourTopAttributes;
    protected static final ArrayList<String> ourRightAttributes;
    protected static final ArrayList<String> ourBottomAttributes;

    private static boolean hasAttributes(@NotNull AttributesTransaction transaction, String uri, ArrayList<String> attributes) {
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            if (transaction.getAttribute(uri, attribute) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean hasLeft(@NotNull AttributesTransaction transaction) {
        return ConstraintLayoutNotchProvider.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourLeftAttributes);
    }

    private static boolean hasTop(@NotNull AttributesTransaction transaction) {
        return ConstraintLayoutNotchProvider.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourTopAttributes);
    }

    private static boolean hasRight(@NotNull AttributesTransaction transaction) {
        return ConstraintLayoutNotchProvider.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourRightAttributes);
    }

    private static boolean hasBottom(@NotNull AttributesTransaction transaction) {
        return ConstraintLayoutNotchProvider.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourBottomAttributes);
    }

    private static boolean hasBaseline(@NotNull AttributesTransaction transaction) {
        return transaction.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf") != null;
    }

    @Override
    public void fill(@NotNull SceneComponent owner, @NotNull SceneComponent snappableComponent, @NotNull ArrayList<Notch> horizontalNotches, @NotNull ArrayList<Notch> verticalNotches) {
        int x1 = owner.getDrawX();
        int x2 = x1 + owner.getDrawWidth();
        int midX = x1 + (x2 - x1) / 2 - snappableComponent.getDrawWidth() / 2;
        horizontalNotches.add(new Notch.Horizontal(owner, midX, x1 + (x2 - x1) / 2, attributes -> {
            if (ConstraintLayoutNotchProvider.hasLeft(attributes) || ConstraintLayoutNotchProvider.hasRight(attributes)) {
                return;
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toLeftOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toRightOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", null);
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", null);
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart", null);
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd", null);
        }));
        horizontalNotches.add(new Notch.Horizontal(owner, x1 + 16, x1 + 16, attributes -> {
            if (ConstraintLayoutNotchProvider.hasLeft(attributes) || ConstraintLayoutNotchProvider.hasRight(attributes)) {
                return;
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toLeftOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", String.format("%ddp", 16));
        }));
        horizontalNotches.add(new Notch.Horizontal(owner, x2 - snappableComponent.getDrawWidth() - 16, x2 - 16, attributes -> {
            if (ConstraintLayoutNotchProvider.hasLeft(attributes) || ConstraintLayoutNotchProvider.hasRight(attributes)) {
                return;
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toRightOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", String.format("%ddp", 16));
        }));
        int y1 = owner.getDrawY();
        int y2 = y1 + owner.getDrawHeight();
        int midY = y1 + (y2 - y1) / 2 - snappableComponent.getDrawHeight() / 2;
        verticalNotches.add(new Notch.Vertical(owner, midY, y1 + (y2 - y1) / 2, attributes -> {
            if (ConstraintLayoutNotchProvider.hasTop(attributes) || ConstraintLayoutNotchProvider.hasBottom(attributes) || ConstraintLayoutNotchProvider.hasBaseline(attributes)) {
                return;
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toTopOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toBottomOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", null);
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", null);
        }));
        verticalNotches.add(new Notch.Vertical(owner, y1 + 16, y1 + 16, attributes -> {
            if (ConstraintLayoutNotchProvider.hasTop(attributes) || ConstraintLayoutNotchProvider.hasBottom(attributes) || ConstraintLayoutNotchProvider.hasBaseline(attributes)) {
                return;
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toTopOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", String.format("%ddp", 16));
        }));
        verticalNotches.add(new Notch.Vertical(owner, y2 - snappableComponent.getDrawHeight() - 16, y2 - 16, attributes -> {
            if (ConstraintLayoutNotchProvider.hasTop(attributes) || ConstraintLayoutNotchProvider.hasBottom(attributes) || ConstraintLayoutNotchProvider.hasBaseline(attributes)) {
                return;
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toBottomOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", String.format("%ddp", 16));
        }));
    }

    static {
        ourLeftAttributes.add("layout_constraintLeft_toLeftOf");
        ourLeftAttributes.add("layout_constraintLeft_toRightOf");
        ourTopAttributes = new ArrayList();
        ourTopAttributes.add("layout_constraintTop_toTopOf");
        ourTopAttributes.add("layout_constraintTop_toBottomOf");
        ourRightAttributes = new ArrayList();
        ourRightAttributes.add("layout_constraintRight_toLeftOf");
        ourRightAttributes.add("layout_constraintRight_toRightOf");
        ourBottomAttributes = new ArrayList();
        ourBottomAttributes.add("layout_constraintBottom_toTopOf");
        ourBottomAttributes.add("layout_constraintBottom_toBottomOf");
    }
}

