/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.targets;

import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintDragTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scout.Scout;
import com.android.tools.idea.uibuilder.scout.ScoutArrange;
import com.android.tools.idea.uibuilder.scout.ScoutWidget;
import java.awt.Point;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstraintDragDndTarget
extends ConstraintDragTarget {
    @Override
    public void mouseDown(int x, int y) {
        if (this.myComponent instanceof TemporarySceneComponent) {
            this.getTargetNotchSnapper().gatherNotches(this.myComponent);
        } else {
            super.mouseDown(x, y);
        }
    }

    @Override
    public void mouseDrag(int x, int y, @Nullable List<Target> closestTarget) {
        if (this.myComponent instanceof TemporarySceneComponent) {
            Scene scene = this.myComponent.getScene();
            int dx = this.getTargetNotchSnapper().trySnapX(x);
            int dy = this.getTargetNotchSnapper().trySnapY(y);
            this.myComponent.setPosition(dx, dy);
            scene.needsRebuildList();
        } else {
            super.mouseDrag(x, y, closestTarget);
        }
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        super.render(list, sceneContext);
    }

    public void mouseRelease(int x, int y, @NotNull NlComponent component2) {
        this.myComponent.setDragging(false);
        if (this.myComponent.getParent() != null) {
            AttributesTransaction attributes = component2.startAttributeTransaction();
            int dx = x - this.myOffsetX;
            int dy = y - this.myOffsetY;
            Point snappedCoordinates = this.getTargetNotchSnapper().applyNotches(this.myComponent, attributes, dx, dy);
            this.updateAttributes(attributes, snappedCoordinates.x, snappedCoordinates.y);
            boolean horizontalMatchParent = false;
            boolean verticalMatchParent = false;
            if ("match_parent".equals(component2.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_width"))) {
                horizontalMatchParent = true;
            }
            if ("match_parent".equals(component2.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_height"))) {
                verticalMatchParent = true;
            }
            if (horizontalMatchParent || verticalMatchParent) {
                float dpiFactor = (float)component2.getModel().getConfiguration().getDensity().getDpiValue() / 160.0f;
                NlComponentHelperKt.setX(component2, (int)((float)dx * dpiFactor));
                NlComponentHelperKt.setY(component2, (int)((float)dy * dpiFactor));
                ScoutWidget parentScoutWidget = new ScoutWidget(this.myComponent.getParent().getNlComponent(), null);
                ScoutWidget[] scoutWidgets = ScoutWidget.create(Arrays.asList(component2), parentScoutWidget);
                int margin = Scout.getMargin();
                if (horizontalMatchParent) {
                    ScoutArrange.expandHorizontally(scoutWidgets, parentScoutWidget, margin, false);
                }
                if (verticalMatchParent) {
                    ScoutArrange.expandVertically(scoutWidgets, parentScoutWidget, margin, false);
                }
            }
            attributes.apply();
            NlWriteCommandAction.run(component2, "drag", attributes::commit);
        }
        if (this.myChangedComponent) {
            this.myComponent.getScene().needsLayout(1);
        }
    }
}

