/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.targets;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.DragBaseTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ChainChecker;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.MultiComponentTarget;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstraintDragTarget
extends DragBaseTarget
implements MultiComponentTarget {
    protected int myOffsetX;
    protected int myOffsetY;
    private static final int ourSnapMarginDistance = 4;
    private final ChainChecker myChainChecker = new ChainChecker();

    @Nullable
    private SceneComponent getTargetComponent(@NotNull String uri, @NotNull ArrayList<String> attributes) {
        NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String target = nlComponent.getAttribute(uri, attributes.get(i));
            if (target == null) continue;
            if (target.equalsIgnoreCase("parent")) {
                return this.myComponent.getParent();
            }
            if ((target = NlComponent.extractId(target)) == null) continue;
            return this.myComponent.getScene().getSceneComponent(target);
        }
        return null;
    }

    private int getStartTargetOrigin(SceneComponent target, boolean isInRtl) {
        NlComponent nlComponent;
        int origin = target.getDrawX();
        if (isInRtl) {
            origin += target.getDrawWidth();
        }
        if ((nlComponent = this.myComponent.getAuthoritativeNlComponent()).getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintStart_toEndOf") != null) {
            origin = isInRtl ? target.getDrawX() : (origin += target.getDrawWidth());
        }
        return origin;
    }

    private int getEndTargetOrigin(SceneComponent target, boolean isInRtl) {
        NlComponent nlComponent;
        int origin = target.getDrawX();
        if (isInRtl) {
            origin += target.getDrawWidth();
        }
        if ((nlComponent = this.myComponent.getAuthoritativeNlComponent()).getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintEnd_toEndOf") != null) {
            origin = isInRtl ? target.getDrawX() : (origin += target.getDrawWidth());
        }
        return origin;
    }

    private int getLeftTargetOrigin(SceneComponent target) {
        int origin = target.getDrawX();
        NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
        if (nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toRightOf") != null) {
            origin += target.getDrawWidth();
        }
        return origin;
    }

    private int getRightTargetOrigin(SceneComponent target) {
        int origin = target.getDrawX();
        NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
        if (nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toRightOf") != null) {
            origin += target.getDrawWidth();
        }
        return origin;
    }

    private int getTopTargetOrigin(SceneComponent target) {
        int origin = target.getDrawY();
        NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
        if (nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toBottomOf") != null) {
            origin += target.getDrawHeight();
        }
        return origin;
    }

    private int getBottomTargetOrigin(SceneComponent target) {
        int origin = target.getDrawY();
        NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
        if (nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toBottomOf") != null) {
            origin += target.getDrawHeight();
        }
        return origin;
    }

    private int getMarginValue(String attribute) {
        NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
        return ConstraintComponentUtilities.getDpValue(nlComponent, nlComponent.getAttribute("http://schemas.android.com/apk/res/android", attribute));
    }

    @Override
    protected void updateAttributes(@NotNull AttributesTransaction attributes, int x, int y) {
        SceneComponent targetStartComponent = this.getTargetComponent("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourStartAttributes);
        SceneComponent targetEndComponent = this.getTargetComponent("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourEndAttributes);
        SceneComponent targetLeftComponent = this.getTargetComponent("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourLeftAttributes);
        SceneComponent targetRightComponent = this.getTargetComponent("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourRightAttributes);
        String targetStartMargin = "layout_marginStart";
        String targetEndMargin = "layout_marginEnd";
        boolean useStartEnd = this.myComponent.useRtlAttributes();
        boolean isInRTL = this.myComponent.getScene().isInRTL();
        int dx1 = 0;
        int dx2 = 0;
        if (targetStartComponent == null && targetEndComponent == null) {
            targetStartComponent = targetLeftComponent;
            targetEndComponent = targetRightComponent;
            targetStartMargin = "layout_marginLeft";
            targetEndMargin = "layout_marginRight";
            useStartEnd = false;
            isInRTL = false;
            if (targetStartComponent != null) {
                dx1 = this.getLeftTargetOrigin(targetStartComponent) + this.getMarginValue(targetStartMargin);
            }
            if (targetEndComponent != null) {
                dx2 = this.getRightTargetOrigin(targetEndComponent) - this.getMarginValue(targetEndMargin);
            }
        } else {
            int margin;
            if (targetStartComponent != null) {
                dx1 = this.getStartTargetOrigin(targetStartComponent, isInRTL);
                margin = this.getMarginValue(targetStartMargin);
                dx1 = isInRTL ? (dx1 -= margin) : (dx1 += margin);
            }
            if (targetEndComponent != null) {
                dx2 = this.getEndTargetOrigin(targetEndComponent, isInRTL);
                margin = this.getMarginValue(targetEndMargin);
                dx2 = isInRTL ? (dx2 += margin) : (dx2 -= margin);
            }
        }
        this.myChainChecker.checkIsInChain(this.myComponent);
        SceneComponent parent = this.myComponent.getParent();
        assert (parent != null);
        if (targetStartComponent != null && targetEndComponent != null) {
            if (!this.myChainChecker.isInHorizontalChain()) {
                float dw = dx2 - dx1 - this.myComponent.getDrawWidth();
                float bias = (float)(x - dx1) / dw;
                if (useStartEnd && isInRTL) {
                    dw = dx1 - dx2 - this.myComponent.getDrawWidth();
                    bias = (dw - (float)(x - dx2)) / dw;
                }
                if (bias < 0.0f) {
                    bias = 0.0f;
                }
                if (bias > 1.0f) {
                    bias = 1.0f;
                }
                String biasValue = null;
                if ((int)(bias * 1000.0f) != 500 && (biasValue = String.valueOf(bias = (float)((int)(bias * 1000.0f)) / 1000.0f)).equalsIgnoreCase("NaN")) {
                    biasValue = null;
                }
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", biasValue);
            }
        } else if (targetStartComponent != null) {
            int dx = x - this.getLeftTargetOrigin(targetStartComponent);
            if (useStartEnd) {
                dx = isInRTL ? this.getStartTargetOrigin(targetStartComponent, isInRTL) - (x + this.myComponent.getDrawWidth()) : x - this.getStartTargetOrigin(targetStartComponent, isInRTL);
            }
            this.applyMargin(attributes, targetStartMargin, dx);
        } else if (targetEndComponent != null) {
            int dx = this.getRightTargetOrigin(targetEndComponent) - (x + this.myComponent.getDrawWidth());
            if (useStartEnd) {
                dx = isInRTL ? x - this.getEndTargetOrigin(targetEndComponent, isInRTL) : this.getEndTargetOrigin(targetEndComponent, isInRTL) - (x + this.myComponent.getDrawWidth());
            }
            this.applyMargin(attributes, targetEndMargin, dx);
        } else {
            int dx = Math.max(0, x - parent.getDrawX());
            String positionX = String.format("%ddp", dx);
            attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", positionX);
        }
        SceneComponent targetTopComponent = this.getTargetComponent("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourTopAttributes);
        SceneComponent targetBottomComponent = this.getTargetComponent("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourBottomAttributes);
        if (targetTopComponent != null && targetBottomComponent != null) {
            if (!this.myChainChecker.isInVerticalChain()) {
                int dy2;
                float dh;
                int dy1 = this.getTopTargetOrigin(targetTopComponent) + this.getMarginValue("layout_marginTop");
                float bias = (float)(y - dy1) / (dh = (float)((dy2 = this.getBottomTargetOrigin(targetBottomComponent) - this.getMarginValue("layout_marginBottom")) - dy1 - this.myComponent.getDrawHeight()));
                if (bias < 0.0f) {
                    bias = 0.0f;
                }
                if (bias > 1.0f) {
                    bias = 1.0f;
                }
                String biasValue = null;
                if ((int)(bias * 1000.0f) != 500 && (biasValue = String.valueOf(bias = (float)((int)(bias * 1000.0f)) / 1000.0f)).equalsIgnoreCase("NaN")) {
                    biasValue = null;
                }
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", biasValue);
            }
        } else if (targetTopComponent != null) {
            int dy = y - this.getTopTargetOrigin(targetTopComponent);
            this.applyMargin(attributes, "layout_marginTop", dy);
        } else if (targetBottomComponent != null) {
            int dy = this.getBottomTargetOrigin(targetBottomComponent) - (y + this.myComponent.getDrawHeight());
            this.applyMargin(attributes, "layout_marginBottom", dy);
        } else {
            int dy = Math.max(0, y - parent.getDrawY());
            String positionY = String.format("%ddp", dy);
            attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", positionY);
        }
        ConstraintComponentUtilities.cleanup(attributes, this.myComponent);
    }

    private void applyMargin(AttributesTransaction attributes, String attribute, int currentValue) {
        currentValue = Math.max(0, currentValue);
        currentValue = currentValue / 4 * 4;
        String marginString = this.myComponent.getAuthoritativeNlComponent().getLiveAttribute("http://schemas.android.com/apk/res/android", attribute);
        int marginValue = -1;
        if (marginString != null) {
            marginValue = this.getMarginValue(attribute);
        }
        if (marginValue != -1 && marginValue == currentValue) {
            attributes.setAttribute("http://schemas.android.com/apk/res/android", attribute, marginString);
        } else {
            String marginY = String.format("%ddp", currentValue);
            attributes.setAttribute("http://schemas.android.com/apk/res/android", attribute, marginY);
        }
    }
}

