/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.targets;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import org.jetbrains.annotations.NotNull;

public class ConstraintResizeTarget
extends ResizeBaseTarget {
    public ConstraintResizeTarget(@NotNull ResizeBaseTarget.Type type) {
        super(type);
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        float d;
        float ratio = 1.0f / (float)sceneTransform.getScale();
        if (ratio > 2.0f) {
            ratio = 2.0f;
        }
        float size = 2.0f * ratio;
        float minWidth = 4.0f * size;
        float minHeight = 4.0f * size;
        if ((float)(r - l) < minWidth) {
            d = (minWidth - (float)(r - l)) / 2.0f;
            l = (int)((float)l - d);
            r = (int)((float)r + d);
        }
        if ((float)(b - t) < minHeight) {
            d = (minHeight - (float)(b - t)) / 2.0f;
            t = (int)((float)t - d);
            b = (int)((float)b + d);
        }
        int w = r - l;
        int h = b - t;
        switch (this.myType) {
            case LEFT: {
                this.myLeft = (float)l - size;
                this.myTop = t;
                this.myRight = (float)l + size;
                this.myBottom = b;
                break;
            }
            case TOP: {
                this.myLeft = l;
                this.myTop = (float)t - size;
                this.myRight = r;
                this.myBottom = (float)t + size;
                break;
            }
            case RIGHT: {
                this.myLeft = (float)r - size;
                this.myTop = t;
                this.myRight = (float)r + size;
                this.myBottom = b;
                break;
            }
            case BOTTOM: {
                this.myLeft = l;
                this.myTop = (float)b - size;
                this.myRight = r;
                this.myBottom = (float)b + size;
                break;
            }
            case LEFT_TOP: {
                this.myLeft = (float)l - size;
                this.myTop = (float)t - size;
                this.myRight = (float)l + size;
                this.myBottom = (float)t + size;
                break;
            }
            case LEFT_BOTTOM: {
                this.myLeft = (float)l - size;
                this.myTop = (float)b - size;
                this.myRight = (float)l + size;
                this.myBottom = (float)b + size;
                break;
            }
            case RIGHT_TOP: {
                this.myLeft = (float)r - size;
                this.myTop = (float)t - size;
                this.myRight = (float)r + size;
                this.myBottom = (float)t + size;
                break;
            }
            case RIGHT_BOTTOM: {
                this.myLeft = (float)r - size;
                this.myTop = (float)b - size;
                this.myRight = (float)r + size;
                this.myBottom = (float)b + size;
            }
        }
        return false;
    }

    @Override
    public int getPreferenceLevel() {
        if (this.myType == ResizeBaseTarget.Type.LEFT || this.myType == ResizeBaseTarget.Type.RIGHT || this.myType == ResizeBaseTarget.Type.TOP || this.myType == ResizeBaseTarget.Type.BOTTOM) {
            return 50;
        }
        return 60;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (this.myType == ResizeBaseTarget.Type.LEFT || this.myType == ResizeBaseTarget.Type.RIGHT || this.myType == ResizeBaseTarget.Type.TOP || this.myType == ResizeBaseTarget.Type.BOTTOM) {
            return;
        }
        super.render(list, sceneContext);
    }

    private static void updateWidth(@NotNull AttributesTransaction attributes, int w) {
        if (w < 0) {
            w = 0;
        }
        String position = String.format("%ddp", w);
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", position);
    }

    private static void updateHeight(@NotNull AttributesTransaction attributes, int h) {
        if (h < 0) {
            h = 0;
        }
        String position = String.format("%ddp", h);
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", position);
    }

    private static void updatePositionX(@NotNull AttributesTransaction attributes, int x) {
        String positionX = String.format("%ddp", x);
        attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", positionX);
    }

    private static void updatePositionY(@NotNull AttributesTransaction attributes, int y) {
        String positionY = String.format("%ddp", y);
        attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", positionY);
    }

    @Override
    protected void updateAttributes(@NotNull AttributesTransaction attributes, int x, int y) {
        switch (this.myType) {
            case RIGHT_TOP: {
                ConstraintResizeTarget.updateWidth(attributes, x - this.myStartX1);
                ConstraintResizeTarget.updatePositionY(attributes, y - this.myComponent.getParent().getDrawY());
                ConstraintResizeTarget.updateHeight(attributes, this.myStartY2 - y);
                break;
            }
            case RIGHT_BOTTOM: {
                ConstraintResizeTarget.updateWidth(attributes, x - this.myStartX1);
                ConstraintResizeTarget.updateHeight(attributes, y - this.myStartY1);
                break;
            }
            case LEFT_TOP: {
                ConstraintResizeTarget.updatePositionX(attributes, x - this.myComponent.getParent().getDrawX());
                ConstraintResizeTarget.updateWidth(attributes, this.myStartX2 - x);
                ConstraintResizeTarget.updatePositionY(attributes, y - this.myComponent.getParent().getDrawY());
                ConstraintResizeTarget.updateHeight(attributes, this.myStartY2 - y);
                break;
            }
            case LEFT_BOTTOM: {
                ConstraintResizeTarget.updatePositionX(attributes, x - this.myComponent.getParent().getDrawX());
                ConstraintResizeTarget.updateWidth(attributes, this.myStartX2 - x);
                ConstraintResizeTarget.updateHeight(attributes, y - this.myStartY1);
                break;
            }
            case LEFT: {
                ConstraintResizeTarget.updatePositionX(attributes, x - this.myComponent.getParent().getDrawX());
                ConstraintResizeTarget.updateWidth(attributes, this.myStartX2 - x);
                break;
            }
            case TOP: {
                ConstraintResizeTarget.updatePositionY(attributes, y - this.myComponent.getParent().getDrawY());
                ConstraintResizeTarget.updateHeight(attributes, this.myStartY2 - y);
                break;
            }
            case BOTTOM: {
                ConstraintResizeTarget.updateHeight(attributes, y - this.myStartY1);
                break;
            }
            case RIGHT: {
                ConstraintResizeTarget.updateWidth(attributes, x - this.myStartX1);
            }
        }
    }
}

