/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.targets;

import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.AnchorTarget;
import java.awt.Cursor;
import org.jetbrains.annotations.NotNull;

public class GuidelineAnchorTarget
extends AnchorTarget {
    boolean myIsHorizontal;

    @Override
    public Cursor getMouseCursor() {
        if (this.myIsHorizontal) {
            return Cursor.getPredefinedCursor(8);
        }
        return Cursor.getPredefinedCursor(11);
    }

    @Override
    public int getPreferenceLevel() {
        return 30;
    }

    public GuidelineAnchorTarget(@NotNull AnchorTarget.Type type, boolean isHorizontal) {
        super(type, false);
        this.myIsHorizontal = isHorizontal;
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        int dist = 4;
        SceneComponent parent = this.myComponent.getParent();
        if (this.myIsHorizontal) {
            this.myLeft = parent.getDrawX();
            this.myTop = t - dist;
            this.myRight = this.myLeft + (float)parent.getDrawWidth();
            this.myBottom = t + dist;
        } else {
            this.myLeft = l - dist;
            this.myTop = parent.getDrawY();
            this.myRight = l + dist;
            this.myBottom = this.myTop + (float)parent.getDrawHeight();
        }
        return false;
    }
}

