/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.targets;

import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawGuidelineCycle;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintDragTarget;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuidelineCycleTarget
extends ConstraintDragTarget {
    private final boolean myIsHorizontal;

    public GuidelineCycleTarget(boolean isHorizontal) {
        this.myIsHorizontal = isHorizontal;
    }

    @Override
    public boolean canChangeSelection() {
        return false;
    }

    @Override
    public int getPreferenceLevel() {
        return 40;
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        int size = 16;
        if (this.myIsHorizontal) {
            this.myLeft = l - size;
            this.myTop = (float)t - (float)size / 2.0f;
            this.myRight = l;
            this.myBottom = (float)t + (float)size / 2.0f;
        } else {
            this.myLeft = (float)l - (float)size / 2.0f;
            this.myTop = t - size;
            this.myRight = (float)l + (float)size / 2.0f;
            this.myBottom = t;
        }
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneTransform) {
        int mode = ConstraintComponentUtilities.getGuidelineMode(this.myComponent);
        DrawGuidelineCycle.add(list, sceneTransform, this.myIsHorizontal, this.myLeft, this.myTop, this.myRight, this.myBottom, mode, this.myComponent.isSelected());
    }

    @Override
    public void mouseDown(int x, int y) {
        super.mouseDown(x, y);
        this.myComponent.setSelected(true);
    }

    @Override
    public void mouseRelease(int x, int y, @Nullable List<Target> closestTargets) {
        super.mouseRelease(x, y, closestTargets);
        if (Math.abs(x - this.myFirstMouseX) > 1 || Math.abs(y - this.myFirstMouseY) > 1) {
            return;
        }
        NlComponent component2 = this.myComponent.getAuthoritativeNlComponent();
        AttributesTransaction attributes = component2.startAttributeTransaction();
        String begin = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin");
        String end = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end");
        String percent = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent");
        SceneComponent parent = this.myComponent.getParent();
        assert (parent != null);
        int value = this.myComponent.getDrawY() - parent.getDrawY();
        int dimension = parent.getDrawHeight();
        if (!this.myIsHorizontal) {
            value = this.myComponent.getDrawX() - parent.getDrawX();
            dimension = parent.getDrawWidth();
        }
        if (begin != null) {
            GuidelineCycleTarget.setEnd(attributes, dimension - value);
        } else if (end != null) {
            GuidelineCycleTarget.setPercent(attributes, (float)value / (float)dimension);
        } else if (percent != null) {
            GuidelineCycleTarget.setBegin(attributes, value);
        }
        attributes.apply();
        NlWriteCommandAction.run(component2, "Cycle Guideline", attributes::commit);
    }

    @Override
    protected void updateAttributes(@NotNull AttributesTransaction attributes, int x, int y) {
        String begin = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin");
        String end = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end");
        String percent = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent");
        SceneComponent parent = this.myComponent.getParent();
        assert (parent != null);
        int value = y - parent.getDrawY();
        float dimension = parent.getDrawHeight();
        if (!this.myIsHorizontal) {
            value = x - parent.getDrawX();
            dimension = parent.getDrawWidth();
        }
        if (begin != null) {
            String position = String.format("%ddp", value);
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", position);
        } else if (end != null) {
            String position = String.format("%ddp", (int)dimension - value);
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end", position);
        } else if (percent != null) {
            String percentStringValue;
            float percentValue = (float)value / dimension;
            if (percentValue > 1.0f) {
                percentValue = 1.0f;
            }
            if (percentValue < 0.0f) {
                percentValue = 0.0f;
            }
            if ((percentStringValue = String.valueOf(percentValue = (float)Math.round(percentValue * 100.0f) / 100.0f)).equalsIgnoreCase("NaN")) {
                percentStringValue = "0.5";
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent", percentStringValue);
        }
        ConstraintComponentUtilities.cleanup(attributes, this.myComponent);
    }

    private static void setBegin(AttributesTransaction transaction, int value) {
        String position = String.format("%ddp", value);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", position);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end", null);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent", null);
    }

    private static void setEnd(AttributesTransaction transaction, int value) {
        String position = String.format("%ddp", value);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", null);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end", position);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent", null);
    }

    private static void setPercent(AttributesTransaction transaction, float value) {
        String position = String.valueOf(value);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", null);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end", null);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent", position);
    }

    @Override
    public String getToolTipText() {
        return "Cycle Guideline";
    }
}

