/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.linear;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.linear.LinearLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.linear.targets.LinearDragTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LinearDragHandler
extends DragHandler {
    private final SceneComponent myComponent;
    private final LinearDragTarget myDragTarget;
    private static final List<Target> ourEmptyTargetList = ImmutableList.of();

    public LinearDragHandler(@NotNull ViewEditor editor, @NotNull LinearLayoutHandler handler, @NotNull SceneComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        super(editor, handler, layout, components, type);
        assert (!components.isEmpty());
        NlComponent dragged = components.get(0);
        this.myComponent = new TemporarySceneComponent(layout.getScene(), components.get(0));
        this.myDragTarget = new LinearDragTarget(handler, type.equals((Object)DragType.CREATE));
        this.myComponent.setSize(editor.pxToDp(NlComponentHelperKt.getW(dragged)), editor.pxToDp(NlComponentHelperKt.getH(dragged)), false);
        this.myComponent.setTargetProvider((sceneComponent, isParent) -> ImmutableList.of((Object)this.myDragTarget), false);
        this.myComponent.setDrawState(SceneComponent.DrawState.DRAG);
        layout.addChild(this.myComponent);
    }

    @Override
    public void start(int x, int y, int modifiers) {
        super.start(x, y, modifiers);
        this.myDragTarget.mouseDown(x, y);
    }

    @Override
    public void cancel() {
        Scene scene = ((ViewEditorImpl)this.editor).getSceneView().getScene();
        scene.removeComponent(this.myComponent);
        this.myDragTarget.cancel();
    }

    @Override
    @Nullable
    public String update(int x, int y, int modifiers) {
        String result = super.update(x, y, modifiers);
        int dx = x + this.startX - this.myComponent.getDrawWidth() / 2;
        int dy = y + this.startY - this.myComponent.getDrawHeight() / 2;
        this.myDragTarget.mouseDrag(dx, dy, ourEmptyTargetList);
        return result;
    }

    @Override
    public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
        Scene scene = ((ViewEditorImpl)this.editor).getSceneView().getScene();
        if (this.myComponent != null) {
            int dx = this.editor.pxToDp(x) - this.myComponent.getDrawWidth() / 2;
            int dy = this.editor.pxToDp(y) - this.myComponent.getDrawHeight() / 2;
            this.myDragTarget.mouseRelease(dx, dy, ourEmptyTargetList);
            scene.removeComponent(this.myComponent);
            if (!this.myDragTarget.isDragHandled()) {
                super.commit(x, y, modifiers, insertType);
            }
            scene.checkRequestLayoutStatus();
        }
    }
}

