/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.linear;

import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneInteraction;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewActionSeparator;
import com.android.tools.idea.uibuilder.handlers.linear.LinearDragHandler;
import com.android.tools.idea.uibuilder.handlers.linear.actions.BaselineAction;
import com.android.tools.idea.uibuilder.handlers.linear.actions.ClearWeightsAction;
import com.android.tools.idea.uibuilder.handlers.linear.actions.DistributeWeightsAction;
import com.android.tools.idea.uibuilder.handlers.linear.actions.ToggleOrientationAction;
import com.android.tools.idea.uibuilder.handlers.linear.targets.LinearDragTarget;
import com.android.tools.idea.uibuilder.handlers.linear.targets.LinearResizeTarget;
import com.android.tools.idea.uibuilder.handlers.linear.targets.LinearSeparatorTarget;
import com.android.tools.idea.uibuilder.model.FillPolicy;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableList;
import icons.AndroidIcons;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearLayoutHandler
extends ViewGroupHandler {
    final HashMap<SceneComponent, SceneComponent> myDraggingComponents = new HashMap();

    @Override
    @NotNull
    public String getTitleAttributes(@NotNull NlComponent component2) {
        if (!component2.getTagName().equals("LinearLayout")) {
            return super.getTitleAttributes(component2);
        }
        return this.isVertical(component2) ? "(vertical)" : "(horizontal)";
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull NlComponent component2) {
        if (!component2.getTagName().equals("LinearLayout")) {
            return super.getIcon(component2);
        }
        return this.isVertical(component2) ? AndroidIcons.Views.VerticalLinearLayout : AndroidIcons.Views.LinearLayout;
    }

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"orientation", (Object)"gravity");
    }

    @Override
    @NotNull
    public List<String> getLayoutInspectorProperties() {
        return ImmutableList.of((Object)"layout_weight");
    }

    public boolean isVertical(@NotNull NlComponent component2) {
        return "vertical".equals(component2.resolveAttribute("http://schemas.android.com/apk/res/android", "orientation"));
    }

    @Override
    @Nullable
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull SceneComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        if (layout.getDrawWidth() == 0 || layout.getDrawHeight() == 0) {
            return null;
        }
        return new LinearDragHandler(editor, this, layout, components, type);
    }

    @Override
    public void onChildInserted(@NotNull ViewEditor editor, @NotNull NlComponent layout, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (insertType == InsertType.MOVE_WITHIN) {
            return;
        }
        ViewHandler viewHandler = NlComponentHelperKt.getViewHandler(newChild);
        if (viewHandler != null) {
            boolean vertical = this.isVertical(layout);
            FillPolicy fill2 = viewHandler.getFillPolicy();
            String fillParent = "match_parent";
            if (fill2.fillHorizontally(vertical)) {
                newChild.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", fillParent);
            } else if (!vertical && fill2 == FillPolicy.WIDTH_IN_VERTICAL) {
                newChild.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", "1");
            }
            if (fill2.fillVertically(vertical)) {
                newChild.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", fillParent);
            }
        }
        boolean duplicateWeight = true;
        boolean duplicate0dip = true;
        String sameWeight = null;
        String sizeAttribute = this.isVertical(layout) ? "layout_height" : "layout_width";
        for (NlComponent target : layout.getChildren()) {
            String size;
            if (target == newChild) continue;
            String weight = target.getAttribute("http://schemas.android.com/apk/res/android", "layout_weight");
            if (weight == null || weight.isEmpty()) {
                duplicateWeight = false;
                break;
            }
            if (sameWeight != null && !sameWeight.equals(weight)) {
                duplicateWeight = false;
            } else {
                sameWeight = weight;
            }
            if ((size = target.getAttribute("http://schemas.android.com/apk/res/android", sizeAttribute)) == null || size.startsWith("0")) continue;
            duplicate0dip = false;
            break;
        }
        if (duplicateWeight && sameWeight != null) {
            newChild.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", sameWeight);
            if (duplicate0dip) {
                newChild.setAttribute("http://schemas.android.com/apk/res/android", sizeAttribute, "0dp");
            }
        }
    }

    static float getWeight(@NotNull NlComponent linearLayoutChild) {
        String weight = linearLayoutChild.getAttribute("http://schemas.android.com/apk/res/android", "layout_weight");
        if (weight != null && !weight.isEmpty()) {
            try {
                return Float.parseFloat(weight);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    static float getWeightSum(@NotNull NlComponent linearLayout) {
        String weightSum = linearLayout.getAttribute("http://schemas.android.com/apk/res/android", "weightSum");
        if (weightSum != null) {
            try {
                float sum = Float.parseFloat(weightSum);
                return sum;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return LinearLayoutHandler.getSumOfWeights(linearLayout);
    }

    private static float getSumOfWeights(@NotNull NlComponent linearLayout) {
        float sum = 0.0f;
        for (NlComponent child : linearLayout.getChildren()) {
            sum += LinearLayoutHandler.getWeight(child);
        }
        return sum;
    }

    public void clearWeights(@NotNull NlComponent component2, @NotNull List<NlComponent> selectedChildren) {
        String sizeAttribute = this.isVertical(component2) ? "layout_height" : "layout_width";
        for (NlComponent selected : selectedChildren) {
            selected.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", null);
            String size = selected.getAttribute("http://schemas.android.com/apk/res/android", sizeAttribute);
            if (size == null || !size.startsWith("0")) continue;
            selected.setAttribute("http://schemas.android.com/apk/res/android", sizeAttribute, "wrap_content");
        }
    }

    public void distributeWeights(@NotNull NlComponent component2, @NotNull List<NlComponent> selectedChildren) {
        if (selectedChildren.isEmpty()) {
            return;
        }
        String weightSum = component2.getAttribute("http://schemas.android.com/apk/res/android", "weightSum");
        double sum = -1.0;
        if (weightSum != null && !weightSum.isEmpty()) {
            try {
                sum = Double.parseDouble(weightSum);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int numTargets = selectedChildren.size();
        double share = sum <= 0.0 ? 1.0 : sum / (double)numTargets;
        String value = XmlUtils.formatFloatAttribute((double)((float)share));
        String sizeAttribute = this.isVertical(component2) ? "layout_height" : "layout_width";
        for (NlComponent selected : selectedChildren) {
            selected.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", value);
            if (!"wrap_content".equals(selected.getAttribute("http://schemas.android.com/apk/res/android", sizeAttribute))) continue;
            selected.setAttribute("http://schemas.android.com/apk/res/android", sizeAttribute, "0dp");
        }
    }

    @Override
    public void addToolbarActions(@NotNull List<ViewAction> actions) {
        int rank = 0;
        actions.add(new ToggleOrientationAction().setRank(rank += 20));
        actions.add(new BaselineAction().setRank(rank += 20));
        actions.add(new DistributeWeightsAction().setRank(rank += 20));
        actions.add(new ClearWeightsAction().setRank(rank += 20));
        actions.add(new ViewActionSeparator().setRank(rank += 20));
        this.addDefaultViewActions(actions, rank);
    }

    @Override
    public void addPopupMenuActions(@NotNull List<ViewAction> actions) {
        this.addToolbarActionsToMenu("LinearLayout", actions);
    }

    @Override
    @Nullable
    public Interaction createInteraction(@NotNull ScreenView sceneView, @NotNull NlComponent layout) {
        return new SceneInteraction(sceneView);
    }

    @Override
    public boolean handlesPainting() {
        return true;
    }

    @Override
    @NotNull
    public List<Target> createTargets(@NotNull SceneComponent sceneComponent, boolean isParent) {
        if (isParent) {
            return super.createTargets(sceneComponent, true);
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.add((Object)new LinearDragTarget(this));
        LinearLayoutHandler.createResizeTarget(sceneComponent, (ImmutableList.Builder<Target>)listBuilder);
        this.createSeparatorTargets(sceneComponent, (ImmutableList.Builder<Target>)listBuilder);
        return listBuilder.build();
    }

    private void createSeparatorTargets(@NotNull SceneComponent sceneComponent, @NotNull ImmutableList.Builder<Target> listBuilder) {
        SceneComponent parent = sceneComponent.getParent();
        assert (parent != null);
        SceneComponent draggingComponent = this.myDraggingComponents.get(parent);
        if (draggingComponent != null && draggingComponent != sceneComponent) {
            boolean isLayoutOrientationVertical = this.isVertical(parent.getNlComponent());
            if (LinearLayoutHandler.canReceiveBefore(parent, sceneComponent, draggingComponent)) {
                listBuilder.add((Object)new LinearSeparatorTarget(isLayoutOrientationVertical, false));
            }
            if (LinearLayoutHandler.isLastChild(parent, sceneComponent)) {
                listBuilder.add((Object)new LinearSeparatorTarget(isLayoutOrientationVertical, true));
            }
        }
    }

    private static void createResizeTarget(@NotNull SceneComponent sceneComponent, @NotNull ImmutableList.Builder<Target> listBuilder) {
        SceneComponent parent = sceneComponent.getParent();
        assert (parent != null);
        String orientation = parent.getNlComponent().getAttribute("http://schemas.android.com/apk/res/android", "orientation");
        boolean showLeft = true;
        boolean showTop = true;
        boolean showBottom = true;
        boolean showRight = true;
        String gravityAttribute = sceneComponent.getNlComponent().getAttribute("http://schemas.android.com/apk/res/android", "layout_gravity");
        if (gravityAttribute == null || gravityAttribute.contains("fill")) {
            showLeft = false;
            showTop = false;
        } else {
            String[] gravities;
            String[] stringArray = gravities = gravityAttribute.split("\\|");
            int n = stringArray.length;
            block18: for (int i = 0; i < n; ++i) {
                String gravity;
                switch (gravity = stringArray[i]) {
                    case "left": 
                    case "start": {
                        showLeft = false;
                        continue block18;
                    }
                    case "top": {
                        showTop = false;
                        continue block18;
                    }
                    case "bottom": {
                        showBottom = false;
                        continue block18;
                    }
                    case "right": 
                    case "end": {
                        showRight = false;
                        continue block18;
                    }
                    case "center_horizontal": {
                        if (!"vertical".equals(orientation)) continue block18;
                        showTop = false;
                        continue block18;
                    }
                    case "center_vertical": {
                        if (!"horizontal".equals(orientation)) continue block18;
                        showLeft = false;
                    }
                }
            }
        }
        if (showLeft) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.LEFT));
        }
        if (showTop) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.TOP));
        }
        if (showBottom) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.BOTTOM));
        }
        if (showRight) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.RIGHT));
        }
        if (showLeft && showTop) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.LEFT_TOP));
        }
        if (showLeft && showBottom) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.LEFT_BOTTOM));
        }
        if (showRight && showTop) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.RIGHT_TOP));
        }
        if (showRight && showBottom) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.RIGHT_BOTTOM));
        }
    }

    private static boolean canReceiveBefore(@NotNull SceneComponent parent, @NotNull SceneComponent nextSibling, @NotNull SceneComponent draggingComponent) {
        List<NlComponent> children = parent.getNlComponent().getChildren();
        int i = children.indexOf(nextSibling.getNlComponent());
        return i > -1 && (i == 0 || children.get(i - 1) != draggingComponent.getNlComponent());
    }

    private static boolean isLastChild(@NotNull SceneComponent linearLayoutComponent, @NotNull SceneComponent child) {
        NlComponent nlComponent = linearLayoutComponent.getNlComponent();
        return nlComponent.getChild(nlComponent.getChildCount() - 1) == child.getNlComponent();
    }

    public static boolean insertComponentAtTarget(@NotNull SceneComponent component2, @NotNull LinearSeparatorTarget separatorTarget, boolean isDragFromPalette) {
        SceneComponent sceneParent = component2.getParent();
        if (sceneParent == null) {
            return false;
        }
        NlComponent parent = sceneParent.getNlComponent();
        String id = component2.getNlComponent().getId();
        String name = (isDragFromPalette ? "Insert" : "Move") + ' ' + (id != null ? id : component2.getNlComponent().getTagName());
        NlWriteCommandAction.run(component2.getNlComponent(), name, () -> {
            ImmutableList nlComponentImmutableList = ImmutableList.of((Object)component2.getNlComponent());
            parent.getModel().addComponents((List<NlComponent>)nlComponentImmutableList, parent, !separatorTarget.isAtEnd() ? separatorTarget.getComponent().getNlComponent() : null, isDragFromPalette ? InsertType.CREATE : InsertType.MOVE_WITHIN);
        });
        return true;
    }

    public void setDragging(@NotNull SceneComponent draggedComponent, boolean isDragging) {
        if (isDragging && !this.myDraggingComponents.containsKey(draggedComponent.getParent())) {
            this.myDraggingComponents.put(draggedComponent.getParent(), draggedComponent);
        } else if (!isDragging && this.myDraggingComponents.containsKey(draggedComponent.getParent())) {
            this.myDraggingComponents.remove(draggedComponent.getParent());
        }
    }
}

