/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.linear.actions;

import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.actions.ViewActionPresentation;
import com.android.tools.idea.uibuilder.handlers.linear.LinearLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.linear.actions.LinearLayoutAction;
import icons.AndroidIcons;
import java.util.List;
import javax.swing.Icon;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class ToggleOrientationAction
extends LinearLayoutAction {
    @Override
    protected void perform(@NotNull ViewEditor editor, @NotNull LinearLayoutHandler handler, @NotNull NlComponent component2, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
        boolean isHorizontal = !handler.isVertical(component2);
        String value = isHorizontal ? "vertical" : null;
        NlWriteCommandAction.run(component2, "Change LinearLayout orientation", () -> component2.setAttribute("http://schemas.android.com/apk/res/android", "orientation", value));
    }

    @Override
    protected void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull LinearLayoutHandler handler, @NotNull NlComponent component2, @NotNull List<NlComponent> selectedChildren, int modifiers) {
        boolean vertical = handler.isVertical(component2);
        presentation.setLabel("Convert orientation to " + (vertical ? "horizontal" : "vertical"));
        Icon icon = vertical ? AndroidIcons.Views.LinearLayout : AndroidIcons.Views.VerticalLinearLayout;
        presentation.setIcon(icon);
    }
}

