/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.linear.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.sherpa.drawing.ColorSet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class DrawLinearSeparator
extends DrawRegion {
    public static final int STROKE_SIZE = 2;
    private static final Stroke STROKE = new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{8.0f, 6.0f}, 0.0f);

    public DrawLinearSeparator(boolean layoutVertical, int x, int y, int length) {
        this.setLocation(x, y);
        if (layoutVertical) {
            this.setSize(length, 0);
        } else {
            this.setSize(0, length);
        }
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet colorSet = sceneContext.getColorSet();
        Stroke defStroke = g.getStroke();
        Color defColor = g.getColor();
        g.setStroke(STROKE);
        g.setColor(colorSet.getDragReceiverFrames());
        g.drawLine(this.x, this.y, this.x + this.width, this.y + this.height);
        g.setColor(defColor);
        g.setStroke(defStroke);
    }

    public static void add(DisplayList list, SceneContext context, boolean layoutVertical, float left, float top, float right, float bottom) {
        float length = layoutVertical ? right - left : bottom - top;
        DrawLinearSeparator separator = new DrawLinearSeparator(layoutVertical, context.getSwingX(left), context.getSwingY(top), context.getSwingDimension(length));
        list.add(separator);
    }
}

