/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.linear.targets;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.DragBaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.linear.LinearLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.linear.targets.LinearSeparatorTarget;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.scene.target.Notch;
import com.android.tools.idea.uibuilder.scene.target.TargetSnapper;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearDragTarget
extends DragBaseTarget {
    private final LinearLayoutHandler myHandler;
    private final boolean myIsDragFromPalette;
    private LinearSeparatorTarget myClosest;
    private boolean myDragHandled;

    public LinearDragTarget(@NotNull LinearLayoutHandler handler) {
        this(handler, false);
    }

    public LinearDragTarget(@NotNull LinearLayoutHandler handler, boolean fromPalette) {
        this.myHandler = handler;
        this.myIsDragFromPalette = fromPalette;
    }

    @Override
    protected void updateAttributes(@NotNull AttributesTransaction attributes, int x, int y) {
    }

    @Override
    public void mouseDown(int x, int y) {
        SceneComponent parent = this.myComponent.getParent();
        assert (parent != null);
        this.myHandler.setDragging(this.myComponent, true);
        ((LayoutlibSceneManager)parent.getScene().getSceneManager()).addTargets(this.myComponent);
        parent.updateTargets(true);
        this.myDragHandled = false;
        super.mouseDown(x, y);
        this.myComponent.setModelUpdateAuthorized(false);
    }

    @Override
    public void mouseDrag(int x, int y, @Nullable List<Target> closestTargets) {
        Notch snappedNotch;
        SceneComponent sceneParent = this.myComponent.getParent();
        assert (sceneParent != null);
        TargetSnapper snapper = this.getTargetNotchSnapper();
        Target closestTarget = null;
        this.myComponent.setDragging(true);
        x -= this.myOffsetX;
        y -= this.myOffsetY;
        if (this.myHandler.isVertical(sceneParent.getNlComponent())) {
            int middle = this.myComponent.getDrawHeight() / 2;
            int parentHeight = sceneParent.getDrawHeight();
            int nx = this.myIsDragFromPalette ? x : this.myComponent.getDrawX();
            int ny = snapper.trySnapY(Math.min(Math.max(y, -middle), parentHeight + middle));
            this.myComponent.setPosition(nx, ny, false);
            snappedNotch = snapper.getSnappedNotchY();
        } else {
            int middle = this.myComponent.getDrawWidth() / 2;
            int parentWidth = sceneParent.getDrawWidth();
            int nx = snapper.trySnapX(Math.min(Math.max(x, -middle), parentWidth + middle));
            int ny = this.myIsDragFromPalette ? y : this.myComponent.getDrawY();
            this.myComponent.setPosition(nx, ny, false);
            snappedNotch = snapper.getSnappedNotchX();
        }
        if (snappedNotch != null) {
            closestTarget = snappedNotch.getTarget();
        }
        if (this.myClosest != closestTarget) {
            if (this.myClosest != null) {
                this.myClosest.setHighlight(false);
            }
            if (closestTarget != null && closestTarget instanceof LinearSeparatorTarget) {
                this.myClosest = (LinearSeparatorTarget)closestTarget;
                this.myClosest.setHighlight(true, this.myComponent.getDrawWidth(), this.myComponent.getDrawHeight());
            } else {
                this.myClosest = null;
            }
        }
        this.myComponent.getScene().repaint();
    }

    @Override
    public void mouseRelease(int x, int y, @Nullable List<Target> closestTarget) {
        super.mouseRelease(x, y, closestTarget);
        this.myComponent.setModelUpdateAuthorized(true);
        this.myHandler.setDragging(this.myComponent, false);
        SceneComponent parent = this.myComponent.getParent();
        assert (parent != null);
        parent.updateTargets(true);
        if (this.myClosest != null) {
            this.myClosest.setHighlight(false);
            if (!LinearLayoutHandler.insertComponentAtTarget(this.myComponent, this.myClosest, this.myIsDragFromPalette)) {
                this.myComponent.getScene().needsLayout(2);
                return;
            }
            this.myDragHandled = true;
        } else {
            this.myComponent.getScene().needsLayout(2);
        }
    }

    public boolean isDragHandled() {
        return this.myDragHandled;
    }

    public void cancel() {
        this.myHandler.setDragging(this.myComponent, false);
        if (this.myClosest != null) {
            this.myClosest.setHighlight(false);
        }
    }
}

