/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.linear.targets;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.uibuilder.handlers.linear.LinearLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.linear.draw.DrawLinearPlaceholder;
import com.android.tools.idea.uibuilder.handlers.linear.draw.DrawLinearSeparator;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.target.Notch;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearSeparatorTarget
extends BaseTarget
implements Notch.Provider {
    private static final boolean DEBUG = false;
    private final boolean myLayoutVertical;
    private final boolean myAtEnd;
    private boolean myIsHighlight;
    private int myHighLightSize;
    @Nullable
    private SceneComponent myParent;
    private boolean myCanDisplayPlaceholderAfter;

    public LinearSeparatorTarget(boolean layoutVertical, boolean atEnd) {
        this.myLayoutVertical = layoutVertical;
        this.myAtEnd = atEnd;
    }

    @Override
    public int getPreferenceLevel() {
        return 30;
    }

    @Override
    public boolean layout(@NotNull SceneContext context, int l, int t, int r, int b) {
        this.myParent = this.myComponent.getParent();
        assert (this.myParent != null) : "This target cannot be added to a root component";
        NlComponent nlComponent = this.myComponent.getNlComponent();
        if (this.myLayoutVertical) {
            int parentMin = this.myParent.getDrawY() + 1;
            int parentMax = parentMin + this.myParent.getDrawHeight() - 2;
            this.myLeft = this.myParent.getDrawX();
            this.myRight = this.myLeft + (float)this.myParent.getDrawWidth();
            float y = context.pxToDp(NlComponentHelperKt.getY(nlComponent)) + (this.myAtEnd ? context.pxToDp(NlComponentHelperKt.getH(nlComponent)) : 0.0f);
            this.myTop = this.myBottom = Math.max((float)parentMin, Math.min((float)parentMax, y));
            this.myCanDisplayPlaceholderAfter = this.myComponent.getDrawY() + this.myComponent.getDrawHeight() < parentMax;
        } else {
            int parentMin = this.myParent.getDrawX() + 1;
            int parentMax = parentMin + this.myParent.getDrawWidth() - 2;
            float x = context.pxToDp(NlComponentHelperKt.getX(nlComponent)) + (this.myAtEnd ? context.pxToDp(NlComponentHelperKt.getW(nlComponent)) : 0.0f);
            this.myLeft = this.myRight = Math.max((float)parentMin, Math.min((float)parentMax, x));
            this.myTop = this.myParent.getDrawY();
            this.myBottom = this.myTop + (float)this.myParent.getDrawHeight();
            this.myCanDisplayPlaceholderAfter = this.myComponent.getDrawX() + this.myComponent.getDrawWidth() < parentMax;
        }
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (this.myComponent.isDragging() || this.myParent == null) {
            return;
        }
        if (this.myIsHighlight) {
            DrawLinearPlaceholder.add(list, sceneContext, this.myLayoutVertical, this.myAtEnd && this.myCanDisplayPlaceholderAfter, this.myHighLightSize, this.myLeft, this.myTop, this.myRight, this.myBottom);
        } else {
            DrawLinearSeparator.add(list, sceneContext, this.myLayoutVertical, this.myLeft, this.myTop, this.myRight, this.myBottom);
        }
    }

    @Override
    public void addHit(@NotNull SceneContext transform, @NotNull ScenePicker picker) {
        picker.addRect(this, 10, transform.getSwingX(this.myLeft), transform.getSwingY(this.myTop), transform.getSwingX(this.myRight) + 1, transform.getSwingY(this.myBottom) + 1);
    }

    private void drawDebug(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        list.addLine(sceneContext, this.myLeft, this.myTop, this.myRight, this.myBottom, (Color)(this.myIsHighlight ? JBColor.GREEN : JBColor.RED));
        list.addLine(sceneContext, this.myLeft, this.myBottom, this.myRight, this.myTop, (Color)(this.myIsHighlight ? JBColor.GREEN : JBColor.RED));
        if (this.myLayoutVertical) {
            list.addRect(sceneContext, this.myLeft, this.myTop, this.myRight, this.myBottom + (float)this.myHighLightSize, JBColor.MAGENTA);
        } else {
            list.addRect(sceneContext, this.myLeft, this.myTop, this.myRight + (float)this.myHighLightSize, this.myBottom, JBColor.MAGENTA);
        }
    }

    public void setHighlight(boolean isHighlight) {
        this.setHighlight(isHighlight, 5, 5);
    }

    public void setHighlight(boolean isHighlight, int width, int height) {
        this.myIsHighlight = isHighlight;
        this.myHighLightSize = this.myLayoutVertical ? height : width;
    }

    public boolean isAtEnd() {
        return this.myAtEnd;
    }

    @Override
    public void fill(@NotNull SceneComponent owner, @NotNull SceneComponent snappableComponent, @NotNull ArrayList<Notch> horizontalNotches, @NotNull ArrayList<Notch> verticalNotches) {
        Notch.Action action = attributes -> LinearLayoutHandler.insertComponentAtTarget(snappableComponent, this, false);
        if (this.myLayoutVertical) {
            int value = owner.getDrawY();
            int displayValue = owner.getDrawY();
            if (this.myAtEnd) {
                if (this.myCanDisplayPlaceholderAfter) {
                    value += owner.getDrawHeight();
                    displayValue += owner.getDrawHeight();
                } else {
                    value += owner.getDrawHeight() - snappableComponent.getDrawHeight() / 2;
                    displayValue += owner.getDrawHeight() - snappableComponent.getDrawHeight() / 2;
                }
            } else {
                value = (int)((float)value - ((float)snappableComponent.getDrawHeight() / 2.0f + 0.5f));
            }
            Notch.Vertical notch = new Notch.Vertical(owner, value, displayValue, action);
            notch.setGap(owner.getDrawHeight() / 2);
            notch.setTarget(this);
            verticalNotches.add(notch);
        } else {
            int value = owner.getDrawX();
            int displayValue = owner.getDrawX();
            if (this.myAtEnd) {
                if (this.myCanDisplayPlaceholderAfter) {
                    value += owner.getDrawWidth();
                    displayValue += owner.getDrawWidth();
                } else {
                    value += owner.getDrawWidth() - snappableComponent.getDrawWidth() / 2;
                    displayValue += owner.getDrawWidth() - snappableComponent.getDrawWidth() / 2;
                }
            } else {
                value = (int)((float)value - ((float)snappableComponent.getDrawWidth() / 2.0f + 0.5f));
            }
            Notch.Horizontal notch = new Notch.Horizontal(owner, value, displayValue, action);
            notch.setGap(owner.getDrawWidth() / 2);
            notch.setTarget(this);
            horizontalNotches.add(notch);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " highlighted: " + this.myIsHighlight + " vertical: " + this.myLayoutVertical;
    }
}

