/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.preference;

import com.android.resources.ResourceType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceHandler;
import com.android.xml.XmlBuilder;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ListPreferenceHandler
extends PreferenceHandler {
    @Override
    @Language(value="XML")
    @NotNull
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        switch (xmlType) {
            case COMPONENT_CREATION: {
                return new XmlBuilder().startTag(tagName).androidAttribute("defaultValue", 1).androidAttribute("title", "List preference").endTag(tagName).toString();
            }
            case PREVIEW_ON_PALETTE: 
            case DRAG_PREVIEW: {
                return "";
            }
        }
        throw new AssertionError((Object)xmlType);
    }

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"defaultValue", (Object)"entries", (Object)"entryValues", (Object)"key", (Object)"title", (Object)"summary", (Object)"dependency", (Object)"icon", (Object)"dialogIcon");
    }

    @Override
    public boolean onCreate(@NotNull ViewEditor editor, @Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType type) {
        if (!super.onCreate(editor, parent, newChild, type)) {
            return false;
        }
        if (type.equals((Object)InsertType.CREATE)) {
            EnumSet<ResourceType> array = EnumSet.of(ResourceType.ARRAY);
            String entries = editor.displayResourceInput("Choose entries Resource", array);
            if (entries == null) {
                return false;
            }
            String entryValues = editor.displayResourceInput("Choose entryValues Resource", array);
            if (entryValues == null) {
                return false;
            }
            newChild.setAndroidAttribute("entries", entries);
            newChild.setAndroidAttribute("entryValues", entryValues);
            newChild.setAndroidAttribute("key", ListPreferenceHandler.generateKey(newChild, "ListPreference", "list_preference_"));
        }
        return true;
    }
}

