/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.preference;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceGroupDragHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PreferenceCategoryDragHandler
extends PreferenceGroupDragHandler {
    PreferenceCategoryDragHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull SceneComponent category, @NotNull List<NlComponent> preferences, @NotNull DragType type) {
        super(editor, handler, category, preferences, type);
    }

    @Override
    @Nullable
    public String update(int x, int y, int modifiers) {
        String message = super.update(x, y, modifiers);
        if (message != null) {
            return message;
        }
        if (this.myGroup.getChildren().isEmpty()) {
            return null;
        }
        this.updateActivePreference();
        return null;
    }

    @Override
    void drawDropPreviewLine(@NotNull NlGraphics graphics) {
        if (this.myGroup.getChildren().isEmpty()) {
            graphics.useStyle(NlDrawingStyle.DROP_PREVIEW);
            graphics.drawBottomDp(this.getBounds(this.myGroup));
        } else {
            super.drawDropPreviewLine(graphics);
        }
    }

    @Override
    void drawDropRecipientLines(@NotNull NlGraphics graphics) {
        graphics.useStyle(NlDrawingStyle.DROP_RECIPIENT);
        Rectangle bounds = this.getBounds(this.myGroup);
        graphics.drawTopDp(bounds);
        graphics.drawLeftDp(bounds);
        graphics.drawRightDp(bounds);
        ArrayList<SceneComponent> preferences = this.myGroup.getChildren();
        if (!preferences.isEmpty() && this.lastY < this.getMidpointY((SceneComponent)preferences.get(preferences.size() - 1))) {
            graphics.drawBottomDp(bounds);
        }
    }

    @Override
    void drawDropZoneLines(@NotNull NlGraphics graphics) {
        this.drawDropZoneLines(graphics, 0);
    }
}

