/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.preference;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.google.common.base.Strings;
import com.intellij.psi.xml.XmlTag;
import java.util.Arrays;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PreferenceHandler
extends ViewHandler {
    @Override
    @Language(value="XML")
    @NotNull
    public abstract String getXml(@NotNull String var1, @NotNull XmlType var2);

    @Override
    public boolean onCreate(@NotNull ViewEditor editor, @Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType type) {
        if (type.equals((Object)InsertType.CREATE)) {
            newChild.removeAndroidAttribute("layout_width");
            newChild.removeAndroidAttribute("layout_height");
        }
        return true;
    }

    @NotNull
    static String generateKey(@NotNull NlComponent component2, @NotNull String tagName, @NotNull String keyPrefix) {
        XmlTag preferenceScreen = component2.getModel().getFile().getRootTag();
        if (preferenceScreen == null) {
            return "";
        }
        XmlTag[] preferences = preferenceScreen.findSubTags(tagName);
        int i = 1;
        String key = keyPrefix + i++;
        while (PreferenceHandler.anyPreferenceKeyEquals(preferences, key)) {
            key = keyPrefix + i++;
        }
        return key;
    }

    private static boolean anyPreferenceKeyEquals(@NotNull XmlTag[] preferences, @NotNull String key) {
        return Arrays.stream(preferences).map(preference -> preference.getAttributeValue("key", "http://schemas.android.com/apk/res/android")).anyMatch(key::equals);
    }

    @Override
    @NotNull
    public String getTitle(@NotNull NlComponent component2) {
        return Strings.nullToEmpty((String)component2.getAndroidAttribute("title"));
    }
}

