/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.relative.ConstraintType;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.xml.XmlAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeletionHandler {
    private final List<NlComponent> myChildren;
    private final List<NlComponent> myDeleted;
    private final Set<String> myDeletedIds;
    private final Map<String, NlComponent> myNodeMap;

    public DeletionHandler(@NotNull List<NlComponent> deleted, @NotNull List<NlComponent> moved, @NotNull NlComponent layout) {
        String id;
        this.myDeleted = deleted;
        this.myChildren = Lists.newArrayList(layout.getChildren());
        this.myNodeMap = Maps.newHashMapWithExpectedSize((int)this.myChildren.size());
        for (NlComponent view : this.myChildren) {
            id = view.getId();
            if (id == null) continue;
            this.myNodeMap.put(LintUtils.stripIdPrefix((String)id), view);
        }
        this.myDeletedIds = Sets.newHashSetWithExpectedSize((int)this.myDeleted.size());
        for (NlComponent node : this.myDeleted) {
            id = node.getId();
            if (id == null) continue;
            this.myDeletedIds.add(LintUtils.stripIdPrefix((String)id));
        }
        for (NlComponent node : moved) {
            id = node.getId();
            if (id == null) continue;
            this.myDeletedIds.remove(LintUtils.stripIdPrefix((String)id));
        }
    }

    @Nullable
    private static String getId(@NotNull XmlAttribute attribute) {
        if (attribute.getLocalName().startsWith("layout_") && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespace()) && !attribute.getLocalName().startsWith("layout_margin")) {
            String id = attribute.getValue();
            if (id == null) {
                return null;
            }
            if (id.startsWith("@+id/")) {
                return id.substring("@+id/".length());
            }
            if (id.startsWith("@id/")) {
                return id.substring("@id/".length());
            }
        }
        return null;
    }

    public void updateConstraints() {
        if (this.myChildren.size() == this.myDeleted.size()) {
            return;
        }
        for (NlComponent child : this.myChildren) {
            if (this.myDeleted.contains(child)) continue;
            for (XmlAttribute attribute : child.getTag().getAttributes()) {
                ConstraintType type;
                String id = DeletionHandler.getId(attribute);
                if (id == null || !this.myDeletedIds.contains(id)) continue;
                String name = attribute.getLocalName();
                attribute.delete();
                NlComponent deleted = this.myNodeMap.get(id);
                if (deleted == null || (type = ConstraintType.fromAttribute(name)) == null) continue;
                this.transfer(deleted, child, type, 0);
            }
        }
    }

    private void transfer(NlComponent deleted, NlComponent target, ConstraintType targetType, int depth) {
        if (depth == 20) {
            return;
        }
        assert (this.myDeleted.contains(deleted));
        for (XmlAttribute attribute : deleted.getTag().getAttributes()) {
            ConstraintType transfer;
            String name = attribute.getLocalName();
            ConstraintType type = ConstraintType.fromAttribute(name);
            if (type == null || (transfer = DeletionHandler.getCompatibleConstraint(type, targetType)) == null) continue;
            String id = DeletionHandler.getId(attribute);
            if (id != null) {
                if (this.myDeletedIds.contains(id)) {
                    NlComponent nextDeleted = this.myNodeMap.get(id);
                    if (nextDeleted == null) continue;
                    this.transfer(nextDeleted, target, targetType, depth + 1);
                    continue;
                }
                target.setAttribute("http://schemas.android.com/apk/res/android", transfer.name, attribute.getValue());
                continue;
            }
            target.setAttribute("http://schemas.android.com/apk/res/android", name, attribute.getValue());
        }
    }

    @Nullable
    private static ConstraintType getCompatibleConstraint(@NotNull ConstraintType first, @NotNull ConstraintType second) {
        if (first == second) {
            return first;
        }
        switch (second) {
            case ALIGN_LEFT: 
            case LAYOUT_RIGHT_OF: {
                switch (first) {
                    case LAYOUT_CENTER_HORIZONTAL: 
                    case LAYOUT_LEFT_OF: 
                    case ALIGN_LEFT: {
                        return first;
                    }
                    case LAYOUT_CENTER_IN_PARENT: {
                        return ConstraintType.LAYOUT_CENTER_HORIZONTAL;
                    }
                }
                return null;
            }
            case LAYOUT_LEFT_OF: 
            case ALIGN_RIGHT: {
                switch (first) {
                    case LAYOUT_CENTER_HORIZONTAL: 
                    case LAYOUT_LEFT_OF: 
                    case ALIGN_RIGHT: {
                        return first;
                    }
                    case LAYOUT_CENTER_IN_PARENT: {
                        return ConstraintType.LAYOUT_CENTER_HORIZONTAL;
                    }
                }
                return null;
            }
            case ALIGN_TOP: 
            case LAYOUT_BELOW: 
            case ALIGN_BASELINE: {
                switch (first) {
                    case LAYOUT_CENTER_VERTICAL: 
                    case ALIGN_TOP: 
                    case LAYOUT_BELOW: 
                    case ALIGN_BASELINE: {
                        return first;
                    }
                    case LAYOUT_CENTER_IN_PARENT: {
                        return ConstraintType.LAYOUT_CENTER_VERTICAL;
                    }
                }
                return null;
            }
            case ALIGN_BOTTOM: 
            case LAYOUT_ABOVE: {
                switch (first) {
                    case LAYOUT_CENTER_VERTICAL: 
                    case ALIGN_BASELINE: 
                    case ALIGN_BOTTOM: 
                    case LAYOUT_ABOVE: {
                        return first;
                    }
                    case LAYOUT_CENTER_IN_PARENT: {
                        return ConstraintType.LAYOUT_CENTER_VERTICAL;
                    }
                }
                return null;
            }
        }
        return null;
    }
}

