/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative;

import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ResizeHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.relative.ConstraintPainter;
import com.android.tools.idea.uibuilder.handlers.relative.GuidelinePainter;
import com.android.tools.idea.uibuilder.handlers.relative.RelativeDragHandler;
import com.android.tools.idea.uibuilder.handlers.relative.RelativeResizeHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.SegmentType;
import com.android.tools.idea.uibuilder.model.TextDirection;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.Lists;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelativeLayoutHandler
extends ViewGroupHandler {
    @Override
    public boolean paintConstraints(@NotNull ScreenView screenView, @NotNull Graphics2D graphics, @NotNull NlComponent component2) {
        NlGraphics g = new NlGraphics(graphics, screenView);
        List<NlComponent> iterable = component2.getChildren();
        ArrayList children = Lists.newArrayList(iterable);
        ConstraintPainter.paintSelectionFeedback(g, component2, children, true, TextDirection.LEFT_TO_RIGHT);
        return false;
    }

    @Override
    @Nullable
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull SceneComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        final RelativeDragHandler moveHandler = new RelativeDragHandler(editor, layout, components);
        return new DragHandler(editor, this, layout, components, type){

            @Override
            @Nullable
            public String update(int x, int y, int modifiers) {
                super.update(x, y, modifiers);
                if (this.components.isEmpty()) {
                    return null;
                }
                NlComponent primary = (NlComponent)this.components.get(0);
                int deltaX = this.lastX;
                int deltaY = this.lastY;
                if (!primary.isRoot()) {
                    deltaX -= this.startX;
                    deltaY -= this.startY;
                } else {
                    deltaX -= this.editor.pxToDp(NlComponentHelperKt.getW(primary) / 2);
                    deltaY -= this.editor.pxToDp(NlComponentHelperKt.getH(primary) / 2);
                }
                moveHandler.updateMove(primary, deltaX, deltaY, modifiers);
                return null;
            }

            @Override
            public void paint(@NotNull NlGraphics graphics) {
                GuidelinePainter.paint(graphics, moveHandler);
            }

            @Override
            public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
                moveHandler.removeCycles();
                NlComponent previous = null;
                for (NlComponent component2 : this.components) {
                    NlComponent finalPrevious = previous;
                    NlWriteCommandAction.run(component2, this.type.getDescription(), () -> {
                        if (finalPrevious == null) {
                            moveHandler.applyConstraints(component2);
                        } else {
                            moveHandler.attachPrevious(finalPrevious, component2);
                        }
                    });
                    previous = component2;
                }
                this.insertAddedComponents(insertType);
            }

            private void insertAddedComponents(@NotNull InsertType insertType) {
                List<NlComponent> added = this.components.stream().filter(component2 -> component2.getParent() != this.layout.getNlComponent()).collect(Collectors.toList());
                this.editor.getModel().addComponents(added, this.layout.getNlComponent(), null, insertType);
            }
        };
    }

    @Override
    @Nullable
    public ResizeHandler createResizeHandler(@NotNull ViewEditor editor, @NotNull NlComponent component2, @Nullable SegmentType horizontalEdgeType, @Nullable SegmentType verticalEdgeType) {
        NlComponent parent = component2.getParent();
        if (parent == null) {
            return null;
        }
        final RelativeResizeHandler resizeHandler = new RelativeResizeHandler(editor, parent, component2, horizontalEdgeType, verticalEdgeType);
        return new ResizeHandler(editor, this, component2, horizontalEdgeType, verticalEdgeType){

            @Override
            @Nullable
            public String update(int x, int y, int modifiers, @NotNull Rectangle newBounds) {
                super.update(x, y, modifiers, newBounds);
                resizeHandler.updateResize(this.component, newBounds, modifiers);
                return null;
            }

            @Override
            public void commit(int px, int py, int modifiers, @NotNull Rectangle newBounds) {
                resizeHandler.removeCycles();
                resizeHandler.applyConstraints(this.component);
            }

            @Override
            public void paint(@NotNull NlGraphics graphics) {
                GuidelinePainter.paint(graphics, resizeHandler);
            }
        };
    }

    @Override
    @Nullable
    public Interaction createInteraction(@NotNull ScreenView screenView, @NotNull NlComponent layout) {
        SelectionModel selectionModel = screenView.getSelectionModel();
        if (selectionModel.getSelection().isEmpty()) {
            selectionModel.setSelection(Collections.singletonList(layout));
        }
        return super.createInteraction(screenView, layout);
    }
}

