/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.menu;

import android.view.View;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NavigationViewSceneView
extends ScreenView {
    public static final String SHOW_IN_ATTRIBUTE_VALUE = "navigation_view";

    public NavigationViewSceneView(@NotNull NlDesignSurface surface, @NotNull NlModel model) {
        super(surface, ScreenView.ScreenViewType.NORMAL, model);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize(@Nullable Dimension size) {
        RenderResult result;
        if (size == null) {
            size = new Dimension();
        }
        if ((result = this.getResult()) == null) {
            return size;
        }
        List<ViewInfo> views = result.getRootViews();
        if (views.isEmpty()) {
            return size;
        }
        Object view = views.get(0).getViewObject();
        try {
            size.setSize(NavigationViewSceneView.getWidth(view), NavigationViewSceneView.getHeight(view));
            return size;
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static int getWidth(@NotNull Object view) throws ReflectiveOperationException {
        return (Integer)View.class.getDeclaredMethod("getWidth", new Class[0]).invoke(view, new Object[0]);
    }

    private static int getHeight(@NotNull Object view) throws ReflectiveOperationException {
        return (Integer)View.class.getDeclaredMethod("getHeight", new Class[0]).invoke(view, new Object[0]);
    }

    @Override
    @NotNull
    public Shape getScreenShape() {
        Dimension size = this.getSize();
        return new Rectangle(this.getX(), this.getY(), size.width, size.height);
    }
}

