/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.menu;

import com.android.resources.ResourceType;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.menu.MenuHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SearchItemHandler
extends MenuHandler {
    private static final String SEARCH_ICON = "ic_search_black_24dp";

    static boolean handles(@NotNull NlAttributesHolder item) {
        return "@drawable/ic_search_black_24dp".equals(item.getAndroidAttribute("icon"));
    }

    static void onChildInserted(@NotNull ViewEditor editor) {
        if (!editor.moduleContainsResource(ResourceType.DRAWABLE, SEARCH_ICON)) {
            editor.copyVectorAssetToMainModuleSourceSet(SEARCH_ICON);
        }
    }

    @Override
    public boolean onCreate(@NotNull ViewEditor editor, @Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType type) {
        if (!super.onCreate(editor, parent, newChild, type)) {
            return false;
        }
        if (!type.equals((Object)InsertType.CREATE)) {
            return true;
        }
        String value = editor.getMinSdkVersion().getApiLevel() < 11 ? "android.support.v7.widget.SearchView" : "android.widget.SearchView";
        newChild.setAndroidAttribute("actionViewClass", value);
        return true;
    }
}

