/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup;

import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.surface.MockupLayer;
import com.android.tools.pixelprobe.Image;
import com.android.tools.pixelprobe.PixelProbe;
import com.android.tools.pixelprobe.decoder.Decoder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.WeakHashMap;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockupFileHelper {
    public static final Set<String> VALID_EXTENSION = new HashSet<String>(Arrays.asList("psd", "png", "jpg"));
    public static final Logger LOGGER = Logger.getInstance(MockupFileHelper.class);
    private static final WeakHashMap<String, Image> IMAGE_CACHE = new WeakHashMap();

    @Nullable
    public static Image openImageFile(String path) {
        Image image = null;
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        if (IMAGE_CACHE.containsKey((Object)path)) {
            return (Image)IMAGE_CACHE.get((Object)path);
        }
        try (FileInputStream in = new FileInputStream(file);){
            image = PixelProbe.probe((InputStream)in, (Decoder.Options)Decoder.Options.LAYER_METADATA_ONLY);
            IMAGE_CACHE.put((Object)path, (Object)image);
        }
        catch (IOException e) {
            Logger.getInstance(MockupLayer.class).error((Throwable)e);
        }
        return image;
    }

    @NotNull
    public static FileChooserDescriptor getFileChooserDescriptor() {
        return FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withFileFilter(file -> VALID_EXTENSION.contains(file.getExtension())).withTitle("Choose Mockup File").withDescription("PSD, JPEG, PNG are accepted");
    }

    public static void writePositionToXML(@NotNull Mockup mockup) {
        NlComponent component2 = mockup.getComponent();
        if (component2 == null) {
            return;
        }
        NlWriteCommandAction.run(component2, "Edit Mockup Crop", () -> {
            if (mockup.isFullScreen()) {
                component2.removeAttribute("http://schemas.android.com/tools", "mockup_crop");
            } else {
                component2.setAttribute("http://schemas.android.com/tools", "mockup_crop", MockupFileHelper.getPositionString(mockup));
            }
        });
    }

    public static String getPositionString(@NotNull Mockup mockup) {
        Rectangle bounds = mockup.getBounds();
        Rectangle crop = mockup.getCropping();
        String cropping = bounds.equals(new Rectangle(0, 0, -1, -1)) ? String.format(Locale.US, "%d %d %d %d", crop.x, crop.y, crop.width, crop.height) : String.format(Locale.US, "%d %d %d %d %d %d %d %d", crop.x, crop.y, crop.width, crop.height, bounds.x, bounds.y, bounds.width, bounds.height);
        return cropping;
    }

    @Nullable
    public static Path getXMLFilePath(@NotNull Project project, @NotNull String filePath) {
        String basePath = project.getBasePath();
        if (basePath == null) {
            return null;
        }
        Path path = null;
        Path projectDirectory = Paths.get(basePath, new String[0]).normalize();
        try {
            path = MockupFileHelper.getFullFilePath(project, filePath);
            if (path != null && path.startsWith(projectDirectory)) {
                return projectDirectory.relativize(path).normalize();
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("Incorrect File Path : %s", filePath));
        }
        return path;
    }

    @Nullable
    public static Path getFullFilePath(Project project, String filePath) {
        String basePath = project.getBasePath();
        if (filePath == null || filePath.isEmpty() || basePath == null) {
            return null;
        }
        Path projectDirectory = Paths.get(basePath, new String[0]).normalize();
        try {
            Path path = Paths.get(filePath, new String[0]);
            if (!path.isAbsolute()) {
                path = projectDirectory.resolve(path).normalize();
            }
            return path.normalize();
        }
        catch (Exception e) {
            LOGGER.error(String.format("Incorrect File Path : %s", filePath));
            return null;
        }
    }
}

